/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.template;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.search.FilterBuilder;
import org.apache.directory.ldap.client.template.ModelFactory;
import org.apache.directory.ldap.client.template.exception.LdapRuntimeException;

class ModelFactoryImpl
implements ModelFactory {
    ModelFactoryImpl() {
    }

    @Override
    public AddRequest newAddRequest(Entry entry) {
        return new AddRequestImpl().setEntry(entry);
    }

    @Override
    public Attribute newAttribute(String name) {
        return new DefaultAttribute(name);
    }

    @Override
    public Attribute newAttribute(String name, byte[] ... values) {
        return new DefaultAttribute(name, values);
    }

    @Override
    public Attribute newAttribute(String name, String ... values) {
        return new DefaultAttribute(name, values);
    }

    @Override
    public Attribute newAttribute(String name, Value ... values) {
        return new DefaultAttribute(name, values);
    }

    @Override
    public DeleteRequest newDeleteRequest(Dn dn) {
        return new DeleteRequestImpl().setName(dn);
    }

    @Override
    public Dn newDn(String dn) {
        try {
            return new Dn(new String[]{dn});
        }
        catch (LdapInvalidDnException e) {
            throw new LdapRuntimeException((LdapException)((Object)e));
        }
    }

    @Override
    public Entry newEntry(String dn) {
        return this.newEntry(this.newDn(dn));
    }

    @Override
    public Entry newEntry(Dn dn) {
        return new DefaultEntry(dn);
    }

    @Override
    public ModifyRequest newModifyRequest(String dn) {
        return this.newModifyRequest(this.newDn(dn));
    }

    @Override
    public ModifyRequest newModifyRequest(Dn dn) {
        return new ModifyRequestImpl().setName(dn);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, FilterBuilder filter, SearchScope scope) {
        return this.newSearchRequest(this.newDn(baseDn), filter.toString(), scope);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, String filter, SearchScope scope) {
        return this.newSearchRequest(this.newDn(baseDn), filter, scope);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, FilterBuilder filter, SearchScope scope) {
        return this.newSearchRequest(baseDn, filter.toString(), scope, (String[])null);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, String filter, SearchScope scope) {
        return this.newSearchRequest(baseDn, filter, scope, (String[])null);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, FilterBuilder filter, SearchScope scope, String ... attributes) {
        return this.newSearchRequest(this.newDn(baseDn), filter.toString(), scope, attributes);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, String filter, SearchScope scope, String ... attributes) {
        return this.newSearchRequest(this.newDn(baseDn), filter, scope, attributes);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, FilterBuilder filter, SearchScope scope, String ... attributes) {
        return this.newSearchRequest(baseDn, filter.toString(), scope, attributes);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, String filter, SearchScope scope, String ... attributes) {
        SearchRequest searchRequest = null;
        try {
            searchRequest = new SearchRequestImpl().setBase(baseDn).setFilter(filter).setScope(scope == null ? SearchScope.OBJECT : scope);
            if (attributes != null && attributes.length > 0) {
                searchRequest.addAttributes(attributes);
            }
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        return searchRequest;
    }
}

