/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials.extractor;

import java.util.Optional;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.logout.impl.SAML2LogoutResponseBuilder;
import org.pac4j.saml.logout.impl.SAML2LogoutResponseMessageSender;
import org.pac4j.saml.profile.api.SAML2ProfileHandler;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2CredentialsExtractor
implements CredentialsExtractor<SAML2Credentials> {
    protected final SAMLContextProvider contextProvider;
    protected final SAML2ProfileHandler<AuthnRequest> profileHandler;
    protected final SAML2ProfileHandler<LogoutRequest> logoutProfileHandler;
    protected final String spLogoutResponseBindingType;
    protected SAML2LogoutResponseBuilder saml2LogoutResponseBuilder;
    protected final SAML2LogoutResponseMessageSender saml2LogoutResponseMessageSender;

    public SAML2CredentialsExtractor(SAML2Client client) {
        this.contextProvider = client.getContextProvider();
        this.profileHandler = client.getProfileHandler();
        this.logoutProfileHandler = client.getLogoutProfileHandler();
        this.spLogoutResponseBindingType = client.getConfiguration().getSpLogoutResponseBindingType();
        this.saml2LogoutResponseBuilder = new SAML2LogoutResponseBuilder(this.spLogoutResponseBindingType);
        this.saml2LogoutResponseMessageSender = new SAML2LogoutResponseMessageSender(client.getSignatureSigningParametersProvider(), this.spLogoutResponseBindingType, false, client.getConfiguration().isSpLogoutRequestSigned());
    }

    public Optional<SAML2Credentials> extract(WebContext context) {
        boolean logoutEndpoint = context.getRequestParameter("logoutendpoint").isPresent();
        SAML2MessageContext samlContext = this.contextProvider.buildContext(context);
        if (logoutEndpoint) {
            this.logoutProfileHandler.receive(samlContext);
            LogoutResponse logoutResponse = this.saml2LogoutResponseBuilder.build(samlContext);
            this.saml2LogoutResponseMessageSender.sendMessage(samlContext, logoutResponse, samlContext.getSAMLBindingContext().getRelayState());
            Pac4jSAMLResponse adapter = samlContext.getProfileRequestContextOutboundMessageTransportResponse();
            if (this.spLogoutResponseBindingType.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
                String content = adapter.getOutgoingContent();
                throw RedirectionActionHelper.buildFormPostContentAction((WebContext)context, (String)content);
            }
            String location = adapter.getRedirectUrl();
            throw RedirectionActionHelper.buildRedirectUrlAction((WebContext)context, (String)location);
        }
        SAML2Credentials credentials = (SAML2Credentials)this.profileHandler.receive(samlContext);
        return Optional.ofNullable(credentials);
    }

    public SAML2LogoutResponseBuilder getSaml2LogoutResponseBuilder() {
        return this.saml2LogoutResponseBuilder;
    }

    public void setSaml2LogoutResponseBuilder(SAML2LogoutResponseBuilder saml2LogoutResponseBuilder) {
        this.saml2LogoutResponseBuilder = saml2LogoutResponseBuilder;
    }
}

