/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.List;
import java.util.Optional;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.client.finder.DefaultCallbackClientFinder;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.engine.AbstractExceptionAwareLogic;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.savedrequest.DefaultSavedRequestHandler;
import org.pac4j.core.engine.savedrequest.SavedRequestHandler;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCallbackLogic<R, C extends WebContext>
extends AbstractExceptionAwareLogic<R, C>
implements CallbackLogic<R, C> {
    public static final DefaultCallbackLogic INSTANCE = new DefaultCallbackLogic();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCallbackLogic.class);
    private ClientFinder clientFinder = new DefaultCallbackClientFinder();
    private SavedRequestHandler savedRequestHandler = new DefaultSavedRequestHandler();

    @Override
    public R perform(C context, Config config, HttpActionAdapter<R, C> httpActionAdapter, String inputDefaultUrl, Boolean inputSaveInSession, Boolean inputMultiProfile, Boolean inputRenewSession, String client) {
        HttpAction action;
        LOGGER.debug("=== CALLBACK ===");
        try {
            String defaultUrl = inputDefaultUrl == null ? "/" : inputDefaultUrl;
            boolean saveInSession = inputSaveInSession == null || inputSaveInSession != false;
            boolean multiProfile = inputMultiProfile != null && inputMultiProfile != false;
            boolean renewSession = inputRenewSession == null || inputRenewSession != false;
            CommonHelper.assertNotNull("clientFinder", this.clientFinder);
            CommonHelper.assertNotNull("context", context);
            CommonHelper.assertNotNull("config", config);
            CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
            CommonHelper.assertNotBlank("defaultUrl", defaultUrl);
            Clients clients = config.getClients();
            CommonHelper.assertNotNull("clients", clients);
            List<Client<? extends Credentials>> foundClients = this.clientFinder.find(clients, (WebContext)context, client);
            CommonHelper.assertTrue(foundClients != null && foundClients.size() == 1, "unable to find one indirect client for the callback: check the callback URL for a client name parameter or suffix path or ensure that your configuration defaults to one indirect client");
            Client<? extends Credentials> foundClient = foundClients.get(0);
            LOGGER.debug("foundClient: {}", foundClient);
            CommonHelper.assertNotNull("foundClient", foundClient);
            Optional<? extends Credentials> credentials = foundClient.getCredentials((WebContext)context);
            LOGGER.debug("credentials: {}", credentials);
            Optional<UserProfile> profile = foundClient.getUserProfile(credentials.orElse(null), (WebContext)context);
            LOGGER.debug("profile: {}", profile);
            if (profile.isPresent()) {
                this.saveUserProfile(context, config, profile.get(), saveInSession, multiProfile, renewSession);
            }
            action = this.redirectToOriginallyRequestedUrl(context, defaultUrl);
        }
        catch (RuntimeException e) {
            return this.handleException(e, httpActionAdapter, context);
        }
        return httpActionAdapter.adapt(action, context);
    }

    protected void saveUserProfile(C context, Config config, UserProfile profile, boolean saveInSession, boolean multiProfile, boolean renewSession) {
        ProfileManager<UserProfile> manager = this.getProfileManager(context);
        if (profile != null) {
            manager.save(saveInSession, profile, multiProfile);
            if (renewSession) {
                this.renewSession(context, config);
            }
        }
    }

    protected void renewSession(C context, Config config) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore != null) {
            String oldSessionId = sessionStore.getOrCreateSessionId(context);
            boolean renewed = sessionStore.renewSession(context);
            if (renewed) {
                String newSessionId = sessionStore.getOrCreateSessionId(context);
                LOGGER.debug("Renewing session: {} -> {}", (Object)oldSessionId, (Object)newSessionId);
                Clients clients = config.getClients();
                if (clients != null) {
                    List<Client> clientList = clients.getClients();
                    for (Client client : clientList) {
                        BaseClient baseClient = (BaseClient)client;
                        baseClient.notifySessionRenewal(oldSessionId, (WebContext)context);
                    }
                }
            } else {
                LOGGER.error("Unable to renew the session. The session store may not support this feature");
            }
        } else {
            LOGGER.error("No session store available for this web context");
        }
    }

    protected HttpAction redirectToOriginallyRequestedUrl(C context, String defaultUrl) {
        return this.savedRequestHandler.restore((WebContext)context, defaultUrl);
    }

    public ClientFinder getClientFinder() {
        return this.clientFinder;
    }

    public void setClientFinder(ClientFinder clientFinder) {
        this.clientFinder = clientFinder;
    }

    public SavedRequestHandler getSavedRequestHandler() {
        return this.savedRequestHandler;
    }

    public void setSavedRequestHandler(SavedRequestHandler savedRequestHandler) {
        this.savedRequestHandler = savedRequestHandler;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "clientFinder", this.clientFinder, "errorUrl", this.getErrorUrl(), "savedRequestHandler", this.savedRequestHandler);
    }
}

