/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.util.Strings;

class PageIO {
    private ByteBuffer data;
    private long nextPage = -2L;
    private int size = -1;
    private long offset;

    PageIO() {
        this.offset = -1L;
    }

    PageIO(long offset) {
        this.offset = offset;
    }

    ByteBuffer getData() {
        return this.data;
    }

    void setData(ByteBuffer data) {
        this.data = data;
        this.nextPage = data.getLong(0);
    }

    long getNextPage() {
        return this.nextPage;
    }

    void setNextPage(long nextPage) {
        this.nextPage = nextPage;
        this.data.putLong(0, nextPage);
    }

    long getSize() {
        return this.size;
    }

    void setSize(int size) {
        this.data.putInt(8, size);
        this.size = size;
    }

    void setSize() {
        this.size = this.data.getInt(8);
    }

    long getOffset() {
        return this.offset;
    }

    void setOffset(long offset) {
        this.offset = offset;
    }

    PageIO copy(PageIO copy) {
        copy.data = this.data.isDirect() ? ByteBuffer.allocateDirect(this.data.capacity()) : ByteBuffer.allocate(this.data.capacity());
        int start = this.data.position();
        int limit = this.data.limit();
        this.data.position(0);
        this.data.limit(this.data.capacity());
        copy.data.put(this.data);
        this.data.position(start);
        this.data.limit(limit);
        copy.data.position(start);
        copy.data.limit(limit);
        copy.size = this.size;
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PageIO[offset:0x").append(Long.toHexString(this.offset));
        if (this.size != -1) {
            sb.append(", size:").append(this.size);
        }
        if (this.nextPage != -1L) {
            sb.append(", next:0x").append(Long.toHexString(this.nextPage));
        }
        sb.append("]");
        int start = 0;
        byte[] array = null;
        this.data.mark();
        this.data.position(0);
        if (this.data.isDirect()) {
            array = new byte[this.data.capacity()];
            this.data.get(array);
        } else {
            array = this.data.array();
        }
        this.data.reset();
        for (int i = start; i < array.length; ++i) {
            if ((i - start) % 16 == 0) {
                sb.append("\n    ");
            }
            sb.append(Strings.dumpByte(array[i])).append(" ");
        }
        return sb.toString();
    }
}

