/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.authorization.authorizer;

import java.util.List;
import java.util.regex.Pattern;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpRegexpAuthorizer
implements Authorizer<CommonProfile> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String regexPattern;
    private Pattern pattern;

    public IpRegexpAuthorizer() {
    }

    public IpRegexpAuthorizer(String regexpPattern) {
        this.setRegexpPattern(regexpPattern);
    }

    public boolean isAuthorized(WebContext context, List<CommonProfile> profile) {
        CommonHelper.assertNotNull((String)"pattern", (Object)this.pattern);
        String ip = context.getRemoteAddr();
        return this.pattern.matcher(ip).matches();
    }

    public void setRegexpPattern(String regexpPattern) {
        this.regexPattern = regexpPattern;
        this.pattern = Pattern.compile(regexpPattern);
    }

    public String toString() {
        return "IpRegexpAuthorizer[" + this.regexPattern + "]";
    }
}

