/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder.property.interpreter;

import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.builder.property.interpreter.AbstractInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;
import org.apache.knox.gateway.topology.builder.property.interpreter.ProviderPropertyInterpreter;

public class GatewayPropertyInterpreter
extends AbstractInterpreter {
    private static final String AGGREGATOR_PROVIDER = "provider";
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private Topology topology;

    public GatewayPropertyInterpreter(Topology topology) {
        if (topology == null) {
            throw new IllegalArgumentException(gatewayResources.topologyIsRequiredError());
        }
        this.topology = topology;
    }

    @Override
    public void interpret(String token, String value) throws InterpretException {
        String nextToken;
        int firstDotPosition = token.indexOf(".");
        if (firstDotPosition != -1) {
            String aggregator = token.substring(0, firstDotPosition);
            nextToken = token.substring(firstDotPosition + 1);
            if (!AGGREGATOR_PROVIDER.equalsIgnoreCase(aggregator)) {
                throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
            }
        } else {
            throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
        }
        new ProviderPropertyInterpreter(this.topology).interpret(nextToken, value);
    }
}

