/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.gen.OctetSequenceKeyGenerator;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.config.impl.GatewayConfigImpl;
import org.apache.knox.gateway.deploy.DeploymentFactory;
import org.apache.knox.gateway.services.CLIGatewayServices;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClient;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.validation.TopologyValidator;
import org.apache.knox.gateway.util.PasswordUtils;
import org.apache.knox.gateway.util.TopologyToDescriptor;
import org.apache.knox.gateway.util.X509CertificateUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.eclipse.persistence.oxm.MediaType;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;

public class KnoxCLI
extends Configured
implements Tool {
    private static final Collection<String> SUPPORTED_JWK_ALGORITHMS = Stream.of(JWSAlgorithm.HS256.getName(), JWSAlgorithm.HS384.getName(), JWSAlgorithm.HS512.getName()).collect(Collectors.toSet());
    private static final String USAGE_PREFIX = "KnoxCLI {cmd} [options]";
    private static final String COMMANDS = "   [--help]\n   [version]\n   [create-master [--force] [--master mastersecret] [--generate]]\n   [create-cert [--force] [--hostname h]]\n   [export-cert [--type PEM|JKS|JCEKS|PKCS12]]\n   [create-alias aliasname [--cluster clustername] [ (--value v) | (--generate) ]]\n   [create-aliases --alias alias1 [--value value1] --alias alias2 [--value value2] --alias aliasN [--value valueN] ... [--cluster clustername] [--generate]]\n   [delete-alias aliasname [--cluster clustername]]\n   [list-alias [--cluster clustername]]\n   [redeploy [--cluster clustername]]\n   [list-topologies]\n   [validate-topology [--cluster clustername] | [--path \"path/to/file\"]]\n   [user-auth-test [--cluster clustername] [--u username] [--p password] [--g]]\n   [system-user-auth-test [--cluster clustername] [--d]]\n   [service-test [--u username] [--p password] [--cluster clustername] [--hostname name] [--port port]]\n   [list-registry-clients]\n   [list-provider-configs --registry-client name]\n   [upload-provider-config providerConfigFile --registry-client name [--entry-name entryName]]\n   [list-descriptors --registry-client name]\n   [upload-descriptor descriptorFile --registry-client name [--entry-name entryName]]\n   [delete-provider-config providerConfig --registry-client name]\n   [delete-descriptor descriptor --registry-client name]\n   [get-registry-acl entry --registry-client name]\n   [convert-topology --path \"path/to/topology.xml\" --provider-name my-provider.json [--descriptor-name my-descriptor.json] [--topology-name topologyName] [--output-path \"path/to/configs/\"] [--force] [--cluster clusterName] [--discovery-url url] [--discovery-user discoveryUser] [--discovery-pwd-alias discoveryPasswordAlias] [--discovery-type discoveryType]]\n   [generate-jwk [--jwkAlg HS256|HS384|HS512] [--saveAlias alias] [--topology topology]]\n";
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    private static GatewayServices services = new CLIGatewayServices();
    private Command command;
    private String value;
    private String cluster;
    private String path;
    private String generate = "false";
    private String hostname;
    private String port;
    private boolean force;
    private boolean debug;
    private String user;
    private String pass;
    private boolean groups;
    private JWSAlgorithm jwsAlgorithm = JWSAlgorithm.HS256;
    private String alias;
    private String remoteRegistryClient;
    private String remoteRegistryEntryName;
    private String type;
    private String topologyName;
    private String providerName;
    private String descriptorName;
    private String outputDir;
    private String discoveryUrl;
    private String discoveryUser;
    private String discoveryPasswordAlias;
    private String discoveryType;
    private String master;

    public int run(String[] args) throws Exception {
        int exitCode = 0;
        try {
            exitCode = this.init(args);
            if (exitCode != 0) {
                return exitCode;
            }
            if (this.command != null && this.command.validate()) {
                this.initializeServices(this.command instanceof MasterCreateCommand);
                this.command.execute();
            } else if (!(this.command instanceof MasterCreateCommand)) {
                this.out.println("ERROR: Invalid Command\nUnrecognized option:" + args[0] + "\nA fatal exception has occurred. Program will exit.");
                exitCode = -2;
            }
        }
        catch (ServiceLifecycleException sle) {
            this.out.println("ERROR: Internal Error: Please refer to the knoxcli.log file for details. " + sle.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
            this.err.flush();
            return -3;
        }
        return exitCode;
    }

    public static synchronized GatewayServices getGatewayServices() {
        return services;
    }

    private void initializeServices(boolean persisting) throws ServiceLifecycleException {
        GatewayConfig config = this.getGatewayConfig();
        if (config.isHadoopKerberosSecured()) {
            KnoxCLI.configureKerberosSecurity(config);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("persist-master", Boolean.toString(persisting));
        if (this.master != null) {
            options.put("master", this.master);
        }
        services.init(config, options);
    }

    private int init(String[] args) throws IOException {
        if (args.length == 0) {
            this.printKnoxShellUsage();
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            String entry;
            String fileName;
            String alias;
            if (args[i].equals("create-master")) {
                this.command = new MasterCreateCommand();
                if (args.length <= i + 1 || !args[i + 1].equals("--help")) continue;
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("delete-alias")) {
                alias = null;
                if (args.length >= 2) {
                    alias = args[++i];
                }
                this.command = new AliasDeleteCommand(alias);
                if (alias != null && !"--help".equals(alias)) continue;
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("create-alias")) {
                alias = null;
                if (args.length >= 2) {
                    alias = args[++i];
                }
                this.command = new AliasCreateCommand(alias);
                if (alias != null && !"--help".equals(alias)) continue;
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("create-aliases")) {
                this.command = new BatchAliasCreateCommand();
                if (args.length >= 3 && !"--help".equals(this.alias)) continue;
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("create-cert")) {
                this.command = new CertCreateCommand();
                if (args.length <= i + 1 || !args[i + 1].equals("--help")) continue;
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("export-cert")) {
                this.command = new CertExportCommand();
                if (args.length <= i + 1 || !args[i + 1].equals("--help")) continue;
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("user-auth-test")) {
                if (i + 1 >= args.length) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.command = new LDAPAuthCommand();
                continue;
            }
            if (args[i].equals("system-user-auth-test")) {
                if (i + 1 >= args.length) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.command = new LDAPSysBindCommand();
                continue;
            }
            if (args[i].equals("list-alias")) {
                this.command = new AliasListCommand();
                continue;
            }
            if (args[i].equals("--value")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.value = args[++i];
                if (this.command instanceof MasterCreateCommand) {
                    this.master = this.value;
                    continue;
                }
                if (!(this.command instanceof BatchAliasCreateCommand)) continue;
                ((BatchAliasCreateCommand)this.command).addValue(this.value);
                continue;
            }
            if (args[i].equals("--alias")) {
                if (this.command instanceof BatchAliasCreateCommand) {
                    ((BatchAliasCreateCommand)this.command).addName(args[++i]);
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("version")) {
                this.command = new VersionCommand();
                continue;
            }
            if (args[i].equals("redeploy")) {
                this.command = new RedeployCommand();
                continue;
            }
            if (args[i].equals("validate-topology")) {
                if (i + 1 >= args.length) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.command = new ValidateTopologyCommand();
                continue;
            }
            if (args[i].equals("list-topologies")) {
                this.command = new ListTopologiesCommand();
                continue;
            }
            if (args[i].equals("--cluster") || args[i].equals("--topology")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.cluster = args[++i];
                continue;
            }
            if (args[i].equals("service-test")) {
                if (i + 1 >= args.length) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.command = new ServiceTestCommand();
                continue;
            }
            if (args[i].equals("--generate")) {
                if (this.command instanceof MasterCreateCommand) {
                    this.master = UUID.randomUUID().toString();
                    continue;
                }
                this.generate = "true";
                continue;
            }
            if (args[i].equals("--type")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.type = args[++i];
                continue;
            }
            if (args[i].equals("--path")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.path = args[++i];
                continue;
            }
            if (args[i].equals("--hostname")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.hostname = args[++i];
                continue;
            }
            if (args[i].equals("--port")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.port = args[++i];
                continue;
            }
            if (args[i].equals("--provider-name")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.providerName = args[++i];
                continue;
            }
            if (args[i].equals("--topology-name")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.topologyName = args[++i];
                continue;
            }
            if (args[i].equals("--descriptor-name")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.descriptorName = args[++i];
                continue;
            }
            if (args[i].equals("--output-dir")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.outputDir = args[++i];
                continue;
            }
            if (args[i].equals("--discovery-url")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.discoveryUrl = args[++i];
                continue;
            }
            if (args[i].equals("--discovery-user")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.discoveryUser = args[++i];
                continue;
            }
            if (args[i].equals("--discovery-pwd-alias")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.discoveryPasswordAlias = args[++i];
                continue;
            }
            if (args[i].equals("--discovery-type")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.discoveryType = args[++i];
                continue;
            }
            if (args[i].equals("--master")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.master = args[++i];
                continue;
            }
            if (args[i].equals("--force")) {
                this.force = true;
                continue;
            }
            if (args[i].equals("--help")) {
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("--d")) {
                this.debug = true;
                continue;
            }
            if (args[i].equals("--u")) {
                if (i + 1 <= args.length) {
                    this.user = args[++i];
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("--p")) {
                if (i + 1 <= args.length) {
                    this.pass = args[++i];
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("--g")) {
                this.groups = true;
                continue;
            }
            if (args[i].equals("list-registry-clients")) {
                this.command = new RemoteRegistryClientsListCommand();
                continue;
            }
            if (args[i].equals("--registry-client")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.remoteRegistryClient = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("list-provider-configs")) {
                this.command = new RemoteRegistryListProviderConfigsCommand();
                continue;
            }
            if (args[i].equalsIgnoreCase("list-descriptors")) {
                this.command = new RemoteRegistryListDescriptorsCommand();
                continue;
            }
            if (args[i].equalsIgnoreCase("upload-provider-config")) {
                if (i <= args.length - 1) {
                    fileName = args[++i];
                    this.command = new RemoteRegistryUploadProviderConfigCommand(fileName);
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("upload-descriptor")) {
                if (i <= args.length - 1) {
                    fileName = args[++i];
                    this.command = new RemoteRegistryUploadDescriptorCommand(fileName);
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("--entry-name")) {
                if (i <= args.length - 1) {
                    this.remoteRegistryEntryName = args[++i];
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("delete-descriptor")) {
                if (i <= args.length - 1) {
                    entry = args[++i];
                    this.command = new RemoteRegistryDeleteDescriptorCommand(entry);
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equals("delete-provider-config")) {
                if (i <= args.length - 1) {
                    entry = args[++i];
                    this.command = new RemoteRegistryDeleteProviderConfigCommand(entry);
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equalsIgnoreCase("get-registry-acl")) {
                if (i <= args.length - 1) {
                    entry = args[++i];
                    this.command = new RemoteRegistryGetACLCommand(entry);
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equalsIgnoreCase("convert-topology")) {
                if (args.length >= 5) {
                    this.command = new TopologyConverter();
                    continue;
                }
                this.printKnoxShellUsage();
                return -1;
            }
            if (args[i].equalsIgnoreCase("generate-jwk")) {
                this.command = new JWKGenerator();
                continue;
            }
            if (args[i].equalsIgnoreCase("--jwkAlg")) {
                String algName;
                if (!SUPPORTED_JWK_ALGORITHMS.contains(algName = args[++i])) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.jwsAlgorithm = JWSAlgorithm.parse((String)algName);
                continue;
            }
            if (args[i].equalsIgnoreCase("--saveAlias")) {
                this.alias = args[++i];
                continue;
            }
            this.printKnoxShellUsage();
            return -1;
        }
        return 0;
    }

    private void printKnoxShellUsage() {
        this.out.println("KnoxCLI {cmd} [options]\n   [--help]\n   [version]\n   [create-master [--force] [--master mastersecret] [--generate]]\n   [create-cert [--force] [--hostname h]]\n   [export-cert [--type PEM|JKS|JCEKS|PKCS12]]\n   [create-alias aliasname [--cluster clustername] [ (--value v) | (--generate) ]]\n   [create-aliases --alias alias1 [--value value1] --alias alias2 [--value value2] --alias aliasN [--value valueN] ... [--cluster clustername] [--generate]]\n   [delete-alias aliasname [--cluster clustername]]\n   [list-alias [--cluster clustername]]\n   [redeploy [--cluster clustername]]\n   [list-topologies]\n   [validate-topology [--cluster clustername] | [--path \"path/to/file\"]]\n   [user-auth-test [--cluster clustername] [--u username] [--p password] [--g]]\n   [system-user-auth-test [--cluster clustername] [--d]]\n   [service-test [--u username] [--p password] [--cluster clustername] [--hostname name] [--port port]]\n   [list-registry-clients]\n   [list-provider-configs --registry-client name]\n   [upload-provider-config providerConfigFile --registry-client name [--entry-name entryName]]\n   [list-descriptors --registry-client name]\n   [upload-descriptor descriptorFile --registry-client name [--entry-name entryName]]\n   [delete-provider-config providerConfig --registry-client name]\n   [delete-descriptor descriptor --registry-client name]\n   [get-registry-acl entry --registry-client name]\n   [convert-topology --path \"path/to/topology.xml\" --provider-name my-provider.json [--descriptor-name my-descriptor.json] [--topology-name topologyName] [--output-path \"path/to/configs/\"] [--force] [--cluster clusterName] [--discovery-url url] [--discovery-user discoveryUser] [--discovery-pwd-alias discoveryPasswordAlias] [--discovery-type discoveryType]]\n   [generate-jwk [--jwkAlg HS256|HS384|HS512] [--saveAlias alias] [--topology topology]]\n");
        if (this.command != null) {
            this.out.println(this.command.getUsage());
        } else {
            char[] chars = new char[79];
            Arrays.fill(chars, '=');
            String div = new String(chars);
            this.out.println(div);
            this.out.println("version\n\nDisplays Knox version information.");
            this.out.println();
            this.out.println(div);
            this.out.println("create-master [--force] [--master mastersecret] [--generate]\n\nThe create-master command persists the master secret in a file located at:\n{GATEWAY_HOME}/data/security/master.\nIt will prompt the user for the secret to persist.\nUse --force to overwrite the master secret.\nUse --master to pass in a master secret to persist.\nThis can be used to persist the secret without any user interaction.\nBe careful as the secret might appear in shell histories or process listings.\nInstead of --master it is usually a better idea to use --generate instead!\nUse --generate to have Knox automatically generate a random secret.\nThe generated secret will not be printed or otherwise exposed.\nDo not specify both --master and --generate at the same time.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("create-cert [--force] [--hostname h]\n\nThe create-cert command populates the configured identity\nkeystore with a self-signed certificate to be used as the\ngateway identity. If a cert exists and it is determined to\nnot have been generated by Knox, --force must be specified\nto overwrite it.  If a self-signed cert is created, a\npassword for the key will be generated and stored in the\n__gateway-credentials.jceks credential store.");
            this.out.println();
            this.out.println(div);
            this.out.println("export-cert [--type PEM|JKS|JCEKS|PKCS12]\n\nThe export-cert command exports the public certificate\nfrom the a gateway.jks keystore with the alias of gateway-identity.\nIt will be exported to `{GATEWAY_HOME}/data/security/keystores/` with a name of `gateway-client-trust.<type>`Using the --type option you can specify which keystore type you need (default: PEM)\nNOTE: The password for the JKS, JCEKS and PKCS12 types is `changeit`.\nIt can be changed using: `keytool -storepasswd -storetype <type> -keystore gateway-client-trust.<type>`");
            this.out.println();
            this.out.println(div);
            this.out.println("create-alias aliasname [--cluster clustername] [ (--value v) | (--generate) ]\n\nThe create-alias command will create an alias\nand secret pair within the credential store for the\nindicated --cluster otherwise within the gateway\ncredential store. The actual secret may be specified via\nthe --value option or --generate (will create a random secret\nfor you) or user will be prompt to provide password.");
            this.out.println();
            this.out.println(div);
            this.out.println("delete-alias aliasname [--cluster clustername]\n\nThe delete-alias command removes the\nindicated alias from the --cluster specific\ncredential store or the gateway credential store.");
            this.out.println();
            this.out.println(div);
            this.out.println("list-alias [--cluster clustername]\n\nThe list-alias command lists all of the aliases\nfor the given hadoop --cluster. The default\n--cluster being the gateway itself.");
            this.out.println();
            this.out.println(div);
            this.out.println("redeploy [--cluster clustername]\n\nRedeploys one or all of the gateway's clusters (a.k.a topologies).");
            this.out.println();
            this.out.println(div);
            this.out.println("validate-topology [--cluster clustername] | [--path \"path/to/file\"]\n\nEnsures that a cluster's description (a.k.a topology) \nfollows the correct formatting rules.\nuse the list-topologies command to get a list of available cluster names");
            this.out.println();
            this.out.println(div);
            this.out.println("list-topologies\n\nRetrieves a list of the available topologies within the\ndefault topologies directory. Will return topologies that may not be deployed due\nerrors in file formatting.");
            this.out.println();
            this.out.println(div);
            this.out.println("user-auth-test [--cluster clustername] [--u username] [--p password] [--g]\n\nThis command tests a cluster's configuration ability to\n authenticate a user with a cluster's ShiroProvider settings.\n Use \"--g\" if you want to list the groups a user is a member of. \nOptional: [--u username]: Provide a username argument to the command\nOptional: [--p password]: Provide a password argument to the command.\nIf a username and password argument are not supplied, the terminal will prompt you for one.");
            this.out.println();
            this.out.println(div);
            this.out.println("system-user-auth-test [--cluster clustername] [--d]\n\nThis command tests a cluster configuration's ability to\n authenticate a user with a cluster's ShiroProvider settings.");
            this.out.println();
            this.out.println(div);
            this.out.println("service-test [--u username] [--p password] [--cluster clustername] [--hostname name] [--port port]\n\nThis command requires a running instance of Knox to be present on the same machine.\nIt will execute a test to make sure all services are accessible through the gateway URLs.\nErrors are reported and suggestions to resolve any problems are returned. JSON formatted.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("list-registry-clients\n\nLists all of the remote configuration registry clients defined in gateway-site.xml.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("get-registry-acl entry --registry-client name\n\nPresents the ACL settings for the specified remote registry entry.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("list-provider-configs --registry-client name\n\nLists the provider configurations present in the specified remote registry\n");
            this.out.println();
            this.out.println(div);
            this.out.println("list-descriptors --registry-client name\n\nLists the descriptors present in the specified remote registry\n");
            this.out.println();
            this.out.println(div);
            this.out.println("upload-provider-config providerConfigFile --registry-client name [--entry-name entryName]\n\nUploads a provider configuration to the specified remote registry client, optionally renaming the entry.\nIf the entry name is not specified, the name of the uploaded file is used.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("upload-descriptor descriptorFile --registry-client name [--entry-name entryName]\n\nUploads a simple descriptor using the specified remote registry client, optionally renaming the entry.\nIf the entry name is not specified, the name of the uploaded file is used.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("delete-provider-config providerConfig --registry-client name\n\nDeletes a shared provider configuration from the specified remote registry.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("delete-descriptor descriptor --registry-client name\n\nDeletes a simple descriptor from the specified remote registry.\n");
            this.out.println();
            this.out.println(div);
            this.out.println("convert-topology --path \"path/to/topology.xml\" --provider-name my-provider.json [--descriptor-name my-descriptor.json] [--topology-name topologyName] [--output-path \"path/to/configs/\"] [--force] [--cluster clusterName] [--discovery-url url] [--discovery-user discoveryUser] [--discovery-pwd-alias discoveryPasswordAlias] [--discovery-type discoveryType]\n\nConvert Knox topology file to provider and descriptor config files \nOptions are as follows: \n--path (required) path to topology xml file \n--provider-name (required) name of the provider json config file (including .json extension) \n--descriptor-name (optional) name of descriptor json config file (including .json extension) \n--topology-name (optional) topology-name can be use instead of --path option, if used, KnoxCLI will attempt to find topology from deployed topologies.\n\t if not provided topology name will be used as descriptor name \n--output-path (optional) output directory to save provider and descriptor config files \n\t if not provided config files will be saved in appropriate Knox config directory \n--force (optional) force rewriting of existing files, if not used, command will fail when the configs files with same name already exist. \n--cluster (optional) cluster name, required for service discovery \n--discovery-url (optional) service discovery URL, required for service discovery \n--discovery-user (optional) service discovery user, required for service discovery \n--discovery-pwd-alias (optional) password alias for service discovery user, required for service discovery \n--discovery-type (optional) service discovery type, required for service discovery \n");
            this.out.println();
            this.out.println(div);
            this.out.println("generate-jwk [--jwkAlg HS256|HS384|HS512] [--saveAlias alias] [--topology topology]\n\nGenerates a JSON Web Key using the supplied algorithm name and prints the generated key value on the screen. \nAs an alternative to displaying this possibly sensitive information on the screen you may want to save it as an alias.\nOptions are as follows: \n--jwkAlg (optional) defines the name of the desired JSON Web Signature algorithm name; defaults to HS256. Other accepted values are HS384 and HS512 \n--saveAlias (optional) if this is set, the given alias name is used to save the generated JWK instead of printing it on the screen \n--topology (optional) the name of the topology (aka. cluster) to be used when saving the JWK as an alias. If none specified, the alias is going to be saved for the Gateway \n");
            this.out.println();
            this.out.println(div);
        }
    }

    public static char[] promptUserForPassword() {
        boolean noMatch;
        char[] password = null;
        Console c = System.console();
        if (c == null) {
            System.err.println("No console to fetch password from user.Consider setting via --generate or --value.");
            System.exit(1);
        }
        do {
            char[] newPassword2;
            char[] newPassword1;
            boolean bl = noMatch = !Arrays.equals(newPassword1 = c.readPassword("Enter password: ", new Object[0]), newPassword2 = c.readPassword("Enter password again: ", new Object[0]));
            if (noMatch) {
                c.format("Passwords don't match. Try again.%n", new Object[0]);
            } else {
                password = Arrays.copyOf(newPassword1, newPassword1.length);
            }
            Arrays.fill(newPassword1, ' ');
            Arrays.fill(newPassword2, ' ');
        } while (noMatch);
        return password;
    }

    private GatewayConfig getGatewayConfig() {
        Configuration conf = this.getConf();
        Object result = conf instanceof GatewayConfig ? (GatewayConfig)conf : new GatewayConfigImpl();
        return result;
    }

    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        try (InputStream inputStream = KnoxCLI.class.getClassLoader().getResourceAsStream("build.properties");){
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new GatewayConfigImpl(), (Tool)new KnoxCLI(), (String[])args);
        System.exit(res);
    }

    private static void configureKerberosSecurity(GatewayConfig config) {
        System.setProperty("gateway.hadoop.kerberos.secured", "true");
        System.setProperty("java.security.krb5.conf", config.getKerberosConfig());
        System.setProperty("sun.security.krb5.debug", Boolean.toString(config.isKerberosDebugEnabled()));
        System.setProperty("java.security.auth.login.config", config.getKerberosLoginConfig());
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
    }

    static /* synthetic */ void access$2200(KnoxCLI x0) {
        x0.printKnoxShellUsage();
    }

    static /* synthetic */ String access$2300(KnoxCLI x0) {
        return x0.port;
    }

    public class JWKGenerator
    extends Command {
        public static final String USAGE = "generate-jwk [--jwkAlg HS256|HS384|HS512] [--saveAlias alias] [--topology topology]";
        public static final String DESC = "Generates a JSON Web Key using the supplied algorithm name and prints the generated key value on the screen. \nAs an alternative to displaying this possibly sensitive information on the screen you may want to save it as an alias.\nOptions are as follows: \n--jwkAlg (optional) defines the name of the desired JSON Web Signature algorithm name; defaults to HS256. Other accepted values are HS384 and HS512 \n--saveAlias (optional) if this is set, the given alias name is used to save the generated JWK instead of printing it on the screen \n--topology (optional) the name of the topology (aka. cluster) to be used when saving the JWK as an alias. If none specified, the alias is going to be saved for the Gateway \n";

        @Override
        public String getUsage() {
            return "generate-jwk [--jwkAlg HS256|HS384|HS512] [--saveAlias alias] [--topology topology]:\n\nGenerates a JSON Web Key using the supplied algorithm name and prints the generated key value on the screen. \nAs an alternative to displaying this possibly sensitive information on the screen you may want to save it as an alias.\nOptions are as follows: \n--jwkAlg (optional) defines the name of the desired JSON Web Signature algorithm name; defaults to HS256. Other accepted values are HS384 and HS512 \n--saveAlias (optional) if this is set, the given alias name is used to save the generated JWK instead of printing it on the screen \n--topology (optional) the name of the topology (aka. cluster) to be used when saving the JWK as an alias. If none specified, the alias is going to be saved for the Gateway \n";
        }

        @Override
        public void execute() throws Exception {
            int keyLength = Integer.parseInt(KnoxCLI.this.jwsAlgorithm.getName().substring(2));
            try {
                OctetSequenceKey jwk = (OctetSequenceKey)new OctetSequenceKeyGenerator(keyLength).keyID(UUID.randomUUID().toString()).algorithm((Algorithm)KnoxCLI.this.jwsAlgorithm).generate();
                String jwkAsText = jwk.getKeyValue().toJSONString().replace("\"", "");
                if (KnoxCLI.this.alias != null) {
                    if (KnoxCLI.this.cluster == null) {
                        KnoxCLI.this.cluster = "__gateway";
                    }
                    this.getAliasService().addAliasForCluster(KnoxCLI.this.cluster, KnoxCLI.this.alias, jwkAsText);
                    KnoxCLI.this.out.println(KnoxCLI.this.alias + " has been successfully created.");
                } else {
                    KnoxCLI.this.out.println(jwkAsText);
                }
            }
            catch (JOSEException e) {
                throw new RuntimeException("Error while generating " + keyLength + " bits JWK secret", e);
            }
        }
    }

    public class TopologyConverter
    extends Command {
        public static final String USAGE = "convert-topology --path \"path/to/topology.xml\" --provider-name my-provider.json [--descriptor-name my-descriptor.json] [--topology-name topologyName] [--output-path \"path/to/configs/\"] [--force] [--cluster clusterName] [--discovery-url url] [--discovery-user discoveryUser] [--discovery-pwd-alias discoveryPasswordAlias] [--discovery-type discoveryType]";
        public static final String DESC = "Convert Knox topology file to provider and descriptor config files \nOptions are as follows: \n--path (required) path to topology xml file \n--provider-name (required) name of the provider json config file (including .json extension) \n--descriptor-name (optional) name of descriptor json config file (including .json extension) \n--topology-name (optional) topology-name can be use instead of --path option, if used, KnoxCLI will attempt to find topology from deployed topologies.\n\t if not provided topology name will be used as descriptor name \n--output-path (optional) output directory to save provider and descriptor config files \n\t if not provided config files will be saved in appropriate Knox config directory \n--force (optional) force rewriting of existing files, if not used, command will fail when the configs files with same name already exist. \n--cluster (optional) cluster name, required for service discovery \n--discovery-url (optional) service discovery URL, required for service discovery \n--discovery-user (optional) service discovery user, required for service discovery \n--discovery-pwd-alias (optional) password alias for service discovery user, required for service discovery \n--discovery-type (optional) service discovery type, required for service discovery \n";

        @Override
        public void execute() throws Exception {
            if (StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)KnoxCLI.this.providerName)) || StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)KnoxCLI.this.descriptorName))) {
                throw new IllegalArgumentException(" JSON extension is required for provider and descriptor file names");
            }
            TopologyToDescriptor converter = new TopologyToDescriptor();
            converter.setForce(KnoxCLI.this.force);
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.topologyName)) {
                converter.setTopologyPath(KnoxCLI.this.getGatewayConfig().getGatewayTopologyDir() + File.separator + KnoxCLI.this.topologyName);
            } else if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.path)) {
                converter.setTopologyPath(KnoxCLI.this.path);
            } else {
                throw new IllegalArgumentException("Please specify either --path or --topology-name option");
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.providerName)) {
                converter.setProviderName(KnoxCLI.this.providerName);
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.descriptorName)) {
                converter.setDescriptorName(KnoxCLI.this.descriptorName);
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.outputDir)) {
                converter.setProviderConfigDir(KnoxCLI.this.outputDir);
                converter.setDescriptorConfigDir(KnoxCLI.this.outputDir);
            } else {
                converter.setProviderConfigDir(KnoxCLI.this.getGatewayConfig().getGatewayProvidersConfigDir());
                converter.setDescriptorConfigDir(KnoxCLI.this.getGatewayConfig().getGatewayDescriptorsDir());
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.cluster)) {
                converter.setCluster(KnoxCLI.this.cluster);
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.discoveryUrl)) {
                converter.setDiscoveryUrl(KnoxCLI.this.discoveryUrl);
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.discoveryUser)) {
                converter.setDiscoveryUser(KnoxCLI.this.discoveryUser);
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.discoveryPasswordAlias)) {
                converter.setDiscoveryPasswordAlias(KnoxCLI.this.discoveryPasswordAlias);
            }
            if (!StringUtils.isBlank((CharSequence)KnoxCLI.this.discoveryType)) {
                converter.setDiscoveryType(KnoxCLI.this.discoveryType);
            }
            converter.validate();
            converter.convert();
            String topoName = StringUtils.isBlank((CharSequence)KnoxCLI.this.topologyName) ? FilenameUtils.getBaseName((String)KnoxCLI.this.path) : KnoxCLI.this.topologyName;
            KnoxCLI.this.out.println("Provider " + KnoxCLI.this.providerName + " and descriptor " + KnoxCLI.this.descriptorName + " generated for topology " + topoName + "\n");
        }

        @Override
        public String getUsage() {
            return "convert-topology --path \"path/to/topology.xml\" --provider-name my-provider.json [--descriptor-name my-descriptor.json] [--topology-name topologyName] [--output-path \"path/to/configs/\"] [--force] [--cluster clusterName] [--discovery-url url] [--discovery-user discoveryUser] [--discovery-pwd-alias discoveryPasswordAlias] [--discovery-type discoveryType]:\n\nConvert Knox topology file to provider and descriptor config files \nOptions are as follows: \n--path (required) path to topology xml file \n--provider-name (required) name of the provider json config file (including .json extension) \n--descriptor-name (optional) name of descriptor json config file (including .json extension) \n--topology-name (optional) topology-name can be use instead of --path option, if used, KnoxCLI will attempt to find topology from deployed topologies.\n\t if not provided topology name will be used as descriptor name \n--output-path (optional) output directory to save provider and descriptor config files \n\t if not provided config files will be saved in appropriate Knox config directory \n--force (optional) force rewriting of existing files, if not used, command will fail when the configs files with same name already exist. \n--cluster (optional) cluster name, required for service discovery \n--discovery-url (optional) service discovery URL, required for service discovery \n--discovery-user (optional) service discovery user, required for service discovery \n--discovery-pwd-alias (optional) password alias for service discovery user, required for service discovery \n--discovery-type (optional) service discovery type, required for service discovery \n";
        }
    }

    public class RemoteRegistryDeleteDescriptorCommand
    extends RemoteRegistryDeleteCommand {
        static final String USAGE = "delete-descriptor descriptor --registry-client name";
        static final String DESC = "Deletes a simple descriptor from the specified remote registry.\n";

        public RemoteRegistryDeleteDescriptorCommand(String entryName) {
            super(entryName);
        }

        @Override
        public void execute() throws Exception {
            this.execute("/knox/config/descriptors/" + this.entryName);
        }

        @Override
        public String getUsage() {
            return "delete-descriptor descriptor --registry-client name:\n\nDeletes a simple descriptor from the specified remote registry.\n";
        }
    }

    public class RemoteRegistryDeleteProviderConfigCommand
    extends RemoteRegistryDeleteCommand {
        static final String USAGE = "delete-provider-config providerConfig --registry-client name";
        static final String DESC = "Deletes a shared provider configuration from the specified remote registry.\n";

        public RemoteRegistryDeleteProviderConfigCommand(String entryName) {
            super(entryName);
        }

        @Override
        public void execute() throws Exception {
            this.execute("/knox/config/shared-providers/" + this.entryName);
        }

        @Override
        public String getUsage() {
            return "delete-provider-config providerConfig --registry-client name:\n\nDeletes a shared provider configuration from the specified remote registry.\n";
        }
    }

    public abstract class RemoteRegistryDeleteCommand
    extends RemoteRegistryCommand {
        protected String entryName;

        protected RemoteRegistryDeleteCommand(String entryName) {
            this.entryName = entryName;
        }

        private void delete(RemoteConfigurationRegistryClient client, String entryPath) throws Exception {
            if (client.entryExists(entryPath)) {
                client.deleteEntry(entryPath);
            }
        }

        protected void execute(String entryName) throws Exception {
            RemoteConfigurationRegistryClient client = this.getClient();
            if (client != null && entryName != null) {
                this.delete(client, entryName);
            }
        }
    }

    public class RemoteRegistryGetACLCommand
    extends RemoteRegistryCommand {
        static final String USAGE = "get-registry-acl entry --registry-client name";
        static final String DESC = "Presents the ACL settings for the specified remote registry entry.\n";
        private String entry;

        RemoteRegistryGetACLCommand(String entry) {
            this.entry = entry;
        }

        @Override
        public void execute() throws Exception {
            RemoteConfigurationRegistryClient client = this.getClient();
            if (client != null && this.entry != null) {
                List acls = client.getACL(this.entry);
                for (RemoteConfigurationRegistryClient.EntryACL acl : acls) {
                    KnoxCLI.this.out.println(acl.getType() + ":" + acl.getId() + ":" + acl.getPermissions());
                }
            }
        }

        @Override
        public String getUsage() {
            return "get-registry-acl entry --registry-client name:\n\nPresents the ACL settings for the specified remote registry entry.\n";
        }
    }

    public class RemoteRegistryUploadDescriptorCommand
    extends RemoteRegistryUploadCommand {
        static final String USAGE = "upload-descriptor descriptorFile --registry-client name [--entry-name entryName]";
        static final String DESC = "Uploads a simple descriptor using the specified remote registry client, optionally renaming the entry.\nIf the entry name is not specified, the name of the uploaded file is used.\n";

        RemoteRegistryUploadDescriptorCommand(String fileName) {
            super(fileName);
        }

        @Override
        public void execute() throws Exception {
            super.execute(this.getEntryName("/knox/config/descriptors"), this.getSourceFile());
        }

        @Override
        public String getUsage() {
            return "upload-descriptor descriptorFile --registry-client name [--entry-name entryName]:\n\nUploads a simple descriptor using the specified remote registry client, optionally renaming the entry.\nIf the entry name is not specified, the name of the uploaded file is used.\n";
        }
    }

    public class RemoteRegistryUploadProviderConfigCommand
    extends RemoteRegistryUploadCommand {
        static final String USAGE = "upload-provider-config providerConfigFile --registry-client name [--entry-name entryName]";
        static final String DESC = "Uploads a provider configuration to the specified remote registry client, optionally renaming the entry.\nIf the entry name is not specified, the name of the uploaded file is used.\n";

        RemoteRegistryUploadProviderConfigCommand(String fileName) {
            super(fileName);
        }

        @Override
        public void execute() throws Exception {
            super.execute(this.getEntryName("/knox/config/shared-providers"), this.getSourceFile());
        }

        @Override
        public String getUsage() {
            return "upload-provider-config providerConfigFile --registry-client name [--entry-name entryName]:\n\nUploads a provider configuration to the specified remote registry client, optionally renaming the entry.\nIf the entry name is not specified, the name of the uploaded file is used.\n";
        }
    }

    public abstract class RemoteRegistryUploadCommand
    extends RemoteRegistryCommand {
        private File sourceFile;
        protected String filename;

        protected RemoteRegistryUploadCommand(String sourceFileName) {
            this.filename = sourceFileName;
        }

        private void upload(RemoteConfigurationRegistryClient client, String entryPath, File source) throws Exception {
            String content = FileUtils.readFileToString((File)source, (Charset)StandardCharsets.UTF_8);
            if (client.entryExists(entryPath)) {
                client.setEntryData(entryPath, content);
            } else {
                client.createEntry(entryPath, content);
            }
        }

        File getSourceFile() {
            if (this.sourceFile == null) {
                this.sourceFile = new File(this.filename);
            }
            return this.sourceFile;
        }

        String getEntryName(String prefixPath) {
            String entryName = KnoxCLI.this.remoteRegistryEntryName;
            if (entryName == null) {
                File sourceFile = this.getSourceFile();
                if (sourceFile.exists()) {
                    String path = sourceFile.getAbsolutePath();
                    entryName = path.substring(path.lastIndexOf(File.separator) + 1);
                } else {
                    KnoxCLI.this.out.println("Could not locate source file: " + this.filename);
                }
            }
            return prefixPath + "/" + entryName;
        }

        protected void execute(String entryName, File sourceFile) throws Exception {
            RemoteConfigurationRegistryClient client = this.getClient();
            if (client != null && entryName != null) {
                this.upload(client, entryName, sourceFile);
            }
        }
    }

    public class RemoteRegistryListDescriptorsCommand
    extends RemoteRegistryCommand {
        static final String USAGE = "list-descriptors --registry-client name";
        static final String DESC = "Lists the descriptors present in the specified remote registry\n";

        @Override
        public void execute() {
            RemoteConfigurationRegistryClient client = this.getClient();
            if (client != null) {
                KnoxCLI.this.out.println("Descriptors (@" + client.getAddress() + ")");
                List entries = client.listChildEntries("/knox/config/descriptors");
                if (entries != null) {
                    for (String entry : entries) {
                        KnoxCLI.this.out.println(entry);
                    }
                }
                KnoxCLI.this.out.println();
            }
        }

        @Override
        public String getUsage() {
            return "list-descriptors --registry-client name:\n\nLists the descriptors present in the specified remote registry\n";
        }
    }

    public class RemoteRegistryListProviderConfigsCommand
    extends RemoteRegistryCommand {
        static final String USAGE = "list-provider-configs --registry-client name";
        static final String DESC = "Lists the provider configurations present in the specified remote registry\n";

        @Override
        public void execute() {
            RemoteConfigurationRegistryClient client = this.getClient();
            if (client != null) {
                KnoxCLI.this.out.println("Provider Configurations (@" + client.getAddress() + ")");
                List entries = client.listChildEntries("/knox/config/shared-providers");
                if (entries != null) {
                    for (String entry : entries) {
                        KnoxCLI.this.out.println(entry);
                    }
                }
                KnoxCLI.this.out.println();
            }
        }

        @Override
        public String getUsage() {
            return "list-provider-configs --registry-client name:\n\nLists the provider configurations present in the specified remote registry\n";
        }
    }

    private abstract class RemoteRegistryCommand
    extends Command {
        static final String ROOT_ENTRY = "/knox";
        static final String CONFIG_ENTRY = "/knox/config";
        static final String PROVIDER_CONFIG_ENTRY = "/knox/config/shared-providers";
        static final String DESCRIPTORS_ENTRY = "/knox/config/descriptors";

        private RemoteRegistryCommand() {
        }

        protected RemoteConfigurationRegistryClient getClient() {
            RemoteConfigurationRegistryClient client = null;
            if (KnoxCLI.this.remoteRegistryClient != null) {
                RemoteConfigurationRegistryClientService cs = this.getRemoteConfigRegistryClientService();
                client = cs.get(KnoxCLI.this.remoteRegistryClient);
                if (client == null) {
                    KnoxCLI.this.out.println("No remote configuration registry identified by '" + KnoxCLI.this.remoteRegistryClient + "' could be found.");
                }
            } else {
                KnoxCLI.this.out.println("Missing required argument : --registry-client\n");
            }
            return client;
        }
    }

    public class RemoteRegistryClientsListCommand
    extends Command {
        static final String USAGE = "list-registry-clients";
        static final String DESC = "Lists all of the remote configuration registry clients defined in gateway-site.xml.\n";

        @Override
        public void execute() throws Exception {
            GatewayConfig config = KnoxCLI.this.getGatewayConfig();
            List remoteConfigRegistryClientNames = config.getRemoteRegistryConfigurationNames();
            if (!remoteConfigRegistryClientNames.isEmpty()) {
                KnoxCLI.this.out.println("Listing remote configuration registry clients:");
                for (String name : remoteConfigRegistryClientNames) {
                    KnoxCLI.this.out.println(name);
                }
            }
        }

        @Override
        public String getUsage() {
            return "list-registry-clients:\n\nLists all of the remote configuration registry clients defined in gateway-site.xml.\n";
        }
    }

    public class ServiceTestCommand
    extends Command {
        public static final String USAGE = "service-test [--u username] [--p password] [--cluster clustername] [--hostname name] [--port port]";
        public static final String DESC = "This command requires a running instance of Knox to be present on the same machine.\nIt will execute a test to make sure all services are accessible through the gateway URLs.\nErrors are reported and suggestions to resolve any problems are returned. JSON formatted.\n";
        private boolean ssl;
        private int attempts;

        public ServiceTestCommand() {
            this.ssl = true;
        }

        @Override
        public String getUsage() {
            return "service-test [--u username] [--p password] [--cluster clustername] [--hostname name] [--port port]:\n\nThis command requires a running instance of Knox to be present on the same machine.\nIt will execute a test to make sure all services are accessible through the gateway URLs.\nErrors are reported and suggestions to resolve any problems are returned. JSON formatted.\n";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void execute() {
            ++this.attempts;
            http = "http://";
            https = "https://";
            conf = KnoxCLI.access$1000(KnoxCLI.this);
            if (KnoxCLI.access$800(KnoxCLI.this) == null) {
                KnoxCLI.access$2200(KnoxCLI.this);
                KnoxCLI.this.out.println("A --cluster argument is required.");
                return;
            }
            if (KnoxCLI.access$1200(KnoxCLI.this) != null) {
                host = KnoxCLI.access$1200(KnoxCLI.this);
            } else {
                try {
                    host = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    KnoxCLI.this.out.println(e.toString());
                    KnoxCLI.this.out.println("Defaulting address to localhost. Use --hostname option to specify a different hostname");
                    host = "localhost";
                }
            }
            if (KnoxCLI.access$2300(KnoxCLI.this) != null) {
                gatewayPort = KnoxCLI.access$2300(KnoxCLI.this);
            } else if (conf.getGatewayPort() > -1) {
                gatewayPort = Integer.toString(conf.getGatewayPort());
            } else {
                KnoxCLI.this.out.println("Could not get port. Please supply it using the --port option");
                return;
            }
            path = "/" + conf.getGatewayPath();
            topology = "/" + KnoxCLI.access$800(KnoxCLI.this);
            httpServiceTestURL = http + host + ":" + gatewayPort + path + topology + "/service-test";
            httpsServiceTestURL = https + host + ":" + gatewayPort + path + topology + "/service-test";
            authString = "";
            if (KnoxCLI.access$1800(KnoxCLI.this) != null && KnoxCLI.access$1900(KnoxCLI.this) != null) {
                authString = "Basic " + Base64.encodeBase64String((byte[])(KnoxCLI.access$1800(KnoxCLI.this) + ":" + KnoxCLI.access$1900(KnoxCLI.this)).getBytes(StandardCharsets.UTF_8));
            } else {
                KnoxCLI.this.out.println("Username and/or password not supplied. Expect HTTP 401 Unauthorized responses.");
            }
            client = HttpClients.createDefault();
            request = this.ssl != false ? new HttpGet(httpsServiceTestURL) : new HttpGet(httpServiceTestURL);
            request.setHeader("Authorization", authString);
            request.setHeader("Accept", MediaType.APPLICATION_JSON.getMediaType());
            try {
                KnoxCLI.this.out.println(request.toString());
                response = client.execute((HttpUriRequest)request);
                var14_22 = null;
                try {
                    switch (response.getStatusLine().getStatusCode()) {
                        case 200: {
                            response.getEntity().writeTo((OutputStream)KnoxCLI.this.out);
                            ** break;
lbl49:
                            // 1 sources

                            break;
                        }
                        case 404: {
                            KnoxCLI.this.out.println("Could not find service-test resource");
                            KnoxCLI.this.out.println("Make sure you have configured the SERVICE-TEST service in your topology.");
                            ** break;
lbl54:
                            // 1 sources

                            break;
                        }
                        case 500: {
                            KnoxCLI.this.out.println("HTTP 500 Server error");
                            ** break;
lbl58:
                            // 1 sources

                            break;
                        }
                        default: {
                            KnoxCLI.this.out.println("Unexpected HTTP response code.");
                            KnoxCLI.this.out.println(response.getStatusLine().toString());
                            response.getEntity().writeTo((OutputStream)KnoxCLI.this.out);
                            break;
                        }
                    }
                }
                catch (Throwable var15_24) {
                    var14_22 = var15_24;
                    throw var15_24;
                }
                finally {
                    if (response != null) {
                        if (var14_22 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable var15_23) {
                                var14_22.addSuppressed(var15_23);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
                request.releaseConnection();
            }
            catch (ClientProtocolException e) {
                KnoxCLI.this.out.println(e.toString());
                if (KnoxCLI.access$1700(KnoxCLI.this)) {
                    e.printStackTrace(KnoxCLI.this.out);
                }
            }
            catch (SSLException e) {
                KnoxCLI.this.out.println(e.toString());
                this.retryRequest();
            }
            catch (IOException e) {
                KnoxCLI.this.out.println(e.toString());
                this.retryRequest();
                if (KnoxCLI.access$1700(KnoxCLI.this)) {
                    e.printStackTrace(KnoxCLI.this.out);
                }
            }
            finally {
                try {
                    client.close();
                }
                catch (IOException e) {
                    KnoxCLI.this.out.println(e.toString());
                }
            }
        }

        public void retryRequest() {
            if (this.attempts < 2) {
                if (this.ssl) {
                    this.ssl = false;
                    KnoxCLI.this.out.println("Attempting request without SSL.");
                } else {
                    this.ssl = true;
                    KnoxCLI.this.out.println("Attempting request with SSL ");
                }
                this.execute();
            } else {
                KnoxCLI.this.out.println("Unable to successfully make request. Try using the API with cURL.");
            }
        }
    }

    public class LDAPSysBindCommand
    extends LDAPCommand {
        public static final String USAGE = "system-user-auth-test [--cluster clustername] [--d]";
        public static final String DESC = "This command tests a cluster configuration's ability to\n authenticate a user with a cluster's ShiroProvider settings.";

        @Override
        public String getUsage() {
            return "system-user-auth-test [--cluster clustername] [--d]:\n\nThis command tests a cluster configuration's ability to\n authenticate a user with a cluster's ShiroProvider settings.";
        }

        @Override
        public void execute() {
            if (!this.acquireTopology()) {
                return;
            }
            if (this.hasShiroProviderErrors(this.topology, false)) {
                KnoxCLI.this.out.println("Topology warnings present. SystemUser may not bind.");
            }
            if (this.testSysBind(this.topology, this.getConfig(this.topology))) {
                KnoxCLI.this.out.println("System LDAP Bind successful.");
            } else {
                KnoxCLI.this.out.println("Unable to successfully bind to LDAP server with topology credentials. Are your parameters correct?");
            }
        }
    }

    private class LDAPAuthCommand
    extends LDAPCommand {
        public static final String USAGE = "user-auth-test [--cluster clustername] [--u username] [--p password] [--g]";
        public static final String DESC = "This command tests a cluster's configuration ability to\n authenticate a user with a cluster's ShiroProvider settings.\n Use \"--g\" if you want to list the groups a user is a member of. \nOptional: [--u username]: Provide a username argument to the command\nOptional: [--p password]: Provide a password argument to the command.\nIf a username and password argument are not supplied, the terminal will prompt you for one.";
        private static final String SUBJECT_USER_GROUPS = "subject.userGroups";
        private Set<String> groupSet;

        private LDAPAuthCommand() {
            this.groupSet = new HashSet<String>();
        }

        @Override
        public String getUsage() {
            return "user-auth-test [--cluster clustername] [--u username] [--p password] [--g]:\n\nThis command tests a cluster's configuration ability to\n authenticate a user with a cluster's ShiroProvider settings.\n Use \"--g\" if you want to list the groups a user is a member of. \nOptional: [--u username]: Provide a username argument to the command\nOptional: [--p password]: Provide a password argument to the command.\nIf a username and password argument are not supplied, the terminal will prompt you for one.";
        }

        @Override
        public void execute() {
            if (!this.acquireTopology()) {
                return;
            }
            this.acquireCredentials();
            if (this.topology.getProvider("authentication", "ShiroProvider") == null) {
                KnoxCLI.this.out.println("ERR: This tool currently only works with Shiro as the authentication provider.");
                KnoxCLI.this.out.println("Please update the topology to use \"ShiroProvider\" as the authentication provider.");
                return;
            }
            String config = this.getConfig(this.topology);
            if (new File(config).exists()) {
                if (this.authenticateUser(config, new UsernamePasswordToken(this.username, this.password))) {
                    KnoxCLI.this.out.println("LDAP authentication successful!");
                    if (KnoxCLI.this.groups && this.testSysBind(this.topology, config)) {
                        this.groupSet = this.getGroups(this.topology, new UsernamePasswordToken(this.username, this.password));
                        if (this.groupSet == null || this.groupSet.isEmpty()) {
                            KnoxCLI.this.out.println(this.username + " does not belong to any groups");
                            if (KnoxCLI.this.groups) {
                                this.hasShiroProviderErrors(this.topology, true);
                                KnoxCLI.this.out.println("You were looking for this user's groups but this user does not belong to any.");
                                KnoxCLI.this.out.println("Your topology file may be incorrectly configured for group lookup.");
                            }
                        } else {
                            for (Object o : this.groupSet.toArray()) {
                                KnoxCLI.this.out.println(this.username + " is a member of: " + o.toString());
                            }
                        }
                    }
                } else {
                    KnoxCLI.this.out.println("ERR: Unable to authenticate user: " + this.username);
                }
            } else {
                KnoxCLI.this.out.println("ERR: No shiro config file found.");
            }
        }

        private Set<String> getGroups(Topology t, UsernamePasswordToken token) {
            Set groups;
            block6: {
                groups = null;
                try {
                    Subject subject = this.getSubject(this.getConfig(t));
                    if (!subject.isAuthenticated()) {
                        subject.login((AuthenticationToken)token);
                    }
                    subject.hasRole("");
                    groups = (Set)subject.getSession().getAttribute((Object)SUBJECT_USER_GROUPS);
                    subject.logout();
                }
                catch (AuthenticationException e) {
                    KnoxCLI.this.out.println("Error retrieving groups");
                    KnoxCLI.this.out.println(e.toString());
                    if (KnoxCLI.this.debug) {
                        e.printStackTrace();
                    } else {
                        KnoxCLI.this.out.println("For more information use --d for debug output.");
                    }
                }
                catch (ConfigurationException e) {
                    KnoxCLI.this.out.println(e.toString());
                    if (!KnoxCLI.this.debug) break block6;
                    e.printStackTrace();
                }
            }
            return groups;
        }
    }

    private class LDAPCommand
    extends Command {
        public static final String USAGE = "ldap-command";
        public static final String DESC = "This is an internal command. It should not be used.";
        protected String username;
        protected char[] password;
        protected static final String debugMessage = "For more information use --d for debug output.";
        protected Topology topology;

        private LDAPCommand() {
        }

        @Override
        public String getUsage() {
            return "ldap-command:\n\nThis is an internal command. It should not be used.";
        }

        @Override
        public void execute() {
            KnoxCLI.this.out.println("This command does not have any functionality.");
        }

        protected boolean hasShiroProviderErrors(Topology topology, boolean groupLookup) {
            String mainLdapRealm = "main.ldapRealm";
            String contextFactory = mainLdapRealm + ".contextFactory";
            String groupContextFactory = "main.ldapGroupContextFactory";
            String authorizationEnabled = mainLdapRealm + ".authorizationEnabled";
            String userSearchAttributeName = mainLdapRealm + ".userSearchAttributeName";
            String userObjectClass = mainLdapRealm + ".userObjectClass";
            String searchBase = mainLdapRealm + ".searchBase";
            String groupSearchBase = mainLdapRealm + ".groupSearchBase";
            String userSearchBase = mainLdapRealm + ".userSearchBase";
            String groupObjectClass = mainLdapRealm + ".groupObjectClass";
            String memberAttribute = mainLdapRealm + ".memberAttribute";
            String memberAttributeValueTemplate = mainLdapRealm + ".memberAttributeValueTemplate";
            String systemUsername = contextFactory + ".systemUsername";
            String systemPassword = contextFactory + ".systemPassword";
            String url = contextFactory + ".url";
            String userDnTemplate = mainLdapRealm + ".userDnTemplate";
            Provider shiro = topology.getProvider("authentication", "ShiroProvider");
            if (shiro != null) {
                Map params = shiro.getParams();
                int errs = 0;
                if (groupLookup) {
                    int errors = 0;
                    errors += this.hasParam(params, groupContextFactory, true) ? 0 : 1;
                    errors += this.hasParam(params, groupObjectClass, true) ? 0 : 1;
                    errors += this.hasParam(params, memberAttributeValueTemplate, true) ? 0 : 1;
                    errors += this.hasParam(params, memberAttribute, true) ? 0 : 1;
                    errors += this.hasParam(params, authorizationEnabled, true) ? 0 : 1;
                    errors += this.hasParam(params, systemUsername, true) ? 0 : 1;
                    errors += this.hasParam(params, systemPassword, true) ? 0 : 1;
                    errors += this.hasParam(params, userSearchBase, true) ? 0 : 1;
                    errs += (errors += this.hasParam(params, groupSearchBase, true) ? 0 : 1);
                } else {
                    int errors;
                    errs += this.hasParam(params, mainLdapRealm, true) ? 0 : 1;
                    errs += this.hasParam(params, url, true) ? 0 : 1;
                    if (this.hasParam(params, authorizationEnabled, false)) {
                        errors = 0;
                        int searchBaseErrors = 0;
                        errors += this.hasParam(params, systemUsername, true) ? 0 : 1;
                        errors += this.hasParam(params, systemPassword, true) ? 0 : 1;
                        if ((searchBaseErrors += this.hasParam(params, searchBase, false) ? 0 : (this.hasParam(params, userSearchBase, false) ? 0 : 1)) > 0) {
                            KnoxCLI.this.out.println("Warn: Both " + searchBase + " and " + userSearchBase + " are missing from the topology");
                        }
                        errs += (errors += searchBaseErrors);
                    }
                    if (this.hasParam(params, userSearchAttributeName, false) || this.hasParam(params, userObjectClass, false) || this.hasParam(params, searchBase, false) || this.hasParam(params, userSearchBase, false)) {
                        errors = 0;
                        errors += this.hasParam(params, userSearchAttributeName, true) ? 0 : 1;
                        errors += this.hasParam(params, userObjectClass, true) ? 0 : 1;
                        errors += this.hasParam(params, searchBase, false) ? 0 : (this.hasParam(params, userSearchBase, false) ? 0 : 1);
                        errors += this.hasParam(params, systemUsername, true) ? 0 : 1;
                        if ((errors += this.hasParam(params, systemPassword, true) ? 0 : 1) > 0) {
                            KnoxCLI.this.out.println(userSearchAttributeName + " or " + userObjectClass + " or " + searchBase + " or " + userSearchBase + " was found in the topology");
                            KnoxCLI.this.out.println("If any one of the above params is present then " + userSearchAttributeName + " and " + userObjectClass + " must both be present and either " + searchBase + " or " + userSearchBase + " must also be present.");
                        }
                        errs += errors;
                    } else {
                        errs += this.hasParam(params, userDnTemplate, true) ? 0 : 1;
                    }
                }
                return errs > 0;
            }
            KnoxCLI.this.out.println("Could not obtain ShiroProvider");
            return true;
        }

        protected boolean hasParam(Map<String, String> params, String key, boolean notifyUser) {
            if (params.get(key) == null) {
                if (notifyUser) {
                    KnoxCLI.this.out.println("Warn: " + key + " is not present in topology");
                }
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean authenticateUser(Ini ini, UsernamePasswordToken token) {
            boolean result = false;
            try {
                Subject subject = this.getSubject(ini);
                try {
                    subject.login((AuthenticationToken)token);
                    if (subject.isAuthenticated()) {
                        result = true;
                    }
                }
                catch (AuthenticationException e) {
                    KnoxCLI.this.out.println(e.toString());
                    KnoxCLI.this.out.println(e.getCause().getMessage());
                    if (KnoxCLI.this.debug) {
                        e.printStackTrace(KnoxCLI.this.out);
                    } else {
                        KnoxCLI.this.out.println(debugMessage);
                    }
                }
                finally {
                    subject.logout();
                }
            }
            catch (BadSubjectException e) {
                KnoxCLI.this.out.println(e.toString());
                if (KnoxCLI.this.debug) {
                    e.printStackTrace();
                } else {
                    KnoxCLI.this.out.println(debugMessage);
                }
            }
            catch (ConfigurationException e) {
                KnoxCLI.this.out.println(e.toString());
            }
            catch (Exception e) {
                KnoxCLI.this.out.println(e.getCause());
                KnoxCLI.this.out.println(e.toString());
            }
            return result;
        }

        protected boolean authenticateUser(String config, UsernamePasswordToken token) throws ConfigurationException {
            Ini ini = new Ini();
            ini.loadFromPath(config);
            return this.authenticateUser(ini, token);
        }

        protected boolean testSysBind(Topology t, String config) {
            boolean result = false;
            try {
                Provider shiro = t.getProvider("authentication", "ShiroProvider");
                Map params = shiro.getParams();
                String url = (String)params.get("main.ldapRealm.contextFactory.url");
                Ini ini = new Ini();
                ini.addSection("main");
                ini.setSectionProperty("main", "ldapRealm", "org.apache.knox.gateway.shirorealm.KnoxLdapRealm");
                ini.setSectionProperty("main", "ldapContextFactory", "org.apache.knox.gateway.shirorealm.KnoxLdapContextFactory");
                ini.setSectionProperty("main", "ldapRealm.contextFactory.url", url);
                String username = this.getSystemUsername(t);
                char[] password = this.getSystemPassword(t);
                result = this.authenticateUser(ini, new UsernamePasswordToken(username, password));
            }
            catch (NullPointerException | MissingPasswordException | MissingUsernameException | NoSuchProviderException e) {
                KnoxCLI.this.out.println(e.toString());
            }
            return result;
        }

        private String getSystemUsername(Topology t) throws MissingUsernameException, NoSuchProviderException {
            String SYSTEM_USERNAME = "main.ldapRealm.contextFactory.systemUsername";
            Provider shiroProvider = t.getProvider("authentication", "ShiroProvider");
            if (shiroProvider == null) {
                throw new NoSuchProviderException("ShiroProvider", "authentication", t.getName());
            }
            Map params = shiroProvider.getParams();
            String user = (String)params.get("main.ldapRealm.contextFactory.systemUsername");
            return user;
        }

        private char[] getSystemPassword(Topology t) throws NoSuchProviderException, MissingPasswordException {
            String SYSTEM_PASSWORD = "main.ldapRealm.contextFactory.systemPassword";
            Provider shiro = t.getProvider("authentication", "ShiroProvider");
            if (shiro == null) {
                throw new NoSuchProviderException("ShiroProvider", "authentication", t.getName());
            }
            Map params = shiro.getParams();
            String pass = (String)params.get("main.ldapRealm.contextFactory.systemPassword");
            if (pass != null) {
                return pass.toCharArray();
            }
            throw new MissingPasswordException("ShiroProvider did not contain param: main.ldapRealm.contextFactory.systemPassword");
        }

        protected Subject getSubject(Ini config) throws BadSubjectException {
            try {
                ThreadContext.unbindSubject();
                IniSecurityManagerFactory factory = new IniSecurityManagerFactory(config);
                SecurityManager securityManager = (SecurityManager)factory.getInstance();
                SecurityUtils.setSecurityManager((SecurityManager)securityManager);
                Subject subject = SecurityUtils.getSubject();
                if (subject != null) {
                    return subject;
                }
                KnoxCLI.this.out.println("Error Creating Subject from config at: " + config);
            }
            catch (Exception e) {
                KnoxCLI.this.out.println(e.toString());
            }
            throw new BadSubjectException("Subject could not be created with Shiro Config at " + config);
        }

        protected Subject getSubject(String config) throws ConfigurationException {
            Ini ini = new Ini();
            ini.loadFromPath(config);
            try {
                return this.getSubject(ini);
            }
            catch (BadSubjectException e) {
                throw new ConfigurationException("Could not get Subject with Ini at " + config);
            }
        }

        protected void promptCredentials() {
            Throwable throwable;
            BufferedReader reader2;
            Throwable throwable2;
            InputStreamReader inputStreamReader;
            Console c;
            if (this.username == null) {
                c = System.console();
                if (c != null) {
                    this.username = c.readLine("Username: ", new Object[0]);
                } else {
                    try {
                        inputStreamReader = new InputStreamReader(System.in, StandardCharsets.UTF_8);
                        throwable2 = null;
                        try {
                            reader2 = new BufferedReader(inputStreamReader);
                            throwable = null;
                            try {
                                KnoxCLI.this.out.println("Username: ");
                                this.username = reader2.readLine();
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader2 != null) {
                                    if (throwable != null) {
                                        try {
                                            reader2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                    } else {
                                        reader2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable reader2) {
                            throwable2 = reader2;
                            throw reader2;
                        }
                        finally {
                            if (inputStreamReader != null) {
                                if (throwable2 != null) {
                                    try {
                                        inputStreamReader.close();
                                    }
                                    catch (Throwable reader2) {
                                        throwable2.addSuppressed(reader2);
                                    }
                                } else {
                                    inputStreamReader.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        KnoxCLI.this.out.println(e.toString());
                        this.username = "";
                    }
                }
            }
            if (this.password == null) {
                c = System.console();
                if (c != null) {
                    this.password = c.readPassword("Password: ", new Object[0]);
                } else {
                    try {
                        inputStreamReader = new InputStreamReader(System.in, StandardCharsets.UTF_8);
                        throwable2 = null;
                        try {
                            reader2 = new BufferedReader(inputStreamReader);
                            throwable = null;
                            try {
                                KnoxCLI.this.out.println("Password: ");
                                String pw = reader2.readLine();
                                this.password = pw != null ? pw.toCharArray() : new char[0];
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (reader2 != null) {
                                    if (throwable != null) {
                                        try {
                                            reader2.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        reader2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable2 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (inputStreamReader != null) {
                                if (throwable2 != null) {
                                    try {
                                        inputStreamReader.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable2.addSuppressed(throwable8);
                                    }
                                } else {
                                    inputStreamReader.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        KnoxCLI.this.out.println(e.toString());
                        this.password = new char[0];
                    }
                }
            }
        }

        protected Topology getTopology(String topologyName) throws NoSuchTopologyException {
            TopologyService ts = this.getTopologyService();
            ts.reloadTopologies();
            for (Topology t : ts.getTopologies()) {
                if (!t.getName().equals(topologyName)) continue;
                return t;
            }
            throw new NoSuchTopologyException("Topology " + topologyName + " does not exist in the topologies directory.");
        }

        protected String getConfig(Topology t) {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            DeploymentFactory.setGatewayServices(services);
            EnterpriseArchive archive = DeploymentFactory.createDeployment(KnoxCLI.this.getGatewayConfig(), t);
            File war = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(tmpDir, t.getName() + "_deploy.tmp");
            war.deleteOnExit();
            String config = war.getAbsolutePath() + "/%2F/WEB-INF/shiro.ini";
            try {
                FileUtils.forceDeleteOnExit((File)war);
            }
            catch (IOException e) {
                KnoxCLI.this.out.println(e.toString());
                war.deleteOnExit();
            }
            return config;
        }

        void acquireCredentials() {
            if (KnoxCLI.this.user != null) {
                this.username = KnoxCLI.this.user;
            }
            if (KnoxCLI.this.pass != null) {
                this.password = KnoxCLI.this.pass.toCharArray();
            }
            this.promptCredentials();
        }

        protected boolean acquireTopology() {
            try {
                this.topology = this.getTopology(KnoxCLI.this.cluster);
            }
            catch (NoSuchTopologyException e) {
                KnoxCLI.this.out.println(e.toString());
                return false;
            }
            return true;
        }

        protected class NoSuchProviderException
        extends Exception {
            public NoSuchProviderException() {
            }

            public NoSuchProviderException(String name, String role, String topology) {
                super("Could not find provider with role: " + role + ", name: " + name + " inside of topology: " + topology);
            }
        }

        protected class BadSubjectException
        extends Exception {
            public BadSubjectException() {
            }

            public BadSubjectException(String message) {
                super(message);
            }
        }

        protected class MissingUsernameException
        extends Exception {
            public MissingUsernameException() {
            }

            public MissingUsernameException(String message) {
                super(message);
            }
        }

        protected class MissingPasswordException
        extends Exception {
            public MissingPasswordException() {
            }

            public MissingPasswordException(String message) {
                super(message);
            }
        }

        protected class NoSuchTopologyException
        extends Exception {
            public NoSuchTopologyException() {
            }

            public NoSuchTopologyException(String message) {
                super(message);
            }
        }
    }

    private class ListTopologiesCommand
    extends Command {
        public static final String USAGE = "list-topologies";
        public static final String DESC = "Retrieves a list of the available topologies within the\ndefault topologies directory. Will return topologies that may not be deployed due\nerrors in file formatting.";

        private ListTopologiesCommand() {
        }

        @Override
        public String getUsage() {
            return "list-topologies:\n\nRetrieves a list of the available topologies within the\ndefault topologies directory. Will return topologies that may not be deployed due\nerrors in file formatting.";
        }

        @Override
        public void execute() {
            String confDir = KnoxCLI.this.getGatewayConfig().getGatewayConfDir();
            File tops = new File(confDir + "/topologies");
            KnoxCLI.this.out.println("List of files available in the topologies directory");
            KnoxCLI.this.out.println(tops.toString());
            if (tops.isDirectory()) {
                for (File f : tops.listFiles()) {
                    if (!f.getName().endsWith(".xml")) continue;
                    String fName = f.getName().replace(".xml", "");
                    KnoxCLI.this.out.println(fName);
                }
                return;
            }
            KnoxCLI.this.out.println("ERR: Topologies directory does not exist.");
        }
    }

    private class ValidateTopologyCommand
    extends Command {
        public static final String USAGE = "validate-topology [--cluster clustername] | [--path \"path/to/file\"]";
        public static final String DESC = "Ensures that a cluster's description (a.k.a topology) \nfollows the correct formatting rules.\nuse the list-topologies command to get a list of available cluster names";
        private String file;

        private ValidateTopologyCommand() {
            this.file = "";
        }

        @Override
        public String getUsage() {
            return "validate-topology [--cluster clustername] | [--path \"path/to/file\"]:\n\nEnsures that a cluster's description (a.k.a topology) \nfollows the correct formatting rules.\nuse the list-topologies command to get a list of available cluster names";
        }

        @Override
        public void execute() throws Exception {
            GatewayConfig gc = KnoxCLI.this.getGatewayConfig();
            String topDir = gc.getGatewayTopologyDir();
            if (KnoxCLI.this.path != null) {
                this.file = KnoxCLI.this.path;
            } else {
                if (KnoxCLI.this.cluster == null) {
                    File tops = new File(topDir + "/topologies");
                    if (tops.isDirectory()) {
                        KnoxCLI.this.out.println("List of files available in the topologies directory");
                        for (File f : tops.listFiles()) {
                            if (!f.getName().endsWith(".xml")) continue;
                            String fName = f.getName().replace(".xml", "");
                            KnoxCLI.this.out.println(fName);
                        }
                        return;
                    }
                    KnoxCLI.this.out.println("Could not locate topologies directory");
                    return;
                }
                this.file = topDir + "/" + KnoxCLI.this.cluster + ".xml";
            }
            KnoxCLI.this.out.println();
            KnoxCLI.this.out.println("File to be validated: ");
            KnoxCLI.this.out.println(this.file);
            KnoxCLI.this.out.println("==========================================");
            if (new File(this.file).exists()) {
                TopologyValidator tv = new TopologyValidator(this.file);
                if (tv.validateTopology()) {
                    KnoxCLI.this.out.println("Topology file validated successfully");
                } else {
                    KnoxCLI.this.out.println(tv.getErrorString());
                    KnoxCLI.this.out.println("Topology validation unsuccessful");
                }
            } else {
                KnoxCLI.this.out.println("The topology file specified does not exist.");
            }
        }
    }

    private class RedeployCommand
    extends Command {
        public static final String USAGE = "redeploy [--cluster clustername]";
        public static final String DESC = "Redeploys one or all of the gateway's clusters (a.k.a topologies).";

        private RedeployCommand() {
        }

        @Override
        public void execute() throws Exception {
            TopologyService ts = this.getTopologyService();
            ts.reloadTopologies();
            if (KnoxCLI.this.cluster != null) {
                if (this.validateClusterName(KnoxCLI.this.cluster, ts)) {
                    ts.redeployTopology(KnoxCLI.this.cluster);
                } else {
                    KnoxCLI.this.out.println("Invalid cluster name provided. Nothing to redeploy.");
                }
            }
        }

        private boolean validateClusterName(String cluster, TopologyService ts) {
            boolean valid = false;
            for (Topology t : ts.getTopologies()) {
                if (!t.getName().equals(cluster)) continue;
                valid = true;
                break;
            }
            return valid;
        }

        @Override
        public String getUsage() {
            return "redeploy [--cluster clustername]:\n\nRedeploys one or all of the gateway's clusters (a.k.a topologies).";
        }
    }

    private class VersionCommand
    extends Command {
        public static final String USAGE = "version";
        public static final String DESC = "Displays Knox version information.";

        private VersionCommand() {
        }

        @Override
        public void execute() throws Exception {
            Properties buildProperties = KnoxCLI.loadBuildProperties();
            System.out.println(String.format(Locale.ROOT, "Apache Knox: %s (%s)", buildProperties.getProperty("build.version", "unknown"), buildProperties.getProperty("build.hash", "unknown")));
        }

        @Override
        public String getUsage() {
            return "version:\n\nDisplays Knox version information.";
        }
    }

    public class MasterCreateCommand
    extends Command {
        public static final String USAGE = "create-master [--force] [--master mastersecret] [--generate]";
        public static final String DESC = "The create-master command persists the master secret in a file located at:\n{GATEWAY_HOME}/data/security/master.\nIt will prompt the user for the secret to persist.\nUse --force to overwrite the master secret.\nUse --master to pass in a master secret to persist.\nThis can be used to persist the secret without any user interaction.\nBe careful as the secret might appear in shell histories or process listings.\nInstead of --master it is usually a better idea to use --generate instead!\nUse --generate to have Knox automatically generate a random secret.\nThe generated secret will not be printed or otherwise exposed.\nDo not specify both --master and --generate at the same time.\n";

        private GatewayConfig getGatewayConfig() {
            Configuration conf = KnoxCLI.this.getConf();
            Object result = conf instanceof GatewayConfig ? (GatewayConfig)conf : new GatewayConfigImpl();
            return result;
        }

        @Override
        public boolean validate() {
            boolean valid = true;
            GatewayConfig config = this.getGatewayConfig();
            File dir = new File(config.getGatewaySecurityDir());
            File file = new File(dir, "master");
            if (file.exists()) {
                if (KnoxCLI.this.force) {
                    if (!file.canWrite()) {
                        KnoxCLI.this.out.println("This command requires write permissions on the master secret file: " + file.getAbsolutePath());
                        valid = false;
                    } else {
                        valid = file.delete();
                        if (!valid) {
                            KnoxCLI.this.out.println("Unable to delete the master secret file: " + file.getAbsolutePath());
                        }
                    }
                } else {
                    KnoxCLI.this.out.println("Master secret is already present on disk. Please be aware that overwriting it will require updating other security artifacts.  Use --force to overwrite the existing master secret.");
                    valid = false;
                }
            } else if (dir.exists() && !dir.canWrite()) {
                KnoxCLI.this.out.println("This command requires write permissions on the security directory: " + dir.getAbsolutePath());
                valid = false;
            }
            return valid;
        }

        @Override
        public void execute() throws Exception {
            KnoxCLI.this.out.println("Master secret has been persisted to disk.");
        }

        @Override
        public String getUsage() {
            return "create-master [--force] [--master mastersecret] [--generate]:\n\nThe create-master command persists the master secret in a file located at:\n{GATEWAY_HOME}/data/security/master.\nIt will prompt the user for the secret to persist.\nUse --force to overwrite the master secret.\nUse --master to pass in a master secret to persist.\nThis can be used to persist the secret without any user interaction.\nBe careful as the secret might appear in shell histories or process listings.\nInstead of --master it is usually a better idea to use --generate instead!\nUse --generate to have Knox automatically generate a random secret.\nThe generated secret will not be printed or otherwise exposed.\nDo not specify both --master and --generate at the same time.\n";
        }
    }

    public class BatchAliasCreateCommand
    extends Command {
        public static final String USAGE = "create-aliases --alias alias1 [--value value1] --alias alias2 [--value value2] --alias aliasN [--value valueN] ... [--cluster clustername] [--generate]";
        public static final String DESC = "The create-aliases command will create multiple aliases\nand secret pairs within the same credential store for the\nindicated --cluster otherwise within the gateway\ncredential store. The actual secret may be specified via\nthe --value option or --generate (will create a random secret\nfor you) or user will be prompt to provide password.";
        private List<String> names;
        private List<String> values;

        public BatchAliasCreateCommand() {
            this.names = new ArrayList<String>();
            this.values = new ArrayList<String>();
        }

        public void addName(String alias) {
            if (this.names.contains(alias)) {
                KnoxCLI.this.out.println("Duplicated alias " + alias);
                System.exit(1);
            }
            this.names.add(alias);
            this.values.add(null);
        }

        public void addValue(String value) {
            this.values.set(this.values.size() - 1, value);
        }

        @Override
        public void execute() throws Exception {
            Map<String, String> aliases = this.toMap();
            ArrayList<String> generated = new ArrayList<String>();
            AliasService as = this.getAliasService();
            if (KnoxCLI.this.cluster == null) {
                KnoxCLI.this.cluster = "__gateway";
            }
            for (Map.Entry<String, String> entry : aliases.entrySet()) {
                if (entry.getValue() != null) continue;
                if (Boolean.parseBoolean(KnoxCLI.this.generate)) {
                    entry.setValue(PasswordUtils.generatePassword((int)16));
                    generated.add(entry.getKey());
                    continue;
                }
                entry.setValue(new String(KnoxCLI.promptUserForPassword()));
            }
            as.addAliasesForCluster(KnoxCLI.this.cluster, aliases);
            if (!generated.isEmpty()) {
                KnoxCLI.this.out.println(generated.size() + " alias(es) have been successfully generated: " + generated);
            }
            ArrayList<String> created = new ArrayList<String>(aliases.keySet());
            created.removeAll(generated);
            if (!created.isEmpty()) {
                KnoxCLI.this.out.println(created.size() + " alias(es) have been successfully created: " + created);
            }
        }

        private Map<String, String> toMap() {
            LinkedHashMap<String, String> aliases = new LinkedHashMap<String, String>();
            for (int i = 0; i < this.names.size(); ++i) {
                aliases.put(this.names.get(i), this.values.get(i));
            }
            return aliases;
        }

        @Override
        public String getUsage() {
            return "create-aliases --alias alias1 [--value value1] --alias alias2 [--value value2] --alias aliasN [--value valueN] ... [--cluster clustername] [--generate]:\n\nThe create-aliases command will create multiple aliases\nand secret pairs within the same credential store for the\nindicated --cluster otherwise within the gateway\ncredential store. The actual secret may be specified via\nthe --value option or --generate (will create a random secret\nfor you) or user will be prompt to provide password.";
        }
    }

    public class AliasDeleteCommand
    extends Command {
        public static final String USAGE = "delete-alias aliasname [--cluster clustername]";
        public static final String DESC = "The delete-alias command removes the\nindicated alias from the --cluster specific\ncredential store or the gateway credential store.";
        private String name;

        public AliasDeleteCommand(String alias) {
            this.name = alias;
        }

        @Override
        public void execute() throws Exception {
            AliasService as = this.getAliasService();
            KeystoreService keystoreService = this.getKeystoreService();
            if (as != null) {
                boolean credentialStoreForClusterAvailable;
                if (KnoxCLI.this.cluster == null) {
                    KnoxCLI.this.cluster = "__gateway";
                }
                if (credentialStoreForClusterAvailable = keystoreService.isCredentialStoreForClusterAvailable(KnoxCLI.this.cluster)) {
                    List aliasesForCluster = as.getAliasesForCluster(KnoxCLI.this.cluster);
                    if (null == aliasesForCluster || !aliasesForCluster.contains(this.name)) {
                        KnoxCLI.this.out.println("Deletion of Alias: " + this.name + " from cluster: " + KnoxCLI.this.cluster + " Failed. \nNo such alias exists in the cluster.");
                    } else {
                        as.removeAliasForCluster(KnoxCLI.this.cluster, this.name);
                        KnoxCLI.this.out.println(this.name + " has been successfully deleted.");
                    }
                } else {
                    KnoxCLI.this.out.println("Invalid cluster name provided: " + KnoxCLI.this.cluster);
                }
            }
        }

        @Override
        public String getUsage() {
            return "delete-alias aliasname [--cluster clustername]:\n\nThe delete-alias command removes the\nindicated alias from the --cluster specific\ncredential store or the gateway credential store.";
        }
    }

    public class AliasCreateCommand
    extends Command {
        public static final String USAGE = "create-alias aliasname [--cluster clustername] [ (--value v) | (--generate) ]";
        public static final String DESC = "The create-alias command will create an alias\nand secret pair within the credential store for the\nindicated --cluster otherwise within the gateway\ncredential store. The actual secret may be specified via\nthe --value option or --generate (will create a random secret\nfor you) or user will be prompt to provide password.";
        private String name;

        public AliasCreateCommand(String alias) {
            this.name = alias;
        }

        @Override
        public void execute() throws Exception {
            AliasService as = this.getAliasService();
            if (KnoxCLI.this.cluster == null) {
                KnoxCLI.this.cluster = "__gateway";
            }
            if (KnoxCLI.this.value != null) {
                as.addAliasForCluster(KnoxCLI.this.cluster, this.name, KnoxCLI.this.value);
                KnoxCLI.this.out.println(this.name + " has been successfully created.");
            } else if (Boolean.parseBoolean(KnoxCLI.this.generate)) {
                as.generateAliasForCluster(KnoxCLI.this.cluster, this.name);
                KnoxCLI.this.out.println(this.name + " has been successfully generated.");
            } else {
                KnoxCLI.this.value = new String(KnoxCLI.promptUserForPassword());
                as.addAliasForCluster(KnoxCLI.this.cluster, this.name, KnoxCLI.this.value);
                KnoxCLI.this.out.println(this.name + " has been successfully created.");
            }
        }

        @Override
        public String getUsage() {
            return "create-alias aliasname [--cluster clustername] [ (--value v) | (--generate) ]:\n\nThe create-alias command will create an alias\nand secret pair within the credential store for the\nindicated --cluster otherwise within the gateway\ncredential store. The actual secret may be specified via\nthe --value option or --generate (will create a random secret\nfor you) or user will be prompt to provide password.";
        }
    }

    public class CertCreateCommand
    extends Command {
        public static final String USAGE = "create-cert [--force] [--hostname h]";
        public static final String DESC = "The create-cert command populates the configured identity\nkeystore with a self-signed certificate to be used as the\ngateway identity. If a cert exists and it is determined to\nnot have been generated by Knox, --force must be specified\nto overwrite it.  If a self-signed cert is created, a\npassword for the key will be generated and stored in the\n__gateway-credentials.jceks credential store.";
        private static final String GATEWAY_CREDENTIAL_STORE_NAME = "__gateway";

        @Override
        public void execute() throws Exception {
            KeystoreService ks = this.getKeystoreService();
            AliasService as = this.getAliasService();
            if (ks != null) {
                try {
                    if (!ks.isCredentialStoreForClusterAvailable(GATEWAY_CREDENTIAL_STORE_NAME)) {
                        ks.createCredentialStoreForCluster(GATEWAY_CREDENTIAL_STORE_NAME);
                    }
                }
                catch (KeystoreServiceException e) {
                    throw new ServiceLifecycleException("Keystore was not loaded properly - the stored password may not match the password for the keystore.", (Exception)((Object)e));
                }
                try {
                    GatewayConfig config;
                    if (!ks.isKeystoreForGatewayAvailable()) {
                        ks.createKeystoreForGateway();
                    }
                    if (!this.isForceRequired(config = KnoxCLI.this.getGatewayConfig(), ks) || KnoxCLI.this.force) {
                        char[] passphrase = as.getGatewayIdentityPassphrase();
                        if (passphrase == null) {
                            MasterService ms = (MasterService)services.getService(ServiceType.MASTER_SERVICE);
                            passphrase = ms.getMasterSecret();
                        }
                        ks.addSelfSignedCertForGateway(config.getIdentityKeyAlias(), passphrase, KnoxCLI.this.hostname);
                        KnoxCLI.this.out.println("Certificate " + config.getIdentityKeyAlias() + " has been successfully created.");
                    } else {
                        KnoxCLI.this.out.println("A non-self-signed certificate has already been installed in the configured keystore. Please use --force if you wish to overwrite it with a generated self-signed certificate.");
                    }
                }
                catch (KeystoreServiceException e) {
                    throw new ServiceLifecycleException("The identity keystore was not loaded properly - the provided password may not match the password for the keystore.", (Exception)((Object)e));
                }
            }
        }

        private boolean isForceRequired(GatewayConfig config, KeystoreService ks) {
            Path actualKeystorePath;
            Path defaultKeystorePath = Paths.get(config.getGatewayKeystoreDir(), "gateway.jks").toAbsolutePath();
            if (!defaultKeystorePath.equals(actualKeystorePath = Paths.get(config.getIdentityKeystorePath(), new String[0]).toAbsolutePath())) {
                return true;
            }
            if (!"gateway-identity".equals(config.getIdentityKeyAlias())) {
                return true;
            }
            try {
                Certificate certificate = ks.getCertificateForGateway();
                if (certificate instanceof X509Certificate) {
                    if (!X509CertificateUtil.isSelfSignedCertificate((Certificate)certificate)) {
                        return true;
                    }
                    if (!((X509Certificate)certificate).getSubjectDN().getName().matches(".*?,\\s*OU=Test,\\s*O=Hadoop,\\s*L=Test,\\s*ST=Test,\\s*C=US")) {
                        return true;
                    }
                }
            }
            catch (KeyStoreException | KeystoreServiceException throwable) {
                // empty catch block
            }
            return false;
        }

        @Override
        public String getUsage() {
            return "create-cert [--force] [--hostname h]:\n\nThe create-cert command populates the configured identity\nkeystore with a self-signed certificate to be used as the\ngateway identity. If a cert exists and it is determined to\nnot have been generated by Knox, --force must be specified\nto overwrite it.  If a self-signed cert is created, a\npassword for the key will be generated and stored in the\n__gateway-credentials.jceks credential store.";
        }
    }

    public class CertExportCommand
    extends Command {
        public static final String USAGE = "export-cert [--type PEM|JKS|JCEKS|PKCS12]";
        public static final String DESC = "The export-cert command exports the public certificate\nfrom the a gateway.jks keystore with the alias of gateway-identity.\nIt will be exported to `{GATEWAY_HOME}/data/security/keystores/` with a name of `gateway-client-trust.<type>`Using the --type option you can specify which keystore type you need (default: PEM)\nNOTE: The password for the JKS, JCEKS and PKCS12 types is `changeit`.\nIt can be changed using: `keytool -storepasswd -storetype <type> -keystore gateway-client-trust.<type>`";

        private GatewayConfig getGatewayConfig() {
            Configuration conf = KnoxCLI.this.getConf();
            Object result = conf instanceof GatewayConfig ? (GatewayConfig)conf : new GatewayConfigImpl();
            return result;
        }

        @Override
        public void execute() throws Exception {
            KeystoreService ks = this.getKeystoreService();
            if (ks != null) {
                try {
                    if (!ks.isKeystoreForGatewayAvailable()) {
                        KnoxCLI.this.out.println("No keystore has been created for the gateway. Please use the create-cert command or populate with a CA signed cert of your own.");
                    }
                    GatewayConfig config = this.getGatewayConfig();
                    Certificate cert = ks.getKeystoreForGateway().getCertificate(config.getIdentityKeyAlias());
                    String keyStoreDir = config.getGatewayKeystoreDir() + File.separator;
                    File ksd = new File(keyStoreDir);
                    if (!ksd.exists() && !ksd.mkdirs()) {
                        throw new ServiceLifecycleException("Unable to create keystores directory" + ksd.getAbsolutePath());
                    }
                    if ("PEM".equalsIgnoreCase(KnoxCLI.this.type) || KnoxCLI.this.type == null) {
                        X509CertificateUtil.writeCertificateToFile((Certificate)cert, (File)new File(keyStoreDir + "gateway-client-trust.pem"));
                        KnoxCLI.this.out.println("Certificate gateway-identity has been successfully exported to: " + keyStoreDir + "gateway-client-trust.pem");
                    } else if ("JKS".equalsIgnoreCase(KnoxCLI.this.type)) {
                        X509CertificateUtil.writeCertificateToJks((Certificate)cert, (File)new File(keyStoreDir + "gateway-client-trust.jks"));
                        KnoxCLI.this.out.println("Certificate gateway-identity has been successfully exported to: " + keyStoreDir + "gateway-client-trust.jks");
                    } else if ("JCEKS".equalsIgnoreCase(KnoxCLI.this.type)) {
                        X509CertificateUtil.writeCertificateToJceks((Certificate)cert, (File)new File(keyStoreDir + "gateway-client-trust.jceks"));
                        KnoxCLI.this.out.println("Certificate gateway-identity has been successfully exported to: " + keyStoreDir + "gateway-client-trust.jceks");
                    } else if ("PKCS12".equalsIgnoreCase(KnoxCLI.this.type)) {
                        X509CertificateUtil.writeCertificateToPkcs12((Certificate)cert, (File)new File(keyStoreDir + "gateway-client-trust.pkcs12"));
                        KnoxCLI.this.out.println("Certificate gateway-identity has been successfully exported to: " + keyStoreDir + "gateway-client-trust.pkcs12");
                    } else {
                        KnoxCLI.this.out.println("Invalid type for export file provided. Export has not been done. Please use: [PEM|JKS|JCEKS|PKCS12] default value is PEM.");
                    }
                }
                catch (KeystoreServiceException e) {
                    throw new ServiceLifecycleException("The identity keystore was not loaded properly - the provided password may not match the password for the keystore.", (Exception)((Object)e));
                }
            }
        }

        @Override
        public String getUsage() {
            return "export-cert [--type PEM|JKS|JCEKS|PKCS12]:\n\nThe export-cert command exports the public certificate\nfrom the a gateway.jks keystore with the alias of gateway-identity.\nIt will be exported to `{GATEWAY_HOME}/data/security/keystores/` with a name of `gateway-client-trust.<type>`Using the --type option you can specify which keystore type you need (default: PEM)\nNOTE: The password for the JKS, JCEKS and PKCS12 types is `changeit`.\nIt can be changed using: `keytool -storepasswd -storetype <type> -keystore gateway-client-trust.<type>`";
        }
    }

    private class AliasListCommand
    extends Command {
        public static final String USAGE = "list-alias [--cluster clustername]";
        public static final String DESC = "The list-alias command lists all of the aliases\nfor the given hadoop --cluster. The default\n--cluster being the gateway itself.";

        private AliasListCommand() {
        }

        @Override
        public void execute() throws Exception {
            boolean credentialStoreForClusterAvailable;
            AliasService as = this.getAliasService();
            KeystoreService keystoreService = this.getKeystoreService();
            if (KnoxCLI.this.cluster == null) {
                KnoxCLI.this.cluster = "__gateway";
            }
            if (credentialStoreForClusterAvailable = keystoreService.isCredentialStoreForClusterAvailable(KnoxCLI.this.cluster)) {
                KnoxCLI.this.out.println("Listing aliases for: " + KnoxCLI.this.cluster);
                List aliases = as.getAliasesForCluster(KnoxCLI.this.cluster);
                for (String alias : aliases) {
                    KnoxCLI.this.out.println(alias);
                }
                KnoxCLI.this.out.println("\n" + aliases.size() + " items.");
            } else {
                KnoxCLI.this.out.println("Invalid cluster name provided: " + KnoxCLI.this.cluster);
            }
        }

        @Override
        public String getUsage() {
            return "list-alias [--cluster clustername]:\n\nThe list-alias command lists all of the aliases\nfor the given hadoop --cluster. The default\n--cluster being the gateway itself.";
        }
    }

    private abstract class Command {
        private Command() {
        }

        public boolean validate() {
            return true;
        }

        protected Service getService(String serviceName) {
            return null;
        }

        public abstract void execute() throws Exception;

        public abstract String getUsage();

        protected AliasService getAliasService() {
            return (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        }

        protected KeystoreService getKeystoreService() {
            return (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE);
        }

        protected TopologyService getTopologyService() {
            return (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        }

        protected RemoteConfigurationRegistryClientService getRemoteConfigRegistryClientService() {
            return (RemoteConfigurationRegistryClientService)services.getService(ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE);
        }
    }
}

