/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class MimeTypeMap<V> {
    private Map<String, V> map = new HashMap<String, V>();

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public V get(Object key) {
        MimeType type;
        V value = null;
        if (key instanceof String) {
            try {
                type = new MimeType((String)key);
            }
            catch (MimeTypeParseException e) {
                type = null;
            }
        } else {
            type = key instanceof MimeType ? (MimeType)key : null;
        }
        if (type != null) {
            String priType = type.getPrimaryType();
            value = this.map.get(type.getBaseType());
            if (value == null) {
                try {
                    type.setPrimaryType("*");
                    value = this.map.get(type.getBaseType());
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    // empty catch block
                }
            }
            if (value == null) {
                try {
                    type.setPrimaryType(priType);
                    type.setSubType("*");
                    value = this.map.get(type.getBaseType());
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    // empty catch block
                }
            }
            if (value == null) {
                try {
                    type.setPrimaryType("*");
                    type.setSubType("*");
                    value = this.map.get(type.getBaseType());
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    public V put(MimeType key, V value) {
        return this.map.put(key.getBaseType(), value);
    }

    public V remove(Object key) {
        return this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }
}

