/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.BasicLogFormatter;
import net.htmlparser.jericho.Logger;

public class WriterLogger
implements Logger {
    private final Writer writer;
    private final String name;
    private boolean errorEnabled = true;
    private boolean warnEnabled = true;
    private boolean infoEnabled = true;
    private boolean debugEnabled = true;

    public WriterLogger(Writer writer) {
        this(writer, "net.htmlparser.jericho");
    }

    public WriterLogger(Writer writer, String string) {
        this.writer = writer;
        this.name = string;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void error(String string) {
        if (this.isErrorEnabled()) {
            this.log("ERROR", string);
        }
    }

    @Override
    public void warn(String string) {
        if (this.isWarnEnabled()) {
            this.log("WARN", string);
        }
    }

    @Override
    public void info(String string) {
        if (this.isInfoEnabled()) {
            this.log("INFO", string);
        }
    }

    @Override
    public void debug(String string) {
        if (this.isDebugEnabled()) {
            this.log("DEBUG", string);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public void setErrorEnabled(boolean bl) {
        this.errorEnabled = bl;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public void setWarnEnabled(boolean bl) {
        this.warnEnabled = bl;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public void setInfoEnabled(boolean bl) {
        this.infoEnabled = bl;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean bl) {
        this.debugEnabled = bl;
    }

    protected void log(String string, String string2) {
        try {
            this.writer.write(BasicLogFormatter.format(string, string2, this.name));
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

