/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import java.util.Collection;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResponseMessage;
import org.ldaptive.control.ResponseControl;

public class SearchReference
implements ResponseMessage {
    private static final int HASH_CODE_SEED = 349;
    private final String[] referralUrls;
    private final ResponseControl[] responseControls;
    private final int messageId;

    public SearchReference(int id, ResponseControl[] c, String ... url) {
        this.messageId = id;
        this.responseControls = c;
        this.referralUrls = url;
    }

    public SearchReference(int id, ResponseControl[] c, Collection<String> urls) {
        this.messageId = id;
        this.responseControls = c;
        this.referralUrls = urls.toArray(new String[urls.size()]);
    }

    public String[] getReferralUrls() {
        return this.referralUrls;
    }

    public ResponseControl[] getControls() {
        return this.responseControls;
    }

    @Override
    public ResponseControl getControl(String oid) {
        if (this.getControls() != null) {
            for (ResponseControl c : this.getControls()) {
                if (!c.getOID().equals(oid)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(349, this.referralUrls, this.responseControls, this.messageId);
    }

    public String toString() {
        return String.format("[%s@%d::referralUrls=%s, responseControls=%s, messageId=%s]", this.getClass().getName(), this.hashCode(), Arrays.toString(this.referralUrls), Arrays.toString(this.responseControls), this.messageId);
    }
}

