/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.layout;

import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class EventDetailLayout
extends Layout {
    private EnhancedPatternLayout patternLayout = new EnhancedPatternLayout();

    public void setConversionPattern(String conversionPattern) {
        this.patternLayout.setConversionPattern(conversionPattern);
        this.patternLayout.activateOptions();
    }

    public String getConversionPattern() {
        return this.patternLayout.getConversionPattern();
    }

    @Override
    public String getFooter() {
        return "";
    }

    @Override
    public String getHeader() {
        return "";
    }

    private static String escape(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private static LoggingEvent copyForHTML(LoggingEvent event) {
        Logger logger = Logger.getLogger(event.getLoggerName());
        String threadName = event.getThreadName();
        String msg = EventDetailLayout.escape(event.getMessage().toString());
        String ndc = event.getNDC();
        LocationInfo li = null;
        if (event.locationInformationExists()) {
            li = EventDetailLayout.formatLocationInfo(event);
        }
        Hashtable properties = EventDetailLayout.formatProperties(event);
        LoggingEvent copy = new LoggingEvent(null, logger, event.getTimeStamp(), event.getLevel(), msg, threadName, event.getThrowableInformation(), ndc, li, properties);
        return copy;
    }

    private static LocationInfo formatLocationInfo(LoggingEvent event) {
        LocationInfo info = event.getLocationInformation();
        LocationInfo newInfo = new LocationInfo(EventDetailLayout.escape(info.getFileName()), EventDetailLayout.escape(info.getClassName()), EventDetailLayout.escape(info.getMethodName()), EventDetailLayout.escape(info.getLineNumber()));
        return newInfo;
    }

    private static Hashtable formatProperties(LoggingEvent event) {
        Set keySet = event.getPropertyKeySet();
        Hashtable<String, String> hashTable = new Hashtable<String, String>();
        for (Object key : keySet) {
            String value = event.getProperty(key.toString());
            hashTable.put(EventDetailLayout.escape(key.toString()), EventDetailLayout.escape(value.toString()));
        }
        return hashTable;
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }

    @Override
    public void activateOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LoggingEvent event) {
        LoggingEvent newEvent = EventDetailLayout.copyForHTML(event);
        EnhancedPatternLayout enhancedPatternLayout = this.patternLayout;
        synchronized (enhancedPatternLayout) {
            return this.patternLayout.format(newEvent);
        }
    }
}

