/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.AbstractPreferencePanel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.BasicPrefPanel;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.osx.OSXIntegration;

public class ApplicationPreferenceModelPanel
extends AbstractPreferencePanel {
    private ApplicationPreferenceModel committedPreferenceModel;
    private ApplicationPreferenceModel uncommittedPreferenceModel = new ApplicationPreferenceModel();
    private JTextField identifierExpression;
    private JTextField toolTipDisplayMillis;
    private JTextField cyclicBufferSize;
    private JComboBox<String> configurationURL;
    private final Logger logger;
    private GeneralAllPrefPanel generalAllPrefPanel;

    ApplicationPreferenceModelPanel(ApplicationPreferenceModel model) {
        this.committedPreferenceModel = model;
        this.logger = LogManager.getLogger(ApplicationPreferenceModelPanel.class);
        this.initComponents();
        this.getOkButton().addActionListener(e -> {
            this.uncommittedPreferenceModel.setConfigurationURL((String)this.configurationURL.getSelectedItem());
            this.uncommittedPreferenceModel.setIdentifierExpression(this.identifierExpression.getText());
            try {
                int millis = Integer.parseInt(this.toolTipDisplayMillis.getText());
                if (millis >= 0) {
                    this.uncommittedPreferenceModel.setToolTipDisplayMillis(millis);
                }
            }
            catch (NumberFormatException millis) {
                // empty catch block
            }
            try {
                int bufferSize = Integer.parseInt(this.cyclicBufferSize.getText());
                if (bufferSize >= 0) {
                    this.uncommittedPreferenceModel.setCyclicBufferSize(bufferSize);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.committedPreferenceModel.apply(this.uncommittedPreferenceModel);
            this.hidePanel();
        });
        this.getCancelButton().addActionListener(e -> {
            this.uncommittedPreferenceModel.apply(this.committedPreferenceModel);
            this.hidePanel();
        });
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("App Preferences Panel Test Bed");
        ApplicationPreferenceModel model = new ApplicationPreferenceModel();
        ApplicationPreferenceModelPanel panel = new ApplicationPreferenceModelPanel(model);
        f.getContentPane().add(panel);
        model.addPropertyChangeListener(System.out::println);
        panel.setOkCancelActionListener(e -> System.exit(1));
        f.setSize(640, 480);
        f.setVisible(true);
    }

    public void updateModel() {
        this.uncommittedPreferenceModel.apply(this.committedPreferenceModel);
    }

    @Override
    protected TreeModel createTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Preferences");
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        this.generalAllPrefPanel = new GeneralAllPrefPanel();
        DefaultMutableTreeNode general = new DefaultMutableTreeNode(this.generalAllPrefPanel);
        DefaultMutableTreeNode visuals = new DefaultMutableTreeNode(new VisualsPrefPanel());
        rootNode.add(general);
        rootNode.add(visuals);
        return model;
    }

    public class GeneralAllPrefPanel
    extends BasicPrefPanel {
        private final JCheckBox showNoReceiverWarning;
        private final JCheckBox showSplash;
        private final JSlider responsiveSlider;
        private final JCheckBox confirmExit;
        Dictionary<Integer, JLabel> sliderLabelMap;
        private final JCheckBox okToRemoveSecurityManager;

        public GeneralAllPrefPanel() {
            super("General");
            this.showNoReceiverWarning = new JCheckBox(" Prompt me on startup if there are no Receivers defined ");
            this.showSplash = new JCheckBox(" Show Splash screen at startup ");
            this.responsiveSlider = new JSlider(0, 1, 4, 2);
            this.confirmExit = new JCheckBox(" Confirm Exit ");
            this.sliderLabelMap = new Hashtable<Integer, JLabel>();
            this.okToRemoveSecurityManager = new JCheckBox(" Ok to remove SecurityManager ");
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 1));
            ApplicationPreferenceModelPanel.this.configurationURL = new JComboBox<String>(new DefaultComboBoxModel<String>(ApplicationPreferenceModelPanel.this.committedPreferenceModel.getConfigurationURLs()));
            ApplicationPreferenceModelPanel.this.configurationURL.setEditable(true);
            ApplicationPreferenceModelPanel.this.configurationURL.setPrototypeDisplayValue("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
            ApplicationPreferenceModelPanel.this.configurationURL.setPreferredSize(new Dimension(375, 13));
            ApplicationPreferenceModelPanel.this.identifierExpression = new JTextField(30);
            ApplicationPreferenceModelPanel.this.toolTipDisplayMillis = new JTextField(8);
            ApplicationPreferenceModelPanel.this.cyclicBufferSize = new JTextField(8);
            Box p = new Box(0);
            p.add(this.showNoReceiverWarning);
            p.add(Box.createHorizontalGlue());
            this.confirmExit.setToolTipText("If set, you prompt to confirm Chainsaw exit");
            this.okToRemoveSecurityManager.setToolTipText("You will need to tick this to be able to load Receivers/Plugins that require external dependancies.");
            this.setupInitialValues();
            this.setupListeners();
            this.initSliderComponent();
            this.add(this.responsiveSlider);
            JPanel p1 = new JPanel(new FlowLayout(0));
            p1.add(new JLabel(" Tab name/event routing expression "));
            p1.add(Box.createHorizontalStrut(5));
            p1.add(ApplicationPreferenceModelPanel.this.identifierExpression);
            this.add(p1);
            this.add(p);
            Box p2 = new Box(0);
            p2.add(this.confirmExit);
            p2.add(Box.createHorizontalGlue());
            Box p3 = new Box(0);
            p3.add(this.showSplash);
            p3.add(Box.createHorizontalGlue());
            Box ok4 = new Box(0);
            ok4.add(this.okToRemoveSecurityManager);
            ok4.add(Box.createHorizontalGlue());
            this.add(p2);
            this.add(p3);
            this.add(ok4);
            JPanel p4 = new JPanel(new FlowLayout(0));
            p4.add(new JLabel(" ToolTip Display (millis) "));
            p4.add(Box.createHorizontalStrut(5));
            p4.add(ApplicationPreferenceModelPanel.this.toolTipDisplayMillis);
            this.add(p4);
            JPanel p5 = new JPanel(new FlowLayout(0));
            p5.add(new JLabel(" Cyclic buffer size "));
            p5.add(Box.createHorizontalStrut(5));
            p5.add(ApplicationPreferenceModelPanel.this.cyclicBufferSize);
            p5.add(Box.createHorizontalStrut(5));
            p5.add(new JLabel(" (effective on restart) "));
            this.add(p5);
            Box p6 = new Box(1);
            Box configURLPanel = new Box(0);
            JLabel configLabel = new JLabel(" Auto Config URL ");
            configURLPanel.add(configLabel);
            configURLPanel.add(Box.createHorizontalStrut(5));
            configURLPanel.add(ApplicationPreferenceModelPanel.this.configurationURL);
            configURLPanel.add(Box.createHorizontalGlue());
            p6.add(configURLPanel);
            JButton browseButton = new JButton(" Open File... ");
            browseButton.addActionListener(e -> this.browseForConfiguration());
            Box browsePanel = new Box(0);
            browsePanel.add(Box.createHorizontalGlue());
            browsePanel.add(browseButton);
            p6.add(Box.createVerticalStrut(5));
            p6.add(browsePanel);
            p6.add(Box.createVerticalGlue());
            this.add(p6);
            ApplicationPreferenceModelPanel.this.configurationURL.setToolTipText("A complete and valid URL identifying the location of a valid log4 xml configuration file to auto-configure Receivers and other Plugins");
            ApplicationPreferenceModelPanel.this.configurationURL.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    try {
                        String selectedItem = (String)ApplicationPreferenceModelPanel.this.configurationURL.getSelectedItem();
                        if (selectedItem != null && !selectedItem.trim().equals("")) {
                            new URL(selectedItem);
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
            });
            String configToDisplay = ApplicationPreferenceModelPanel.this.committedPreferenceModel.getBypassConfigurationURL() != null ? ApplicationPreferenceModelPanel.this.committedPreferenceModel.getBypassConfigurationURL() : ApplicationPreferenceModelPanel.this.committedPreferenceModel.getConfigurationURL();
            ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(configToDisplay);
        }

        public void browseForConfiguration() {
            File selectedFile;
            File currentConfigurationPath;
            Object selectedItem;
            String defaultPath = ".";
            if (ApplicationPreferenceModelPanel.this.configurationURL.getItemCount() > 0 && (selectedItem = ApplicationPreferenceModelPanel.this.configurationURL.getSelectedItem()) != null && (currentConfigurationPath = new File(selectedItem.toString()).getParentFile()) != null && (defaultPath = currentConfigurationPath.getPath()).toLowerCase(Locale.ENGLISH).startsWith("file:\\")) {
                defaultPath = defaultPath.substring("file:\\".length());
            }
            if ((selectedFile = SwingHelper.promptForFile(this, defaultPath, "Select a Chainsaw configuration file", true)) != null) {
                try {
                    String newConfigurationFile = selectedFile.toURI().toURL().toExternalForm();
                    if (!ApplicationPreferenceModelPanel.this.committedPreferenceModel.getConfigurationURLs().contains(newConfigurationFile)) {
                        ApplicationPreferenceModelPanel.this.configurationURL.addItem(newConfigurationFile);
                    }
                    ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(newConfigurationFile);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        }

        private void initSliderComponent() {
            this.responsiveSlider.setToolTipText("Adjust to set the responsiveness of the app.  How often the view is updated.");
            this.responsiveSlider.setSnapToTicks(true);
            this.responsiveSlider.setLabelTable(this.sliderLabelMap);
            this.responsiveSlider.setPaintLabels(true);
            this.responsiveSlider.setPaintTrack(true);
            this.responsiveSlider.setBorder(BorderFactory.createTitledBorder(" Responsiveness "));
        }

        private void setupListeners() {
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("showNoReceiverWarning", evt -> this.showNoReceiverWarning.setSelected((Boolean)evt.getNewValue()));
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("showSplash", evt -> {
                boolean value = (Boolean)evt.getNewValue();
                this.showSplash.setSelected(value);
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("okToRemoveSecurityManager", evt -> {
                boolean newValue = (Boolean)evt.getNewValue();
                if (newValue) {
                    this.okToRemoveSecurityManager.setSelected(newValue);
                } else {
                    this.okToRemoveSecurityManager.setSelected(false);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("identifierExpression", evt -> ApplicationPreferenceModelPanel.this.identifierExpression.setText(evt.getNewValue().toString()));
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("responsiveness", evt -> {
                int value = (Integer)evt.getNewValue();
                if (value >= 1000) {
                    int newValue = (value - 750) / 1000;
                    ApplicationPreferenceModelPanel.this.logger.debug("Adjusting old Responsiveness value from " + value + " to " + newValue);
                    value = newValue;
                }
                this.responsiveSlider.setValue(value);
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("toolTipDisplayMillis", evt -> ApplicationPreferenceModelPanel.this.toolTipDisplayMillis.setText(evt.getNewValue().toString()));
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("cyclicBufferSize", evt -> ApplicationPreferenceModelPanel.this.cyclicBufferSize.setText(evt.getNewValue().toString()));
            this.showNoReceiverWarning.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setShowNoReceiverWarning(this.showNoReceiverWarning.isSelected()));
            this.showSplash.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setShowSplash(this.showSplash.isSelected()));
            this.okToRemoveSecurityManager.addActionListener(e -> {
                if (this.okToRemoveSecurityManager.isSelected() && JOptionPane.showConfirmDialog(this.okToRemoveSecurityManager, "By ticking this option, you are authorizing Chainsaw to remove Java's Security Manager.\n\nThis is required under Java Web Start so that it can access Jars/classes locally.  Without this, Receivers like JMSReceiver + DBReceiver that require specific driver jars will NOT be able to be run.  \n\nBy ticking this, you are saying that this is ok.", "Please Confirm", 0) == 0) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setOkToRemoveSecurityManager(true);
                } else {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setOkToRemoveSecurityManager(false);
                }
            });
            this.responsiveSlider.getModel().addChangeListener(e -> {
                if (!this.responsiveSlider.getValueIsAdjusting()) {
                    int value = this.responsiveSlider.getValue();
                    if (value == 0) {
                        value = 1;
                    }
                    ApplicationPreferenceModelPanel.this.logger.debug("Adjust responsiveness to " + value);
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setResponsiveness(value);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("confirmExit", evt -> {
                boolean value = (Boolean)evt.getNewValue();
                this.confirmExit.setSelected(value);
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("configurationURL", evt -> {
                String value = evt.getNewValue().toString();
                ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(value);
            });
            this.confirmExit.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setConfirmExit(this.confirmExit.isSelected()));
        }

        private void setupInitialValues() {
            this.sliderLabelMap.put(1, new JLabel(" Fastest "));
            this.sliderLabelMap.put(2, new JLabel(" Fast "));
            this.sliderLabelMap.put(3, new JLabel(" Medium "));
            this.sliderLabelMap.put(4, new JLabel(" Slow "));
            this.showNoReceiverWarning.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isShowNoReceiverWarning());
            ApplicationPreferenceModelPanel.this.identifierExpression.setText(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getIdentifierExpression());
            this.confirmExit.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isConfirmExit());
            this.okToRemoveSecurityManager.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isOkToRemoveSecurityManager());
            this.showNoReceiverWarning.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isShowNoReceiverWarning());
            this.showSplash.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isShowSplash());
            ApplicationPreferenceModelPanel.this.identifierExpression.setText(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getIdentifierExpression());
            ApplicationPreferenceModelPanel.this.toolTipDisplayMillis.setText("" + ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getToolTipDisplayMillis());
            ApplicationPreferenceModelPanel.this.cyclicBufferSize.setText("" + ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getCyclicBufferSize());
            ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getConfigurationURL());
        }
    }

    public class VisualsPrefPanel
    extends BasicPrefPanel {
        private final JRadioButton topPlacement;
        private final JRadioButton bottomPlacement;
        private final JCheckBox statusBar;
        private final JCheckBox toolBar;
        private final JCheckBox receivers;
        private UIManager.LookAndFeelInfo[] lookAndFeels;
        private final ButtonGroup lookAndFeelGroup;

        private VisualsPrefPanel() {
            super("Visuals");
            this.topPlacement = new JRadioButton(" Top         ");
            this.bottomPlacement = new JRadioButton(" Bottom         ");
            this.statusBar = new JCheckBox(" Show Status bar ");
            this.toolBar = new JCheckBox(" Show Toolbar ");
            this.receivers = new JCheckBox(" Show Receivers ");
            this.lookAndFeels = UIManager.getInstalledLookAndFeels();
            this.lookAndFeelGroup = new ButtonGroup();
            UIManager.LookAndFeelInfo[] newLookAndFeels = new UIManager.LookAndFeelInfo[this.lookAndFeels.length];
            boolean useNewLookAndFeels = false;
            int j = 0;
            for (UIManager.LookAndFeelInfo lookAndFeel : this.lookAndFeels) {
                if (lookAndFeel.getClassName().toLowerCase(Locale.ENGLISH).contains("nimbus")) {
                    useNewLookAndFeels = true;
                    continue;
                }
                newLookAndFeels[j++] = lookAndFeel;
            }
            if (useNewLookAndFeels) {
                UIManager.LookAndFeelInfo[] replacedLookAndFeels = new UIManager.LookAndFeelInfo[this.lookAndFeels.length - 1];
                System.arraycopy(newLookAndFeels, 0, replacedLookAndFeels, 0, newLookAndFeels.length - 1);
                this.lookAndFeels = replacedLookAndFeels;
            }
            this.setupComponents();
            this.setupListeners();
            this.setupInitialValues();
        }

        private void setupListeners() {
            this.topPlacement.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setTabPlacement(1));
            this.bottomPlacement.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setTabPlacement(3));
            this.statusBar.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setStatusBar(this.statusBar.isSelected()));
            this.toolBar.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setToolbar(this.toolBar.isSelected()));
            this.receivers.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setReceivers(this.receivers.isSelected()));
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("tabPlacement", evt -> {
                int value = (Integer)evt.getNewValue();
                this.configureTabPlacement(value);
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("statusBar", evt -> this.statusBar.setSelected((Boolean)evt.getNewValue()));
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("toolbar", evt -> this.toolBar.setSelected((Boolean)evt.getNewValue()));
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("receivers", evt -> this.receivers.setSelected((Boolean)evt.getNewValue()));
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("lookAndFeelClassName", evt -> {
                String lf = evt.getNewValue().toString();
                Enumeration<AbstractButton> enumeration = this.lookAndFeelGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    JRadioButton button = (JRadioButton)enumeration.nextElement();
                    if (button.getName() == null || !button.getName().equals(lf)) continue;
                    button.setSelected(true);
                    break;
                }
            });
        }

        private void setupComponents() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel tabPlacementBox = new JPanel();
            tabPlacementBox.setLayout(new BoxLayout(tabPlacementBox, 1));
            tabPlacementBox.setBorder(BorderFactory.createTitledBorder(" Tab Placement "));
            ButtonGroup tabPlacementGroup = new ButtonGroup();
            tabPlacementGroup.add(this.topPlacement);
            tabPlacementGroup.add(this.bottomPlacement);
            tabPlacementBox.add(this.topPlacement);
            tabPlacementBox.add(this.bottomPlacement);
            if (OSXIntegration.IS_OSX) {
                tabPlacementBox.setEnabled(false);
                this.topPlacement.setEnabled(false);
                this.bottomPlacement.setEnabled(false);
            }
            this.add(tabPlacementBox);
            this.add(this.statusBar);
            this.add(this.receivers);
            this.add(this.toolBar);
            JPanel lfPanel = new JPanel();
            lfPanel.setLayout(new BoxLayout(lfPanel, 1));
            lfPanel.setBorder(BorderFactory.createTitledBorder(" Look & Feel "));
            for (UIManager.LookAndFeelInfo lfInfo : this.lookAndFeels) {
                JRadioButton lfItem = new JRadioButton(" " + lfInfo.getName() + " ");
                lfItem.setName(lfInfo.getClassName());
                lfItem.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setLookAndFeelClassName(lfInfo.getClassName()));
                this.lookAndFeelGroup.add(lfItem);
                lfPanel.add(lfItem);
            }
            try {
                Class<?> gtkLF = Class.forName("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                JRadioButton lfIGTK = new JRadioButton(" GTK+ 2.0 ");
                lfIGTK.addActionListener(e -> ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setLookAndFeelClassName(gtkLF.getName()));
                this.lookAndFeelGroup.add(lfIGTK);
                lfPanel.add(lfIGTK);
            }
            catch (Exception e2) {
                ApplicationPreferenceModelPanel.this.logger.debug("Can't find new GTK L&F, might be Windows, or <JDK1.4.2");
            }
            this.add(lfPanel);
            this.add(new JLabel("<html>Look and Feel change will apply the next time you start Chainsaw.<br>If this value is not set, the default L&F of your system is used.</html>"));
        }

        private void configureTabPlacement(int value) {
            switch (value) {
                case 1: {
                    this.topPlacement.setSelected(true);
                    break;
                }
                case 3: {
                    this.bottomPlacement.setSelected(true);
                    break;
                }
            }
        }

        private void setupInitialValues() {
            this.statusBar.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isStatusBar());
            this.receivers.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isReceivers());
            this.toolBar.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isToolbar());
            this.configureTabPlacement(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getTabPlacement());
            Enumeration<AbstractButton> e = this.lookAndFeelGroup.getElements();
            while (e.hasMoreElements()) {
                JRadioButton radioButton = (JRadioButton)e.nextElement();
                if (!radioButton.getText().equals(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getLookAndFeelClassName())) continue;
                radioButton.setSelected(true);
                break;
            }
        }
    }
}

