/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.logging.log4j.changelog.util.StringUtils;
import org.apache.logging.log4j.changelog.util.XmlReader;
import org.apache.logging.log4j.changelog.util.XmlWriter;
import org.w3c.dom.Element;

public final class ChangelogEntry {
    public final Type type;
    public final List<Issue> issues;
    public final Description description;

    public ChangelogEntry(Type type, List<Issue> issues, Description description) {
        this.type = type;
        this.issues = issues;
        this.description = description;
    }

    public void writeToXmlFile(Path path) {
        XmlWriter.toFile(path, "entry", (document, entryElement) -> {
            entryElement.setAttribute("type", this.type.toXmlAttribute());
            this.issues.forEach(issue -> {
                Element issueElement = document.createElement("issue");
                issueElement.setAttribute("id", issue.id);
                issueElement.setAttribute("link", issue.link);
                entryElement.appendChild(issueElement);
            });
            Element descriptionElement = document.createElement("description");
            if (this.description.format != null) {
                descriptionElement.setAttribute("format", this.description.format);
            }
            descriptionElement.setTextContent(this.description.text);
            entryElement.appendChild(descriptionElement);
        });
    }

    public static ChangelogEntry readFromXmlFile(Path path) {
        Type type;
        Element entryElement = XmlReader.readXmlFileRootElement(path, "entry");
        String typeAttribute = XmlReader.requireAttribute(entryElement, "type");
        try {
            type = Type.fromXmlAttribute(typeAttribute);
        }
        catch (Exception error) {
            throw XmlReader.failureAtXmlNode(error, entryElement, "`type` attribute read failure", new Object[0]);
        }
        List<Issue> issues = XmlReader.findChildElementsMatchingName(entryElement, "issue").map(issueElement -> {
            String issueId = XmlReader.requireAttribute(issueElement, "id");
            String issueLink = XmlReader.requireAttribute(issueElement, "link");
            return new Issue(issueId, issueLink);
        }).collect(Collectors.toList());
        Element descriptionElement = XmlReader.requireChildElementMatchingName(entryElement, "description");
        String descriptionFormat = XmlReader.requireAttribute(descriptionElement, "format");
        String descriptionText = StringUtils.trimNullable(descriptionElement.getTextContent());
        Description description = new Description(descriptionFormat, descriptionText);
        return new ChangelogEntry(type, issues, description);
    }

    public static enum Type {
        ADDED,
        CHANGED,
        DEPRECATED,
        FIXED,
        REMOVED,
        UPDATED;


        private String toXmlAttribute() {
            return this.toString().toLowerCase(Locale.US);
        }

        private static Type fromXmlAttribute(String attribute) {
            String upperCaseAttribute = attribute != null ? attribute.toUpperCase(Locale.US) : null;
            return Type.valueOf(upperCaseAttribute);
        }
    }

    public static final class Description {
        public final String format;
        public final String text;

        public Description(String format, String text) {
            this.format = format;
            this.text = text;
        }
    }

    public static final class Issue {
        public final String id;
        public final String link;

        public Issue(String id, String link) {
            this.id = id;
            this.link = link;
        }
    }
}

