/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

import java.util.ArrayDeque;
import java.util.Deque;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

final class PositionalSaxEventHandler
extends DefaultHandler {
    private final Deque<Element> elementStack = new ArrayDeque<Element>();
    private final StringBuilder textBuffer = new StringBuilder();
    private final Document document;
    private Locator locator;

    PositionalSaxEventHandler(Document document) {
        this.document = document;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.addTextIfNeeded();
        Element element = this.document.createElement(qName);
        for (int attributeIndex = 0; attributeIndex < attributes.getLength(); ++attributeIndex) {
            String attributeQName = attributes.getQName(attributeIndex);
            String attributeValue = attributes.getValue(attributeIndex);
            element.setAttribute(attributeQName, attributeValue);
        }
        element.setUserData("lineNumber", String.valueOf(this.locator.getLineNumber()), null);
        this.elementStack.addFirst(element);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Element closedElement = this.elementStack.removeFirst();
        boolean rootElement = this.elementStack.isEmpty();
        if (rootElement) {
            this.document.appendChild(closedElement);
        } else {
            Element parentElement = this.elementStack.peekFirst();
            parentElement.appendChild(closedElement);
        }
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.textBuffer.append(buffer, start, length);
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.length() > 0) {
            Element element = this.elementStack.peekFirst();
            Text textNode = this.document.createTextNode(this.textBuffer.toString());
            element.appendChild(textNode);
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }
}

