/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.appender;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Configurable(printObject=true)
@Plugin(value="Column")
public final class ColumnConfig {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String columnName;
    private final String columnNameKey;
    private final PatternLayout layout;
    private final String literalValue;
    private final boolean eventTimestamp;
    private final boolean unicode;
    private final boolean clob;

    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private ColumnConfig(String columnName, PatternLayout layout, String literalValue, boolean eventDate, boolean unicode, boolean clob) {
        this.columnName = columnName;
        this.columnNameKey = ColumnMapping.toKey((String)columnName);
        this.layout = layout;
        this.literalValue = literalValue;
        this.eventTimestamp = eventDate;
        this.unicode = unicode;
        this.clob = clob;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnNameKey() {
        return this.columnNameKey;
    }

    public PatternLayout getLayout() {
        return this.layout;
    }

    public String getLiteralValue() {
        return this.literalValue;
    }

    public boolean isClob() {
        return this.clob;
    }

    public boolean isEventTimestamp() {
        return this.eventTimestamp;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public String toString() {
        return "{ name=" + this.columnName + ", layout=" + this.layout + ", literal=" + this.literalValue + ", timestamp=" + this.eventTimestamp + " }";
    }

    public static class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<ColumnConfig> {
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        @Required(message="No name provided")
        private String name;
        @PluginBuilderAttribute
        private String pattern;
        @PluginBuilderAttribute
        private String literal;
        @PluginBuilderAttribute
        private boolean isEventTimestamp;
        @PluginBuilderAttribute
        private boolean isUnicode = true;
        @PluginBuilderAttribute
        private boolean isClob;

        public ColumnConfig build() {
            if (Strings.isEmpty((CharSequence)this.name)) {
                LOGGER.error("The column config is not valid because it does not contain a column name.");
                return null;
            }
            boolean isPattern = Strings.isNotEmpty((CharSequence)this.pattern);
            boolean isLiteralValue = Strings.isNotEmpty((CharSequence)this.literal);
            if (isPattern && isLiteralValue || isPattern && this.isEventTimestamp || isLiteralValue && this.isEventTimestamp) {
                LOGGER.error("The pattern, literal, and isEventTimestamp attributes are mutually exclusive.");
                return null;
            }
            if (this.isEventTimestamp) {
                return new ColumnConfig(this.name, null, null, true, false, false);
            }
            if (isLiteralValue) {
                return new ColumnConfig(this.name, null, this.literal, false, false, false);
            }
            if (isPattern) {
                PatternLayout layout = PatternLayout.newBuilder().setPattern(this.pattern).setConfiguration(this.configuration).setAlwaysWriteExceptions(false).build();
                return new ColumnConfig(this.name, layout, null, false, this.isUnicode, this.isClob);
            }
            LOGGER.error("To configure a column you must specify a pattern or literal or set isEventDate to true.");
            return null;
        }

        public Builder setClob(boolean clob) {
            this.isClob = clob;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setEventTimestamp(boolean eventTimestamp) {
            this.isEventTimestamp = eventTimestamp;
            return this;
        }

        public Builder setLiteral(String literal) {
            this.literal = literal;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder setUnicode(boolean unicode) {
            this.isUnicode = unicode;
            return this;
        }
    }
}

