/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.async.logger.AsyncLogger;
import org.apache.logging.log4j.async.logger.AsyncLoggerDisruptor;
import org.apache.logging.log4j.async.logger.internal.AsyncLoggerDefaultBundle;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;

public class AsyncLoggerContext
extends LoggerContext {
    private final Lazy<AsyncLoggerDisruptor> loggerDisruptor = Lazy.lazy(() -> ((AsyncLoggerDisruptor.Factory)this.getInstanceFactory().getInstance(AsyncLoggerDisruptor.Factory.class)).createAsyncLoggerDisruptor(this.getName()));

    public AsyncLoggerContext(String name, Object externalContext, URI configLocation, ConfigurableInstanceFactory instanceFactory) {
        super(name, externalContext, configLocation, instanceFactory);
        instanceFactory.registerBundle(AsyncLoggerDefaultBundle.class);
        instanceFactory.registerBinding(Key.forClass(AsyncLoggerDisruptor.class), this.loggerDisruptor);
    }

    protected Class<? extends Logger.Builder> getLoggerBuilderClass() {
        return AsyncLogger.Builder.class;
    }

    public void setName(String name) {
        super.setName("AsyncContext[" + name + "]");
        if (this.loggerDisruptor.isInitialized()) {
            ((AsyncLoggerDisruptor)((Object)this.loggerDisruptor.get())).setContextName(name);
        }
    }

    public void start() {
        this.getAsyncLoggerDisruptor().start();
        super.start();
    }

    public void start(Configuration config) {
        if (config instanceof DefaultConfiguration) {
            StatusLogger.getLogger().debug("[{}] Not starting Disruptor for DefaultConfiguration.", (Object)this.getName());
        } else {
            this.getAsyncLoggerDisruptor().start();
        }
        super.start(config);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        if (this.loggerDisruptor.isInitialized()) {
            ((AsyncLoggerDisruptor)((Object)this.loggerDisruptor.get())).stop(timeout, timeUnit);
        }
        super.stop(timeout, timeUnit);
        return true;
    }

    public boolean includeLocation() {
        return false;
    }

    AsyncLoggerDisruptor getAsyncLoggerDisruptor() {
        return (AsyncLoggerDisruptor)((Object)this.loggerDisruptor.get());
    }

    public static final class Builder
    extends LoggerContext.Builder {
        @Inject
        public Builder(ConfigurableInstanceFactory parentInstanceFactory) {
            super(parentInstanceFactory);
        }

        public LoggerContext build() {
            return new AsyncLoggerContext(this.getContextName(), null, this.getConfigLocation(), this.createInstanceFactory());
        }
    }
}

