﻿namespace Lucene.Net.QueryParsers.Surround.Parser
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    public static class RegexpToken
    {
        /// <summary>End of File. </summary>
        public const int EOF = 0;
        /// <summary>RegularExpression Id. </summary>
        public const int NUM_CHAR = 1; // LUCENENET specific: removed leading underscore to make CLS compliant
        /// <summary>RegularExpression Id. </summary>
        public const int TERM_CHAR = 2; // LUCENENET specific: removed leading underscore to make CLS compliant
        /// <summary>RegularExpression Id. </summary>
        public const int WHITESPACE = 3; // LUCENENET specific: removed leading underscore to make CLS compliant
        /// <summary>RegularExpression Id. </summary>
        public const int STAR = 4; // LUCENENET specific: removed leading underscore to make CLS compliant
        /// <summary>RegularExpression Id. </summary>
        public const int ONE_CHAR = 5; // LUCENENET specific: removed leading underscore to make CLS compliant
        /// <summary>RegularExpression Id. </summary>
        public const int DISTOP_NUM = 6; // LUCENENET specific: removed leading underscore to make CLS compliant
        /// <summary>RegularExpression Id. </summary>
        public const int OR = 8;
        /// <summary>RegularExpression Id. </summary>
        public const int AND = 9;
        /// <summary>RegularExpression Id. </summary>
        public const int NOT = 10;
        /// <summary>RegularExpression Id. </summary>
        public const int W = 11;
        /// <summary>RegularExpression Id. </summary>
        public const int N = 12;
        /// <summary>RegularExpression Id. </summary>
        public const int LPAREN = 13;
        /// <summary>RegularExpression Id. </summary>
        public const int RPAREN = 14;
        /// <summary>RegularExpression Id. </summary>
        public const int COMMA = 15;
        /// <summary>RegularExpression Id. </summary>
        public const int COLON = 16;
        /// <summary>RegularExpression Id. </summary>
        public const int CARAT = 17;
        /// <summary>RegularExpression Id. </summary>
        public const int TRUNCQUOTED = 18;
        /// <summary>RegularExpression Id. </summary>
        public const int QUOTED = 19;
        /// <summary>RegularExpression Id. </summary>
        public const int SUFFIXTERM = 20;
        /// <summary>RegularExpression Id. </summary>
        public const int TRUNCTERM = 21;
        /// <summary>RegularExpression Id. </summary>
        public const int TERM = 22;
        /// <summary>RegularExpression Id. </summary>
        public const int NUMBER = 23;
    }

    public static class LexicalToken
    {
        /// <summary>Lexical state.</summary>
        public const int Boost = 0;
        /// <summary>Lexical state.</summary>
        public const int DEFAULT = 2;
    }

    // NOTE: In Java, this was an interface. However, in 
    // .NET we cannot define constants in an interface.
    // So, instead we are making it a static class so it 
    // can be shared between classes with different base classes.

    // public interface QueryParserConstants

    /// <summary> Token literal values and constants.
    /// Generated by org.javacc.parser.OtherFilesGen#start()
    /// </summary>
    public static class QueryParserConstants
    {
        /// <summary>Literal token values. </summary>
        public static string[] TokenImage = new string[] {
            "<EOF>",
            "<_NUM_CHAR>",
            "<_TERM_CHAR>",
            "<_WHITESPACE>",
            "\"*\"",
            "\"?\"",
            "<_DISTOP_NUM>",
            "<token of kind 7>",
            "<OR>",
            "<AND>",
            "<NOT>",
            "<W>",
            "<N>",
            "\"(\"",
            "\")\"",
            "\",\"",
            "\":\"",
            "\"^\"",
            "<TRUNCQUOTED>",
            "<QUOTED>",
            "<SUFFIXTERM>",
            "<TRUNCTERM>",
            "<TERM>",
            "<NUMBER>"
        };
    }
}