/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.GenericArrayCreator;
import com.jmatio.types.MLArray;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLChar
extends MLArray
implements GenericArrayCreator<Character> {
    Character[] chars = this.createArray(this.getM(), this.getN());

    public MLChar(String name, String value) {
        this(name, new int[]{1, value.length()}, 4, 0);
        this.set(value);
    }

    public MLChar(String name, String[] values) {
        this(name, new int[]{values.length, values.length > 0 ? MLChar.getMaxLength(values) : 0}, 4, 0);
        for (int i = 0; i < values.length; ++i) {
            this.set(values[i], i);
        }
    }

    private static int getMaxLength(String[] values) {
        int result = 0;
        int curr = 0;
        for (int i = 0; i < values.length; ++i) {
            curr = values[i].length();
            if (curr <= result) continue;
            result = curr;
        }
        return result;
    }

    public MLChar(String name, String[] values, int maxlen) {
        this(name, new int[]{values.length, maxlen}, 4, 0);
        int idx = 0;
        for (String v : values) {
            this.set(v, idx);
            ++idx;
        }
    }

    public MLChar(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public Character[] createArray(int m, int n) {
        return new Character[m * n];
    }

    public void setChar(char ch, int index) {
        this.chars[index] = Character.valueOf(ch);
    }

    public void set(String value) {
        char[] cha = value.toCharArray();
        for (int i = 0; i < this.getN() && i < value.length(); ++i) {
            this.setChar(cha[i], i);
        }
    }

    public void set(String value, int idx) {
        int rowOffset = this.getM();
        for (int i = 0; i < this.getN(); ++i) {
            if (i < value.length()) {
                this.setChar(value.charAt(i), idx + rowOffset * i);
                continue;
            }
            this.setChar(' ', idx + rowOffset * i);
        }
    }

    public Character getChar(int m, int n) {
        return this.chars[this.getIndex(m, n)];
    }

    public Character[] exportChar() {
        return this.chars;
    }

    public boolean equals(Object o) {
        if (o instanceof MLChar) {
            return Arrays.equals((Object[])this.chars, (Object[])((MLChar)o).chars);
        }
        return super.equals(o);
    }

    public String getString(int m) {
        StringBuffer charbuff = new StringBuffer();
        for (int n = 0; n < this.getN(); ++n) {
            charbuff.append(this.getChar(m, n));
        }
        return charbuff.toString().trim();
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + " = \n");
        for (int m = 0; m < this.getM(); ++m) {
            sb.append("\t");
            StringBuffer charbuff = new StringBuffer();
            charbuff.append("'");
            for (int n = 0; n < this.getN(); ++n) {
                charbuff.append(this.getChar(m, n));
            }
            charbuff.append("'");
            sb.append(charbuff);
            sb.append("\n");
        }
        return sb.toString();
    }
}

