/*
 * Decompiled with CFR 0.152.
 */
package org.noggit;

import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class JSONUtil {
    public static final char[] TRUE_CHARS = new char[]{'t', 'r', 'u', 'e'};
    public static final char[] FALSE_CHARS = new char[]{'f', 'a', 'l', 's', 'e'};
    public static final char[] NULL_CHARS = new char[]{'n', 'u', 'l', 'l'};
    public static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char VALUE_SEPARATOR = ',';
    public static final char NAME_SEPARATOR = ':';
    public static final char OBJECT_START = '{';
    public static final char OBJECT_END = '}';
    public static final char ARRAY_START = '[';
    public static final char ARRAY_END = ']';

    public static String toJSON(Object o) {
        CharArr out = new CharArr();
        new JSONWriter(out).write(o);
        return out.toString();
    }

    public static String toJSON(Object o, int indentSize) {
        CharArr out = new CharArr();
        new JSONWriter(out, indentSize).write(o);
        return out.toString();
    }

    public static void writeNumber(int number, CharArr out) {
        out.write(Integer.toString(number));
    }

    public static void writeNumber(long number, CharArr out) {
        out.write(Long.toString(number));
    }

    public static void writeNumber(float number, CharArr out) {
        out.write(Float.toString(number));
    }

    public static void writeNumber(double number, CharArr out) {
        out.write(Double.toString(number));
    }

    public static void writeString(CharArr val, CharArr out) {
        JSONUtil.writeString(val.getArray(), val.getStart(), val.getEnd(), out);
    }

    public static void writeString(char[] val, int start, int end, CharArr out) {
        out.write('\"');
        JSONUtil.writeStringPart(val, start, end, out);
        out.write('\"');
    }

    public static void writeString(CharSequence val, int start, int end, CharArr out) {
        out.write('\"');
        JSONUtil.writeStringPart(val, start, end, out);
        out.write('\"');
    }

    public static void writeStringPart(char[] val, int start, int end, CharArr out) {
        block8: for (int i = start; i < end; ++i) {
            char ch = val[i];
            switch (ch) {
                case '\"': 
                case '\\': {
                    out.write('\\');
                    out.write(ch);
                    continue block8;
                }
                case '\r': {
                    out.write('\\');
                    out.write('r');
                    continue block8;
                }
                case '\n': {
                    out.write('\\');
                    out.write('n');
                    continue block8;
                }
                case '\t': {
                    out.write('\\');
                    out.write('t');
                    continue block8;
                }
                case '\b': {
                    out.write('\\');
                    out.write('b');
                    continue block8;
                }
                case '\f': {
                    out.write('\\');
                    out.write('f');
                    continue block8;
                }
                default: {
                    if (ch <= '\u001f') {
                        JSONUtil.unicodeEscape(ch, out);
                        continue block8;
                    }
                    if (ch == '\u2028' || ch == '\u2029') {
                        JSONUtil.unicodeEscape(ch, out);
                        continue block8;
                    }
                    out.write(ch);
                }
            }
        }
    }

    public static void writeStringPart(CharSequence chars, int start, int end, CharArr out) {
        block8: for (int i = start; i < end; ++i) {
            char ch = chars.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    out.write('\\');
                    out.write(ch);
                    continue block8;
                }
                case '\r': {
                    out.write('\\');
                    out.write('r');
                    continue block8;
                }
                case '\n': {
                    out.write('\\');
                    out.write('n');
                    continue block8;
                }
                case '\t': {
                    out.write('\\');
                    out.write('t');
                    continue block8;
                }
                case '\b': {
                    out.write('\\');
                    out.write('b');
                    continue block8;
                }
                case '\f': {
                    out.write('\\');
                    out.write('f');
                    continue block8;
                }
                default: {
                    if (ch <= '\u001f') {
                        JSONUtil.unicodeEscape(ch, out);
                        continue block8;
                    }
                    if (ch == '\u2028' || ch == '\u2029') {
                        JSONUtil.unicodeEscape(ch, out);
                        continue block8;
                    }
                    out.write(ch);
                }
            }
        }
    }

    public static void unicodeEscape(int ch, CharArr out) {
        out.write('\\');
        out.write('u');
        out.write(HEX_CHARS[ch >>> 12]);
        out.write(HEX_CHARS[ch >>> 8 & 0xF]);
        out.write(HEX_CHARS[ch >>> 4 & 0xF]);
        out.write(HEX_CHARS[ch & 0xF]);
    }

    public static void writeNull(CharArr out) {
        out.write(NULL_CHARS);
    }

    public static void writeBoolean(boolean val, CharArr out) {
        out.write(val ? TRUE_CHARS : FALSE_CHARS);
    }
}

