/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AclServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.Axis2PortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.CXFPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.DiscoveryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.MultiFilingServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.NavigationServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.ObjectServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PolicyServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RelationshipServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.SunJREPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.SunRIPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.VersioningServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.WebSpherePortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisWebServicesSpi
implements CmisSpi {
    public static final String JAXWS_IMPL_RI = "sunri";
    public static final String JAXWS_IMPL_JRE = "sunjre";
    public static final String JAXWS_IMPL_CXF = "cxf";
    public static final String JAXWS_IMPL_WEBSPHERE = "websphere";
    public static final String JAXWS_IMPL_AXIS2 = "axis2";
    private static final Logger LOG = LoggerFactory.getLogger(CmisWebServicesSpi.class);
    private final RepositoryService repositoryService;
    private final NavigationService navigationService;
    private final ObjectService objectService;
    private final VersioningService versioningService;
    private final DiscoveryService discoveryService;
    private final MultiFilingService multiFilingService;
    private final RelationshipService relationshipService;
    private final PolicyService policyService;
    private final AclService aclService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmisWebServicesSpi(BindingSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {}: Initializing Web Services SPI...", (Object)session.getSessionId());
        }
        AbstractPortProvider portProvider = null;
        String portProviderClass = (String)session.get("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname");
        if (portProviderClass == null) {
            String jaxwsImpl = (String)session.get("org.apache.chemistry.opencmis.binding.webservices.jaxws.impl");
            if (jaxwsImpl == null) {
                jaxwsImpl = System.getProperty("org.apache.chemistry.opencmis.binding.webservices.jaxws.impl");
            }
            if (jaxwsImpl == null || JAXWS_IMPL_RI.equals(jaxwsImpl)) {
                portProvider = new SunRIPortProvider();
            } else if (JAXWS_IMPL_JRE.equals(jaxwsImpl)) {
                portProvider = new SunJREPortProvider();
            } else if (JAXWS_IMPL_CXF.equals(jaxwsImpl)) {
                portProvider = new CXFPortProvider();
            } else if (JAXWS_IMPL_WEBSPHERE.equals(jaxwsImpl)) {
                portProvider = new WebSpherePortProvider();
            } else {
                if (!JAXWS_IMPL_AXIS2.equals(jaxwsImpl)) throw new CmisRuntimeException("Unknown JAX-WS implementation specified!");
                portProvider = new Axis2PortProvider();
            }
        } else {
            Object portProviderObj = null;
            try {
                portProviderObj = ClassLoaderUtil.loadClass((String)portProviderClass).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not load port provider: " + e, e);
            }
            if (!(portProviderObj instanceof AbstractPortProvider)) {
                throw new IllegalArgumentException("Port provider does not implement AbstractPortProvider!");
            }
            portProvider = portProviderObj;
        }
        portProvider.setSession(session);
        this.repositoryService = new RepositoryServiceImpl(session, portProvider);
        this.navigationService = new NavigationServiceImpl(session, portProvider);
        this.objectService = new ObjectServiceImpl(session, portProvider);
        this.versioningService = new VersioningServiceImpl(session, portProvider);
        this.discoveryService = new DiscoveryServiceImpl(session, portProvider);
        this.multiFilingService = new MultiFilingServiceImpl(session, portProvider);
        this.relationshipService = new RelationshipServiceImpl(session, portProvider);
        this.policyService = new PolicyServiceImpl(session, portProvider);
        this.aclService = new AclServiceImpl(session, portProvider);
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    public ObjectService getObjectService() {
        return this.objectService;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public MultiFilingService getMultiFilingService() {
        return this.multiFilingService;
    }

    public RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public PolicyService getPolicyService() {
        return this.policyService;
    }

    public AclService getAclService() {
        return this.aclService;
    }

    public void clearAllCaches() {
    }

    public void clearRepositoryCache(String repositoryId) {
    }

    public void close() {
    }
}

