/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Comparator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;

class InternalOrder
extends Histogram.Order {
    final byte id;
    final String key;
    final boolean asc;
    final Comparator<InternalHistogram.Bucket> comparator;

    InternalOrder(byte id, String key, boolean asc, Comparator<InternalHistogram.Bucket> comparator) {
        this.id = id;
        this.key = key;
        this.asc = asc;
        this.comparator = comparator;
    }

    byte id() {
        return this.id;
    }

    String key() {
        return this.key;
    }

    boolean asc() {
        return this.asc;
    }

    @Override
    Comparator<InternalHistogram.Bucket> comparator() {
        return this.comparator;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(this.key, this.asc ? "asc" : "desc").endObject();
    }

    static class Streams {
        Streams() {
        }

        public static void writeOrder(InternalOrder order, StreamOutput out) throws IOException {
            out.writeByte(order.id());
            if (order instanceof Aggregation) {
                out.writeBoolean(order.asc());
                out.writeString(order.key());
            }
        }

        public static InternalOrder readOrder(StreamInput in) throws IOException {
            byte id = in.readByte();
            switch (id) {
                case 1: {
                    return (InternalOrder)Histogram.Order.KEY_ASC;
                }
                case 2: {
                    return (InternalOrder)Histogram.Order.KEY_DESC;
                }
                case 3: {
                    return (InternalOrder)Histogram.Order.COUNT_ASC;
                }
                case 4: {
                    return (InternalOrder)Histogram.Order.COUNT_DESC;
                }
                case 0: {
                    boolean asc = in.readBoolean();
                    String key = in.readString();
                    return new Aggregation(key, asc);
                }
            }
            throw new RuntimeException("unknown histogram order");
        }
    }

    static class Aggregation
    extends InternalOrder {
        static final byte ID = 0;

        Aggregation(String key, boolean asc) {
            super((byte)0, key, asc, new MultiBucketsAggregation.Bucket.SubAggregationComparator<InternalHistogram.Bucket>(key, asc));
        }

        Aggregation(String aggName, String valueName, boolean asc) {
            super((byte)0, Aggregation.key(aggName, valueName), asc, new MultiBucketsAggregation.Bucket.SubAggregationComparator<InternalHistogram.Bucket>(aggName, valueName, asc));
        }

        private static String key(String aggName, String valueName) {
            return valueName == null ? aggName : aggName + "." + valueName;
        }
    }
}

