/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.units.DateUnit;

public class StationFeatureCopyFactory {
    private static final int POINTER_SIZE = 8;
    private static final int OBJECT_SIZE = 40;
    private static final int ARRAY_SIZE = 8;
    private final Map<String, StationFeatureImpl> stationMap;
    private final StructureMembers sm;
    private final DateUnit du;
    private final int sizeInBytes;

    public StationFeatureCopyFactory(StationPointFeature proto, DateUnit du) throws IOException {
        this.du = du;
        this.stationMap = new HashMap<String, StationFeatureImpl>();
        StructureData sdata = proto.getDataAll();
        this.sm = new StructureMembers(sdata.getStructureMembers());
        this.sizeInBytes = 364 + this.sm.getStructureSize();
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public StationPointFeature deepCopy(StationPointFeature from) throws IOException {
        StationFeature s = from.getStation();
        StationFeatureImpl sUse = this.stationMap.get(s.getName());
        if (sUse == null) {
            sUse = new StationFeatureImpl(s);
            this.stationMap.put(s.getName(), sUse);
        }
        sUse.incrNobs();
        StationPointFeatureCopy deep = new StationPointFeatureCopy(sUse, from);
        deep.data = StructureDataDeep.copy(from.getFeatureData(), this.sm);
        return deep;
    }

    private class StationPointFeatureCopy
    extends PointFeatureImpl
    implements StationPointFeature {
        final StationFeature station;
        StructureData data;

        StationPointFeatureCopy(StationFeature station, PointFeature pf) {
            super(station, pf.getObservationTime(), pf.getNominalTime(), StationFeatureCopyFactory.this.du);
            this.station = station;
        }

        @Override
        public StructureData getDataAll() throws IOException {
            return this.data;
        }

        @Override
        public StructureData getFeatureData() throws IOException {
            return this.data;
        }

        @Override
        public StationFeature getStation() {
            return this.station;
        }
    }
}

