/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.geoloc.vertical.VerticalTransformSubset;
import ucar.unidata.util.Parameter;

public abstract class VerticalTransformImpl
implements VerticalTransform {
    protected String units;
    private Dimension timeDim;

    public VerticalTransformImpl(Dimension timeDim) {
        this.timeDim = timeDim;
    }

    @Override
    public abstract ArrayDouble.D3 getCoordinateArray(int var1) throws IOException, InvalidRangeException;

    @Override
    public abstract ArrayDouble.D1 getCoordinateArray1D(int var1, int var2, int var3) throws IOException, InvalidRangeException;

    @Override
    public String getUnitString() {
        return this.units;
    }

    @Override
    public boolean isTimeDependent() {
        return this.timeDim != null;
    }

    protected Dimension getTimeDimension() {
        return this.timeDim;
    }

    protected Array readArray(Variable v, int timeIndex) throws IOException, InvalidRangeException {
        int dimIndex;
        int[] shape = v.getShape();
        int[] origin = new int[v.getRank()];
        if (this.getTimeDimension() != null && (dimIndex = v.findDimensionIndex(this.getTimeDimension().getShortName())) >= 0) {
            shape[dimIndex] = 1;
            origin[dimIndex] = timeIndex;
            return v.read(origin, shape).reduce(dimIndex);
        }
        return v.read(origin, shape);
    }

    @Override
    public VerticalTransform subset(Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        return new VerticalTransformSubset(this, t_range, z_range, y_range, x_range);
    }

    protected String getParameterStringValue(List<Parameter> params, String name) {
        for (Parameter a : params) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a.getStringValue();
        }
        return null;
    }

    protected boolean getParameterBooleanValue(List<Parameter> params, String name) {
        for (Parameter p : params) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            return Boolean.valueOf(p.getStringValue());
        }
        return false;
    }
}

