/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;

public class ObjectService {
    private static final int BUFFER_SIZE = 65536;

    public static class MoveObject
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String targetFolderId = this.getStringParameter(request, "targetFolderId");
            String sourceFolderId = this.getStringParameter(request, "sourceFolderId");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            Holder objectIdHolder = new Holder((Object)objectId);
            if (this.stopBeforeService(service)) {
                return;
            }
            service.moveObject(repositoryId, objectIdHolder, targetFolderId, sourceFolderId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            this.setStatus(request, response, 201);
            response.setHeader("Location", this.compileObjectLocationUrl(request, repositoryId, newObjectId));
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class AppendContentStream
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            boolean isLastChunk = this.getBooleanParameter(request, "isLastChunk", false);
            String changeToken = this.getStringParameter(request, "changeToken");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            Holder objectIdHolder = new Holder((Object)objectId);
            Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
            ContentStream contentStream = this.createContentStream(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            service.appendContentStream(repositoryId, objectIdHolder, changeTokenHolder, contentStream, isLastChunk, null);
            if (this.stopAfterService(service)) {
                return;
            }
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            this.setStatus(request, response, 201);
            response.setHeader("Location", this.compileObjectLocationUrl(request, repositoryId, newObjectId));
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class SetContentStream
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String changeToken = this.getStringParameter(request, "changeToken");
            Boolean overwriteFlag = this.getBooleanParameter(request, "overwriteFlag");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            Holder objectIdHolder = new Holder((Object)objectId);
            Holder changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
            ContentStream contentStream = this.createContentStream(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            service.setContentStream(repositoryId, objectIdHolder, overwriteFlag, changeTokenHolder, contentStream, null);
            if (this.stopAfterService(service)) {
                return;
            }
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            this.setStatus(request, response, 201);
            response.setHeader("Location", this.compileObjectLocationUrl(request, repositoryId, newObjectId));
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class DeleteContentStream
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            Holder changeTokenHolder;
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String changeToken = this.getStringParameter(request, "changeToken");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            Holder objectIdHolder = new Holder((Object)objectId);
            Holder holder = changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteContentStream(repositoryId, objectIdHolder, changeTokenHolder, null);
            if (this.stopAfterService(service)) {
                return;
            }
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            response.setStatus(200);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class DeleteTree
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            Boolean allVersions = this.getBooleanParameter(request, "allVersions");
            UnfileObject unfileObjects = this.getEnumParameter(request, "unfileObjects", UnfileObject.class);
            Boolean continueOnFailure = this.getBooleanParameter(request, "continueOnFailure");
            if (this.stopBeforeService(service)) {
                return;
            }
            FailedToDeleteData ftd = service.deleteTree(repositoryId, objectId, allVersions, unfileObjects, continueOnFailure, null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(200);
            if (ftd != null && CollectionsHelper.isNotEmpty((Collection)ftd.getIds())) {
                JSONObject jsonObject = JSONConverter.convert((FailedToDeleteData)ftd);
                this.writeJSON((JSONStreamAware)jsonObject, request, response);
                return;
            }
            this.writeEmpty(request, response);
        }
    }

    public static class DeleteObject
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            Boolean allVersions = this.getBooleanParameter(request, "allVersions");
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteObject(repositoryId, objectId, allVersions, null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(200);
            this.writeEmpty(request, response);
        }
    }

    public static class GetContentStream
    extends AbstractBrowserServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String streamId = this.getStringParameter(request, "streamId");
            boolean download = false;
            String downloadParam = this.getStringParameter(request, "download");
            if (downloadParam != null && downloadParam.length() > 0) {
                String downloadParamLower = downloadParam.trim().toLowerCase(Locale.ENGLISH);
                if ("attachment".equals(downloadParamLower)) {
                    download = true;
                } else if ("inline".equals(downloadParamLower)) {
                    download = false;
                } else {
                    throw new CmisInvalidArgumentException("Invalid download parameter value!");
                }
            }
            BigInteger offset = context.getOffset();
            BigInteger length = context.getLength();
            if (this.stopBeforeService(service)) {
                return;
            }
            ContentStream content = service.getContentStream(repositoryId, objectId, streamId, offset, length, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (content == null || content.getStream() == null) {
                throw new CmisRuntimeException("Content stream is null!");
            }
            if (this.sendContentStreamHeaders(content, request, response)) {
                return;
            }
            String contentType = content.getMimeType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if ((offset == null || offset.signum() == 0) && length == null) {
                response.setStatus(200);
            } else {
                this.setStatus(request, response, 206);
                if (content.getBigLength() != null && content.getBigLength().signum() == 1) {
                    BigInteger firstBytePos = offset == null ? BigInteger.ZERO : offset;
                    BigInteger lastBytePos = firstBytePos.add(content.getBigLength().subtract(BigInteger.ONE));
                    response.setHeader("Content-Range", "bytes " + firstBytePos.toString() + "-" + lastBytePos.toString() + "/*");
                }
            }
            response.setContentType(contentType);
            String contentFilename = content.getFileName();
            if (contentFilename == null) {
                contentFilename = "content";
            }
            if (download) {
                response.setHeader("Content-Disposition", MimeHelper.encodeContentDisposition((String)"attachment", (String)contentFilename));
            } else {
                response.setHeader("Content-Disposition", MimeHelper.encodeContentDisposition((String)"inline", (String)contentFilename));
            }
            InputStream in = content.getStream();
            ServletOutputStream out = response.getOutputStream();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out, (int)65536);
                out.flush();
            }
            finally {
                IOUtils.closeQuietly((Closeable)in);
            }
        }
    }

    public static class GetRenditions
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            if (this.stopBeforeService(service)) {
                return;
            }
            List renditions = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONArray jsonRenditions = new JSONArray();
            if (renditions != null) {
                for (RenditionData rendition : renditions) {
                    jsonRenditions.add((Object)JSONConverter.convert((RenditionData)rendition));
                }
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonRenditions, request, response);
        }
    }

    public static class GetAllowableActions
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            if (this.stopBeforeService(service)) {
                return;
            }
            AllowableActions allowableActions = service.getAllowableActions(repositoryId, objectId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONObject jsonAllowableActions = JSONConverter.convert((AllowableActions)allowableActions);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonAllowableActions, request, response);
        }
    }

    public static class GetObject
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            ReturnVersion returnVersion = this.getEnumParameter(request, "returnVersion", ReturnVersion.class);
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePolicyIds = this.getBooleanParameter(request, "includePolicyIds");
            Boolean includeAcl = this.getBooleanParameter(request, "includeACL");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectData object = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getObjectOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null) : service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class GetProperties
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            ReturnVersion returnVersion = this.getEnumParameter(request, "returnVersion", ReturnVersion.class);
            String filter = this.getStringParameter(request, "filter");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            Properties properties = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getPropertiesOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, null) : service.getProperties(repositoryId, objectId, filter, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (properties == null) {
                throw new CmisRuntimeException("Properties are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((Properties)properties, (String)objectId, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class BulkUpdateProperties
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            ControlParser cp = new ControlParser(request);
            ArrayList<BulkUpdateObjectIdAndChangeTokenImpl> objectIdAndChangeToken = new ArrayList<BulkUpdateObjectIdAndChangeTokenImpl>();
            List<String> objectIds = cp.getValues("objectId");
            List<String> changeTokens = cp.getValues("changeToken");
            if (CollectionsHelper.isNullOrEmpty(objectIds)) {
                throw new CmisInvalidArgumentException("No object ids provided!");
            }
            int n = objectIds.size();
            for (int i = 0; i < n; ++i) {
                String changeToken;
                String id = objectIds.get(i);
                String string = changeToken = changeTokens != null && changeTokens.size() > i ? changeTokens.get(i) : null;
                if (changeToken != null && changeToken.length() == 0) {
                    changeToken = null;
                }
                objectIdAndChangeToken.add(new BulkUpdateObjectIdAndChangeTokenImpl(id, changeToken));
            }
            List<String> addSecondaryTypes = cp.getValues("addSecondaryTypeId");
            List<String> removeSecondaryTypes = cp.getValues("removeSecondaryTypeId");
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            Properties properties = this.createUpdateProperties(cp, null, addSecondaryTypes, objectIds, typeCache);
            if (this.stopBeforeService(service)) {
                return;
            }
            List result = service.bulkUpdateProperties(repositoryId, objectIdAndChangeToken, properties, addSecondaryTypes, removeSecondaryTypes, null);
            if (this.stopAfterService(service)) {
                return;
            }
            JSONArray jsonList = new JSONArray();
            if (result != null) {
                for (BulkUpdateObjectIdAndChangeToken oc : result) {
                    if (oc == null) continue;
                    jsonList.add((Object)JSONConverter.convert((BulkUpdateObjectIdAndChangeToken)oc));
                }
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonList, request, response);
        }
    }

    public static class UpdateProperties
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            Holder changeTokenHolder;
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String typeId = ((BrowserCallContextImpl)context).getTypeId();
            String changeToken = this.getStringParameter(request, "changeToken");
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            Holder objectIdHolder = new Holder((Object)objectId);
            Holder holder = changeTokenHolder = changeToken == null ? null : new Holder((Object)changeToken);
            if (this.stopBeforeService(service)) {
                return;
            }
            service.updateProperties(repositoryId, objectIdHolder, changeTokenHolder, this.createUpdateProperties(cp, typeId, null, Collections.singletonList(objectId), typeCache), null);
            if (this.stopAfterService(service)) {
                return;
            }
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            int status = 200;
            if (!objectId.equals(newObjectId)) {
                status = 201;
            }
            this.setStatus(request, response, status);
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(status, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class CreateRelationship
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            if (this.stopBeforeService(service)) {
                return;
            }
            String newObjectId = service.createRelationship(repositoryId, this.createNewProperties(cp, typeCache), this.createPolicies(cp), this.createAddAcl(cp), this.createRemoveAcl(cp), null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("New relationship is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class CreateItem
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            if (this.stopBeforeService(service)) {
                return;
            }
            String newObjectId = service.createItem(repositoryId, this.createNewProperties(cp, typeCache), folderId, this.createPolicies(cp), this.createAddAcl(cp), this.createRemoveAcl(cp), null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("New item is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class CreatePolicy
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            if (this.stopBeforeService(service)) {
                return;
            }
            String newObjectId = service.createPolicy(repositoryId, this.createNewProperties(cp, typeCache), folderId, this.createPolicies(cp), this.createAddAcl(cp), this.createRemoveAcl(cp), null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("New policy is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class CreateFolder
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            if (this.stopBeforeService(service)) {
                return;
            }
            String newObjectId = service.createFolder(repositoryId, this.createNewProperties(cp, typeCache), folderId, this.createPolicies(cp), this.createAddAcl(cp), this.createRemoveAcl(cp), null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("New folder is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class CreateDocumentFromSource
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            String sourceId = this.getStringParameter(request, "sourceId");
            VersioningState versioningState = this.getEnumParameter(request, "versioningState", VersioningState.class);
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            ObjectData sourceDoc = this.getSimpleObject(service, repositoryId, sourceId);
            PropertyData sourceTypeId = (PropertyData)sourceDoc.getProperties().getProperties().get("cmis:objectTypeId");
            if (sourceTypeId == null || sourceTypeId.getFirstValue() == null) {
                throw new CmisRuntimeException("Source object has no type!?!");
            }
            if (this.stopBeforeService(service)) {
                return;
            }
            String newObjectId = service.createDocumentFromSource(repositoryId, sourceId, this.createUpdateProperties(cp, sourceTypeId.getFirstValue().toString(), null, Collections.singletonList(sourceId), typeCache), folderId, versioningState, this.createPolicies(cp), this.createAddAcl(cp), this.createRemoveAcl(cp), null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("New document is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class CreateDocument
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            VersioningState versioningState = this.getEnumParameter(request, "versioningState", VersioningState.class);
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            ContentStream contentStream = this.createContentStream(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            String newObjectId = service.createDocument(repositoryId, this.createNewProperties(cp, typeCache), folderId, contentStream, versioningState, this.createPolicies(cp), this.createAddAcl(cp), this.createRemoveAcl(cp), null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("New document is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }
}

