/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.core.database.ConnectionFactory;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class DBInterfaceHSQLDB
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfaceHSQLDB.java 1549105 2013-12-08 18:54:09Z kwright $";
    private static final String _localUrl = "jdbc:hsqldb:file:";
    private static final String _remoteUrl = "jdbc:hsqldb:";
    private static final String _driver = "org.hsqldb.jdbcDriver";
    private static Map<String, String> legalProtocolValues = new HashMap<String, String>();
    public static final String databasePathProperty = "org.apache.manifoldcf.hsqldbdatabasepath";
    public static final String databaseProtocolProperty = "org.apache.manifoldcf.hsqldbdatabaseprotocol";
    public static final String databaseServerProperty = "org.apache.manifoldcf.hsqldbdatabaseserver";
    public static final String databasePortProperty = "org.apache.manifoldcf.hsqldbdatabaseport";
    public static final String databaseInstanceProperty = "org.apache.manifoldcf.hsqldbdatabaseinstance";
    protected String cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
    protected int serializableDepth = 0;
    protected boolean isRemote;
    protected String schemaNameForQueries;
    protected int depthCount = 0;
    protected boolean inTransaction = false;
    protected int desiredTransactionType = 2;

    public DBInterfaceHSQLDB(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, DBInterfaceHSQLDB.getJDBCString(tc, databaseName), _driver, DBInterfaceHSQLDB.getDatabaseString(tc, databaseName), userName, password);
        this.isRemote = LockManagerFactory.getProperty(tc, databaseProtocolProperty) != null;
        this.userName = userName;
        this.password = password;
        this.schemaNameForQueries = this.isRemote ? databaseName : "PUBLIC";
    }

    protected static String getJDBCString(IThreadContext tc, String databaseName) throws ManifoldCFException {
        String instanceName;
        String protocol = LockManagerFactory.getProperty(tc, databaseProtocolProperty);
        if (protocol == null) {
            return _localUrl + DBInterfaceHSQLDB.getFullDatabasePath(databaseName);
        }
        if (legalProtocolValues.get(protocol) == null) {
            throw new ManifoldCFException("The value of the 'org.apache.manifoldcf.hsqldbdatabaseprotocol' property was illegal; try hsql, http, or https");
        }
        Object server = LockManagerFactory.getProperty(tc, databaseServerProperty);
        if (server == null) {
            throw new ManifoldCFException("HSQLDB remote mode requires 'org.apache.manifoldcf.hsqldbdatabaseserver' property, containing a server name or IP address");
        }
        String port = LockManagerFactory.getProperty(tc, databasePortProperty);
        if (port != null && port.length() > 0) {
            server = (String)server + ":" + port;
        }
        if ((instanceName = LockManagerFactory.getProperty(tc, databaseInstanceProperty)) != null && instanceName.length() > 0) {
            server = (String)server + "/" + instanceName;
        }
        return _remoteUrl + protocol + "://" + (String)server;
    }

    protected static String getDatabaseString(IThreadContext tc, String databaseName) throws ManifoldCFException {
        String protocol = LockManagerFactory.getProperty(tc, databaseProtocolProperty);
        if (protocol == null) {
            return DBInterfaceHSQLDB.getFullDatabasePath(databaseName);
        }
        return databaseName;
    }

    protected static String getFullDatabasePath(String databaseName) throws ManifoldCFException {
        File path = ManifoldCF.getFileProperty(databasePathProperty);
        if (path == null) {
            throw new ManifoldCFException("HSQLDB database requires 'org.apache.manifoldcf.hsqldbdatabasepath' property, containing a relative path");
        }
        Object pathString = path.toString().replace("\\\\", "/");
        if (!((String)pathString).endsWith("/")) {
            pathString = (String)pathString + "/";
        }
        return (String)pathString + databaseName;
    }

    @Override
    protected void initializeConnection(Connection connection) throws ManifoldCFException {
        super.initializeConnection(connection);
        this.executeViaThread(connection, "SET SCHEMA " + this.schemaNameForQueries.toUpperCase(Locale.ROOT), null, false, -1, null, null);
    }

    @Override
    public void openDatabase() throws ManifoldCFException {
    }

    @Override
    public void closeDatabase() throws ManifoldCFException {
        if (!this.isRemote) {
            try {
                Class.forName(_driver).newInstance();
            }
            catch (Exception e) {
                throw new ManifoldCFException(e.getMessage(), e);
            }
            try {
                Connection c = DriverManager.getConnection(_localUrl + this.databaseName, this.userName, this.password);
                Statement s = c.createStatement();
                s.execute("SHUTDOWN");
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void performInsert(String tableName, Map<String, Object> parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuilder values = new StringBuilder(" VALUES (");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append((CharSequence)values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performUpdate(String tableName, Map<String, Object> parameterMap, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performDelete(String tableName, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuilder bf = new StringBuilder();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    @Override
    public void performCreate(String tableName, Map<String, ColumnDescription> columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuilder queryBuffer = new StringBuilder("CREATE CACHED TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator<String> iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = iter.next();
            ColumnDescription cd = columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            DBInterfaceHSQLDB.appendDescription(queryBuffer, columnName, cd, false);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    protected static void appendDescription(StringBuilder queryBuffer, String columnName, ColumnDescription cd, boolean forceNull) {
        queryBuffer.append(columnName);
        queryBuffer.append(' ');
        queryBuffer.append(DBInterfaceHSQLDB.mapType(cd.getTypeString()));
        if (forceNull || cd.getIsNull()) {
            queryBuffer.append(" NULL");
        } else {
            queryBuffer.append(" NOT NULL");
        }
        if (cd.getIsPrimaryKey()) {
            queryBuffer.append(" PRIMARY KEY");
        }
        if (cd.getReferenceTable() != null) {
            queryBuffer.append(" REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
            } else {
                queryBuffer.append(" RESTRICT");
            }
        }
    }

    @Override
    public void performAlter(String tableName, Map<String, ColumnDescription> columnMap, Map<String, ColumnDescription> columnModifyMap, List<String> columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
        this.beginTransaction(0);
        try {
            if (columnDeleteList != null) {
                int i = 0;
                while (i < columnDeleteList.size()) {
                    String columnName = columnDeleteList.get(i++);
                    this.performModification("ALTER TABLE " + tableName + " DROP " + columnName, null, invalidateKeys);
                }
            }
            if (columnModifyMap != null) {
                for (String columnName : columnModifyMap.keySet()) {
                    ColumnDescription cd = columnModifyMap.get(columnName);
                    StringBuilder sb = new StringBuilder();
                    DBInterfaceHSQLDB.appendDescription(sb, columnName, cd, false);
                    this.performModification("ALTER TABLE " + tableName + " ALTER COLUMN " + sb.toString(), null, invalidateKeys);
                }
            }
            if (columnMap != null) {
                for (String columnName : columnMap.keySet()) {
                    ColumnDescription cd = columnMap.get(columnName);
                    StringBuilder sb = new StringBuilder();
                    DBInterfaceHSQLDB.appendDescription(sb, columnName, cd, false);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected static String mapType(String inputType) {
        if (inputType.equalsIgnoreCase("longtext")) {
            return "longvarchar";
        }
        return inputType;
    }

    @Override
    public void addTableIndex(String tableName, boolean unique, List<String> columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    @Override
    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuilder queryBuffer = new StringBuilder("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append((String)indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    @Override
    public void performRemoveIndex(String indexName, String tableName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName, null, null);
    }

    @Override
    public void analyzeTable(String tableName) throws ManifoldCFException {
    }

    @Override
    public void reindexTable(String tableName) throws ManifoldCFException {
    }

    @Override
    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    @Override
    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        if (this.isRemote) {
            DBInterfaceHSQLDB masterDatabase = new DBInterfaceHSQLDB(this.context, "PUBLIC", adminUserName, adminPassword);
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.userName);
            IResultSet userResult = masterDatabase.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SYSTEM_USERS WHERE USER_NAME=?", params, null, null, null, true, -1, null, null);
            if (userResult.getRowCount() == 0) {
                masterDatabase.executeQuery("CREATE USER " + DBInterfaceHSQLDB.quoteString(this.userName) + " PASSWORD " + DBInterfaceHSQLDB.quoteString(this.password), null, null, invalidateKeys, null, false, 0, null, null);
            }
            params.clear();
            params.add(this.databaseName.toUpperCase(Locale.ROOT));
            IResultSet schemaResult = masterDatabase.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SYSTEM_SCHEMAS WHERE TABLE_SCHEM=?", params, null, null, null, true, -1, null, null);
            if (schemaResult.getRowCount() == 0) {
                masterDatabase.executeQuery("CREATE SCHEMA " + this.databaseName.toUpperCase(Locale.ROOT) + " AUTHORIZATION " + DBInterfaceHSQLDB.quoteString(this.userName), null, null, invalidateKeys, null, false, 0, null, null);
            }
        } else {
            try {
                Class.forName(_driver).newInstance();
                DriverManager.getConnection(_localUrl + this.databaseName, this.userName, this.password).close();
            }
            catch (Exception e) {
                throw new ManifoldCFException(e.getMessage(), e, 3);
            }
            this.performModification("SET DATABASE TRANSACTION CONTROL MVCC", null, null);
            this.performModification("SET FILES SCALE 512", null, null);
        }
    }

    private static String quoteString(String password) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (int i = 0; i < password.length(); ++i) {
            char x = password.charAt(i);
            if (x == '\"') {
                sb.append("\"");
            }
            sb.append(x);
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        if (this.isRemote) {
            DBInterfaceHSQLDB masterDatabase = new DBInterfaceHSQLDB(this.context, "PUBLIC", adminUserName, adminPassword);
            try {
                masterDatabase.executeQuery("DROP SCHEMA " + this.databaseName, null, null, invalidateKeys, null, false, 0, null, null);
                masterDatabase.executeQuery("DROP USER " + DBInterfaceHSQLDB.quoteString(this.userName), null, null, invalidateKeys, null, false, 0, null, null);
            }
            catch (ManifoldCFException e) {
                throw this.reinterpretException(e);
            }
        } else {
            File f = new File(this.databaseName + ".properties");
            if (f.exists()) {
                ConnectionFactory.releaseAll();
                this.closeDatabase();
                DBInterfaceHSQLDB.singleDelete(f);
                DBInterfaceHSQLDB.singleDelete(new File(this.databaseName + ".data"));
                DBInterfaceHSQLDB.singleDelete(new File(this.databaseName + ".lck"));
                DBInterfaceHSQLDB.singleDelete(new File(this.databaseName + ".log"));
                DBInterfaceHSQLDB.singleDelete(new File(this.databaseName + ".script"));
                DBInterfaceHSQLDB.recursiveDelete(new File(this.databaseName + ".tmp"));
            }
        }
    }

    protected static void recursiveDelete(File f) {
        if (f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    File newf;
                    if ((newf = files[i++]).isDirectory()) {
                        DBInterfaceHSQLDB.recursiveDelete(newf);
                        continue;
                    }
                    DBInterfaceHSQLDB.singleDelete(newf);
                }
            }
            if (!f.delete()) {
                System.out.println("Failed to delete directory " + f.toString());
            }
        }
    }

    protected static void singleDelete(File f) {
        if (f.exists() && !f.delete()) {
            System.out.println("Failed to delete file " + f.toString());
        }
    }

    protected ManifoldCFException reinterpretException(ManifoldCFException theException) {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Reinterpreting exception '" + theException.getMessage() + "'.  The exception type is " + Integer.toString(theException.getErrorCode())));
        }
        if (theException.getErrorCode() != 4) {
            return theException;
        }
        Throwable e = theException.getCause();
        if (!(e instanceof SQLException)) {
            return theException;
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is possibly a transaction abort signal"));
        }
        SQLException sqlException = (SQLException)e;
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        if (sqlState != null && sqlState.equals("40001")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40P01")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("23505")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is NOT a transaction abort signal"));
        }
        return theException;
    }

    @Override
    public void performModification(String query, List params, StringSet invalidateKeys) throws ManifoldCFException {
        try {
            this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public Map<String, ColumnDescription> getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.schemaNameForQueries.toUpperCase(Locale.ROOT));
        list.add(tableName.toUpperCase(Locale.ROOT));
        query.append("SELECT column_name, is_nullable, data_type, character_maximum_length ").append("FROM INFORMATION_SCHEMA.COLUMNS WHERE table_schema=? AND table_name=?");
        IResultSet set = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        if (set.getRowCount() == 0) {
            return null;
        }
        query = new StringBuilder();
        query.append("SELECT column_name ").append("FROM INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS WHERE table_schem=? AND table_name=?");
        IResultSet primarySet = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        String primaryKey = null;
        if (primarySet.getRowCount() != 0) {
            primaryKey = ((String)primarySet.getRow(0).getValue("column_name")).toLowerCase(Locale.ROOT);
        }
        if (primaryKey == null) {
            primaryKey = "";
        }
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = ((String)row.getValue("column_name")).toLowerCase(Locale.ROOT);
            String type = (String)row.getValue("data_type");
            Long width = (Long)row.getValue("character_maximum_length");
            String isNullable = (String)row.getValue("is_nullable");
            boolean isPrimaryKey = primaryKey.equals(fieldName);
            boolean isNull = isNullable.equals("YES");
            Object dataType = type.equals("CHARACTER VARYING") ? "VARCHAR(" + width.toString() + ")" : (type.equals("CLOB") ? "LONGVARCHAR" : type);
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    @Override
    public Map<String, IndexDescription> getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        HashMap<String, IndexDescription> rval = new HashMap<String, IndexDescription>();
        String query = "SELECT index_name,column_name,non_unique,ordinal_position FROM INFORMATION_SCHEMA.SYSTEM_INDEXINFO WHERE table_schem=? AND TABLE_NAME=? ORDER BY index_name,ordinal_position ASC";
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.schemaNameForQueries.toUpperCase(Locale.ROOT));
        list.add(tableName.toUpperCase(Locale.ROOT));
        IResultSet result = this.performQuery(query, list, cacheKeys, queryClass);
        String lastIndexName = null;
        ArrayList<String> indexColumns = null;
        boolean isUnique = false;
        int i = 0;
        while (i < result.getRowCount()) {
            IResultRow row = result.getRow(i++);
            String indexName = ((String)row.getValue("index_name")).toLowerCase(Locale.ROOT);
            String columnName = ((String)row.getValue("column_name")).toLowerCase(Locale.ROOT);
            String nonUnique = row.getValue("non_unique").toString();
            if (lastIndexName != null && !lastIndexName.equals(indexName)) {
                this.addIndex(rval, lastIndexName, isUnique, indexColumns);
                lastIndexName = null;
                indexColumns = null;
                isUnique = false;
            }
            if (lastIndexName == null) {
                lastIndexName = indexName;
                indexColumns = new ArrayList<String>();
                isUnique = false;
            }
            indexColumns.add(columnName);
            isUnique = nonUnique.equals("false");
        }
        if (lastIndexName != null) {
            this.addIndex(rval, lastIndexName, isUnique, indexColumns);
        }
        return rval;
    }

    protected void addIndex(Map rval, String indexName, boolean isUnique, List<String> indexColumns) {
        if (indexName.indexOf("sys_idx") != -1) {
            return;
        }
        String[] columnNames = new String[indexColumns.size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = indexColumns.get(i);
        }
        rval.put(indexName, new IndexDescription(isUnique, columnNames));
    }

    @Override
    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.schemaNameForQueries.toUpperCase(Locale.ROOT));
        IResultSet set = this.performQuery("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema=?", list, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "table_name";
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public String constructIndexOrderByClause(String[] fieldNames, boolean direction) {
        if (fieldNames.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("ORDER BY ");
        for (int i = 0; i < fieldNames.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(fieldNames[i]);
            if (direction) {
                sb.append(" ASC");
                continue;
            }
            sb.append(" DESC");
        }
        return sb.toString();
    }

    @Override
    public String constructDoubleCastClause(String value) {
        return "CAST(" + value + " AS DOUBLE PRECISION)";
    }

    @Override
    public String constructCountClause(String column) {
        return "CAST(COUNT(" + column + ") AS bigint)";
    }

    @Override
    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        return "REGEXP_MATCHES(CAST(" + column + " AS VARCHAR(4096))," + regularExpression + ")";
    }

    @Override
    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        return "REGEXP_SUBSTRING(CAST(" + column + " AS VARCHAR(4096))," + regularExpression + ")";
    }

    @Override
    public String constructOffsetLimitClause(int offset, int limit, boolean afterOrderBy) {
        StringBuilder sb = new StringBuilder();
        if (offset != 0) {
            sb.append("OFFSET ").append(Integer.toString(offset));
        }
        if (limit != -1) {
            if (offset != 0) {
                sb.append(" ");
            }
            sb.append("LIMIT ").append(Integer.toString(limit));
            if (afterOrderBy) {
                sb.append(" USING INDEX");
            }
        }
        return sb.toString();
    }

    @Override
    public String constructDistinctOnClause(List outputParameters, String baseQuery, List baseParameters, String[] distinctFields, String[] orderFields, boolean[] orderFieldsAscending, Map<String, String> otherFields) {
        String distinctField;
        int i;
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuilder sb = new StringBuilder("WITH txxx1 (");
        boolean needComma = false;
        for (String fieldName : otherFields.keySet()) {
            if (needComma) {
                sb.append(",");
            }
            sb.append(fieldName);
            needComma = true;
        }
        sb.append(") AS (SELECT ");
        needComma = false;
        for (String fieldName : otherFields.keySet()) {
            String columnValue = otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx2.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx2)");
        sb.append(" SELECT * FROM (SELECT DISTINCT ");
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        for (i = 0; i < distinctFields.length; ++i) {
            distinctField = distinctFields[i];
            if (i > 0) {
                sb.append(",");
            }
            sb.append(distinctField);
            distinctMap.put(distinctField, distinctField);
        }
        sb.append(" FROM txxx1) AS txxx3, LATERAL (SELECT ");
        Iterator<String> iter = otherFields.keySet().iterator();
        needComma = false;
        while (iter.hasNext()) {
            String fieldName = iter.next();
            if (distinctMap.get(fieldName) != null) continue;
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append(fieldName);
        }
        sb.append(" FROM txxx1 WHERE ");
        for (i = 0; i < distinctFields.length; ++i) {
            distinctField = distinctFields[i];
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(distinctField).append("=txxx3.").append(distinctField);
        }
        if (distinctFields.length > 0 || orderFields.length > 0) {
            sb.append(" ORDER BY ");
            int k = 0;
            for (i = 0; i < distinctFields.length; ++i) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(distinctFields[i]).append(" ASC");
                ++k;
            }
            i = 0;
            while (i < orderFields.length) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(orderFields[i]).append(" ");
                if (orderFieldsAscending[i]) {
                    sb.append("ASC");
                } else {
                    sb.append("DESC");
                }
                ++i;
                ++k;
            }
        }
        sb.append(" LIMIT 1) AS txxx4");
        return sb.toString();
    }

    @Override
    public int findConjunctionClauseMax(ClauseDescription[] otherClauseDescriptions) {
        if (otherClauseDescriptions.length == 0) {
            return super.findConjunctionClauseMax(otherClauseDescriptions);
        }
        int number = 1;
        for (int i = 0; i < otherClauseDescriptions.length; ++i) {
            ClauseDescription otherClause = otherClauseDescriptions[i];
            List values = otherClause.getValues();
            if (values == null) continue;
            number *= values.size();
        }
        int rval = this.getMaxOrClause() / number;
        if (rval == 0) {
            rval = 1;
        }
        return rval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String buildConjunctionClause(List outputParameters, ClauseDescription[] clauseDescriptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[DOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getMaxInClause() {
        return 100;
    }

    @Override
    public int getMaxOrClause() {
        return 25;
    }

    @Override
    public int getWindowedReportMaxRows() {
        return 1000;
    }

    @Override
    public void beginTransaction() throws ManifoldCFException {
        this.beginTransaction(0);
    }

    @Override
    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (this.getCurrentTransactionType() == 2) {
            ++this.serializableDepth;
            return;
        }
        if (transactionType == 0) {
            transactionType = this.getCurrentTransactionType();
        }
        switch (transactionType) {
            case 1: {
                this.desiredTransactionType = 2;
                super.beginTransaction(1);
                break;
            }
            case 2: {
                this.desiredTransactionType = 8;
                super.beginTransaction(2);
                break;
            }
            default: {
                throw new ManifoldCFException("Bad transaction type: " + Integer.toString(transactionType));
            }
        }
    }

    @Override
    public void signalRollback() {
        if (this.serializableDepth == 0) {
            super.signalRollback();
        }
    }

    @Override
    public void endTransaction() throws ManifoldCFException {
        if (this.serializableDepth > 0) {
            --this.serializableDepth;
            return;
        }
        super.endTransaction();
    }

    @Override
    protected void startATransaction() throws ManifoldCFException {
        if (!this.inTransaction) {
            try {
                this.connection.getConnection().setAutoCommit(false);
                this.connection.getConnection().setTransactionIsolation(this.desiredTransactionType);
            }
            catch (SQLException e) {
                throw new ManifoldCFException(e.getMessage(), e, 4);
            }
            this.inTransaction = true;
        }
        ++this.depthCount;
    }

    @Override
    protected void commitCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.getConnection().commit();
                        this.connection.getConnection().setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    @Override
    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.getConnection().rollback();
                        this.connection.getConnection().setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    @Override
    protected void explainQuery(String query, List params) throws ManifoldCFException {
        IResultSet x = this.executeUncachedQuery("EXPLAIN PLAN FOR " + query, null, true, -1, null, null);
        int k = 0;
        while (k < x.getRowCount()) {
            IResultRow row = x.getRow(k++);
            Iterator<String> iter = row.getColumns();
            String colName = iter.next();
            Logging.db.warn((Object)(" Plan: " + row.getValue(colName).toString()));
        }
        Logging.db.warn((Object)"");
    }

    @Override
    protected String mapLabelName(String rawLabelName) {
        return rawLabelName.toLowerCase(Locale.ROOT);
    }

    static {
        legalProtocolValues.put("hsql", "hsql");
        legalProtocolValues.put("http", "http");
        legalProtocolValues.put("https", "https");
    }
}

