/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.amazons3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.Owner;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.amazons3.Messages;
import org.apache.manifoldcf.authorities.authorities.amazons3.ResponseException;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AmazonS3Authority
extends BaseAuthorityConnector {
    private static final String TAB_NAME = "TabName";
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    protected AmazonS3 amazonS3;
    protected boolean connected = false;
    protected String amazons3ProxyHost = null;
    protected String amazons3ProxyPort = null;
    protected String amazons3ProxyDomain = null;
    protected String amazons3ProxyUserName = null;
    protected String amazons3ProxyPassword = null;
    protected String amazons3AwsAccessKey = null;
    protected String amazons3AwsSecretKey = null;

    public void disconnect() throws ManifoldCFException {
        this.amazons3AwsAccessKey = null;
        this.amazons3AwsSecretKey = null;
        this.amazons3ProxyHost = null;
        this.amazons3ProxyPort = null;
        this.amazons3ProxyDomain = null;
        this.amazons3ProxyUserName = null;
        this.amazons3ProxyPassword = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.amazons3AwsAccessKey = configParams.getParameter("aws_access_key");
        this.amazons3AwsSecretKey = configParams.getObfuscatedParameter("aws_secret_key");
        this.amazons3ProxyHost = configParams.getParameter("amazons3_proxy_host");
        this.amazons3ProxyPort = configParams.getParameter("amazons3_proxy_port");
        this.amazons3ProxyDomain = configParams.getParameter("amazons3_proxy_domain");
        this.amazons3ProxyUserName = configParams.getParameter("amazons3_proxy_username");
        this.amazons3ProxyPassword = configParams.getObfuscatedParameter("amazons3_proxy_password");
    }

    public String check() throws ManifoldCFException {
        Logging.authorityConnectors.info((Object)"Checking connection");
        try {
            CheckThread checkThread = new CheckThread(this.getClient());
            checkThread.start();
            checkThread.join();
            if (checkThread.getException() != null) {
                Throwable thr = checkThread.getException();
                return "Check exception: " + thr.getMessage();
            }
            return checkThread.getResult();
        }
        catch (InterruptedException ex) {
            Logging.authorityConnectors.error((Object)"Error while checking connection", (Throwable)ex);
            throw new ManifoldCFException(ex.getMessage(), (Throwable)ex, 2);
        }
    }

    protected AmazonS3 getClient() {
        if (this.amazonS3 == null) {
            try {
                BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.amazons3AwsAccessKey, this.amazons3AwsSecretKey);
                this.amazonS3 = new AmazonS3Client((AWSCredentials)awsCreds);
            }
            catch (Exception e) {
                Logging.authorityConnectors.error((Object)"Error while amazon s3 connectionr", (Throwable)e);
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
        return this.amazonS3;
    }

    public boolean isConnected() {
        return this.amazonS3 != null && this.amazonS3.getS3AccountOwner() != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.amazonS3 = null;
            this.lastSessionFetch = -1L;
        }
    }

    private void fillInServerConfigurationMap(Map<String, Object> out, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String amazons3AccessKey = parameters.getParameter("aws_access_key");
        String amazons3SecretKey = parameters.getObfuscatedParameter("aws_secret_key");
        if (amazons3AccessKey == null) {
            amazons3AccessKey = "";
        }
        amazons3SecretKey = amazons3SecretKey == null ? "" : mapper.mapPasswordToKey(amazons3SecretKey);
        out.put("AMAZONS3_AWS_ACCESS_KEY", amazons3AccessKey);
        out.put("AMAZONS3_AWS_SECRET_KEY", amazons3SecretKey);
    }

    private void fillInProxyConfigurationMap(Map<String, Object> out, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String amazons3ProxyHost = parameters.getParameter("amazons3_proxy_host");
        String amazons3ProxyPort = parameters.getParameter("amazons3_proxy_port");
        String amazons3ProxyDomain = parameters.getParameter("amazons3_proxy_domain");
        String amazons3ProxyUserName = parameters.getParameter("amazons3_proxy_username");
        String amazons3ProxyPassword = parameters.getObfuscatedParameter("amazons3_proxy_password");
        if (amazons3ProxyHost == null) {
            amazons3ProxyHost = "";
        }
        if (amazons3ProxyPort == null) {
            amazons3ProxyPort = "";
        }
        if (amazons3ProxyDomain == null) {
            amazons3ProxyDomain = "";
        }
        if (amazons3ProxyUserName == null) {
            amazons3ProxyUserName = "";
        }
        amazons3ProxyPassword = amazons3ProxyPassword == null ? "" : mapper.mapPasswordToKey(amazons3ProxyPassword);
        out.put("AMAZONS3_PROXY_HOST", amazons3ProxyHost);
        out.put("AMAZONS3_PROXY_PORT", amazons3ProxyPort);
        out.put("AMAZONS3_PROXY_DOMAIN", amazons3ProxyDomain);
        out.put("AMAZONS3_PROXY_USERNAME", amazons3ProxyUserName);
        out.put("AMAZONS3_PROXY_PWD", amazons3ProxyPassword);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration_amazons3.html", paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "Amazons3AuthorityConnector.Server"));
        tabsArray.add(Messages.getString(locale, "Amazons3AuthorityConnector.Proxy"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_amazons3.js", paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(TAB_NAME, tabName);
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_amazons3_server.html", paramMap);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_amazons3_proxy.html", paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String amazons3ProxyPassword;
        String amazons3ProxyUserName;
        String amazons3ProxyDomain;
        String amazons3ProxyPort;
        String awsSecretKey;
        String awsAccessKey = variableContext.getParameter("aws_access_key");
        if (awsAccessKey != null) {
            parameters.setParameter("aws_access_key", awsAccessKey);
        }
        if ((awsSecretKey = variableContext.getParameter("aws_secret_key")) != null) {
            parameters.setObfuscatedParameter("aws_secret_key", variableContext.mapKeyToPassword(awsSecretKey));
        }
        Logging.authorityConnectors.info((Object)"Saved values for aws keys");
        int i = 0;
        while (i < parameters.getChildCount()) {
            ConfigNode cn = parameters.getChild(i);
            if (cn.getType().equals("aws_access_key") || cn.getType().equals("aws_secret_key")) {
                parameters.removeChild(i);
                continue;
            }
            ++i;
        }
        String amazons3ProxyHost = variableContext.getParameter("amazons3_proxy_host");
        if (amazons3ProxyHost != null) {
            parameters.setParameter("amazons3_proxy_host", amazons3ProxyHost);
        }
        if ((amazons3ProxyPort = variableContext.getParameter("amazons3_proxy_port")) != null) {
            parameters.setParameter("amazons3_proxy_port", amazons3ProxyPort);
        }
        if ((amazons3ProxyDomain = variableContext.getParameter("amazons3_proxy_domain")) != null) {
            parameters.setParameter("amazons3_proxy_domain", amazons3ProxyDomain);
        }
        if ((amazons3ProxyUserName = variableContext.getParameter("amazons3_proxy_username")) != null) {
            parameters.setParameter("amazons3_proxy_username", amazons3ProxyUserName);
        }
        if ((amazons3ProxyPassword = variableContext.getParameter("amazons3_proxy_pwd")) != null) {
            parameters.setObfuscatedParameter("amazons3_proxy_password", variableContext.mapKeyToPassword(amazons3ProxyPassword));
        }
        return null;
    }

    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        try {
            HashMap<String, Set<Grant>> checkUserExists = this.checkUserExists(userName);
            if (this.isUserAvailable(userName, checkUserExists.values())) {
                return new AuthorizationResponse(new String[]{userName}, 0);
            }
        }
        catch (Exception e) {
            Logging.authorityConnectors.error((Object)"Error while getting authorization response", (Throwable)e);
            return RESPONSE_UNREACHABLE;
        }
        return RESPONSE_USERNOTFOUND;
    }

    private boolean isUserAvailable(String userName, Collection<Set<Grant>> collection) {
        String[] users = this.getUsers(collection);
        return Arrays.asList(users).contains(userName);
    }

    private String[] getUsers(Collection<Set<Grant>> collection) {
        HashSet<String> users = new HashSet<String>();
        for (Collection collection2 : collection) {
            Set c1 = (Set)collection2;
            for (Grant grant : c1) {
                if (grant == null || grant.getGrantee() == null) continue;
                Grantee grantee = grant.getGrantee();
                if (grantee instanceof CanonicalGrantee) {
                    users.add(((CanonicalGrantee)grantee).getDisplayName());
                    continue;
                }
                users.add(grantee.getIdentifier());
            }
        }
        return users.toArray(new String[users.size()]);
    }

    private HashMap<String, Set<Grant>> checkUserExists(String userName) throws ManifoldCFException {
        GrantsThread t = new GrantsThread(this.getClient());
        try {
            t.start();
            t.finishUp();
            return t.getResult();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            AmazonS3Authority.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            AmazonS3Authority.handleIOException(e);
        }
        catch (IOException e) {
            AmazonS3Authority.handleIOException(e);
        }
        catch (ResponseException e) {
            AmazonS3Authority.handleResponseException(e);
        }
        return null;
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    private static void handleIOException(IOException e) throws ManifoldCFException {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.authorityConnectors.warn((Object)("JIRA: IO exception: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
    }

    private static void handleResponseException(ResponseException e) throws ManifoldCFException {
        throw new ManifoldCFException("Response exception: " + e.getMessage(), (Throwable)e);
    }

    protected static class CheckThread
    extends Thread {
        protected String result = "Unknown";
        protected AmazonS3 s3 = null;
        protected Throwable exception = null;

        public CheckThread(AmazonS3 s3) {
            this.s3 = s3;
        }

        public String getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                Owner s3AccountOwner;
                if (this.s3 != null && (s3AccountOwner = this.s3.getS3AccountOwner()) != null) {
                    this.result = StringUtils.isNotEmpty((String)s3AccountOwner.getDisplayName()) ? "Connection OK" : "Connection Failed";
                }
            }
            catch (AmazonServiceException e) {
                this.result = "Connection Failed : " + e.getMessage();
                this.exception = e;
                Logging.authorityConnectors.error((Object)e);
            }
            catch (AmazonClientException e) {
                this.result = "Connection Failed : " + e.getMessage();
                this.exception = e;
                Logging.authorityConnectors.error((Object)e);
            }
        }
    }

    protected static class GrantsThread
    extends Thread {
        protected Throwable exception = null;
        protected boolean result = false;
        protected AmazonS3 amazonS3 = null;
        private HashMap<String, Set<Grant>> grants;

        public GrantsThread(AmazonS3 amazonS3) {
            this.amazonS3 = amazonS3;
            this.setDaemon(true);
            this.grants = new HashMap();
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }

        @Override
        public void run() {
            List listBuckets = this.amazonS3.listBuckets();
            for (Bucket bucket : listBuckets) {
                AccessControlList bucketAcl = this.amazonS3.getBucketAcl(bucket.getName());
                if (bucketAcl == null) continue;
                this.grants.put(bucket.getName(), bucketAcl.getGrants());
            }
        }

        public HashMap<String, Set<Grant>> getResult() {
            return this.grants;
        }
    }
}

