/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.Property;

public final class PropertyCache {
    private static final int SEGMENT_COUNT = 32;
    private static final int INITIAL_BUCKET_COUNT = 32;
    private static final int SEGMENT_MASK = 31;
    private final boolean useCache;
    private CacheSegment[] segments = new CacheSegment[32];
    private CacheEntry[] table = new CacheEntry[32];
    private Class runtimeType;
    private final boolean[] votesForRehash = new boolean[32];
    static final /* synthetic */ boolean $assertionsDisabled;

    private static int hash(Object x) {
        return PropertyCache.hash(x.hashCode());
    }

    private static int hash(int hashCode) {
        int h = hashCode;
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private static boolean eq(Object p, Object q) {
        return p == q || p != null && p.equals(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanSegment(int segmentIndex) {
        CacheSegment segment = this.segments[segmentIndex];
        int oldCount = segment.count;
        for (int bucketIndex = segmentIndex; bucketIndex < this.table.length; bucketIndex += 32) {
            CacheEntry prev = null;
            CacheEntry entry = this.table[bucketIndex];
            if (entry == null) continue;
            do {
                if (entry.get() == null) {
                    if (prev == null) {
                        this.table[bucketIndex] = entry.nextEntry;
                    } else {
                        prev.nextEntry = entry.nextEntry;
                    }
                    segment.count--;
                    if (!$assertionsDisabled && segment.count < 0) {
                        throw new AssertionError();
                    }
                    continue;
                }
                prev = entry;
            } while ((entry = entry.nextEntry) != null);
        }
        boolean[] blArray = this.votesForRehash;
        synchronized (this.votesForRehash) {
            if (oldCount > segment.count) {
                this.votesForRehash[segmentIndex] = false;
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
            if (!this.votesForRehash[segmentIndex]) {
                this.votesForRehash[segmentIndex] = true;
                int voteCount = 0;
                int i = 32;
                while (--i >= 0) {
                    if (!this.votesForRehash[i]) continue;
                    ++voteCount;
                }
                if (voteCount > 7) {
                    this.rehash(31);
                    i = 32;
                    while (--i >= 0) {
                        this.votesForRehash[i] = false;
                    }
                }
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Object o) {
        CacheSegment segment;
        int hash = PropertyCache.hash(o);
        int segmentIndex = hash & 0x1F;
        CacheSegment cacheSegment = segment = this.segments[segmentIndex];
        synchronized (cacheSegment) {
            int index = hash & this.table.length - 1;
            CacheEntry entry = this.table[index];
            if (entry == null) {
                this.table[index] = entry = new CacheEntry(o, null);
                segment.count++;
            } else {
                CacheEntry newEntry;
                Object p = entry.get();
                if (PropertyCache.eq(p, o)) {
                    return;
                }
                this.table[index] = newEntry = new CacheEntry(o, entry);
                segment.count++;
            }
            if (segment.count > 2 * this.table.length) {
                this.cleanSegment(segmentIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(Object o) {
        CacheSegment segment;
        Object q;
        CacheEntry entry;
        int hash = PropertyCache.hash(o);
        int index = hash & this.table.length - 1;
        CacheEntry e = entry = this.table[index];
        while (e != null) {
            if (e.hash == hash && (q = e.get()) != null && PropertyCache.eq(q, o)) {
                return q;
            }
            e = e.nextEntry;
        }
        CacheSegment cacheSegment = segment = this.segments[hash & 0x1F];
        synchronized (cacheSegment) {
            CacheEntry e2 = entry = this.table[index];
            while (e2 != null) {
                if (e2.hash == hash && (q = e2.get()) != null && PropertyCache.eq(q, o)) {
                    return q;
                }
                e2 = e2.nextEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rehash(int index) {
        CacheSegment seg;
        CacheSegment cacheSegment = seg = this.segments[index];
        synchronized (cacheSegment) {
            if (index > 0) {
                this.rehash(index - 1);
            } else {
                int newLength = this.table.length << 1;
                if (newLength > 0) {
                    int i = this.segments.length;
                    while (--i >= 0) {
                        this.segments[i].count = 0;
                    }
                    CacheEntry[] newTable = new CacheEntry[newLength];
                    --newLength;
                    int i2 = this.table.length;
                    while (--i2 >= 0) {
                        CacheEntry c = this.table[i2];
                        while (c != null) {
                            Object o = c.get();
                            if (o != null) {
                                int hash = c.hash;
                                int idx = hash & newLength;
                                newTable[idx] = new CacheEntry(o, newTable[idx]);
                                this.segments[hash & 0x1F].count++;
                            }
                            c = c.nextEntry;
                        }
                    }
                    this.table = newTable;
                }
            }
        }
    }

    public PropertyCache(Class c) {
        this.useCache = Boolean.valueOf(System.getProperty("org.apache.fop.fo.properties.use-cache", "true"));
        if (this.useCache) {
            int i = 32;
            while (--i >= 0) {
                this.segments[i] = new CacheSegment();
            }
        }
        this.runtimeType = c;
    }

    private Object fetch(Object obj) {
        if (!this.useCache) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        Object cacheEntry = this.get(obj);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        this.put(obj);
        return obj;
    }

    public Property fetch(Property prop) {
        return (Property)this.fetch((Object)prop);
    }

    public CommonHyphenation fetch(CommonHyphenation chy) {
        return (CommonHyphenation)this.fetch((Object)chy);
    }

    public CommonFont fetch(CommonFont cf) {
        return (CommonFont)this.fetch((Object)cf);
    }

    public CommonBorderPaddingBackground fetch(CommonBorderPaddingBackground cbpb) {
        return (CommonBorderPaddingBackground)this.fetch((Object)cbpb);
    }

    public CommonBorderPaddingBackground.BorderInfo fetch(CommonBorderPaddingBackground.BorderInfo bi) {
        return (CommonBorderPaddingBackground.BorderInfo)this.fetch((Object)bi);
    }

    public Marker.MarkerAttribute fetch(Marker.MarkerAttribute ma) {
        return (Marker.MarkerAttribute)this.fetch((Object)ma);
    }

    public String toString() {
        return super.toString() + "[runtimeType=" + this.runtimeType + "]";
    }

    static {
        $assertionsDisabled = !PropertyCache.class.desiredAssertionStatus();
    }

    private static class CacheSegment {
        private int count = 0;

        private CacheSegment() {
        }
    }

    private static class CacheEntry
    extends WeakReference {
        private volatile CacheEntry nextEntry;
        private final int hash;

        public CacheEntry(Object p, CacheEntry nextEntry, ReferenceQueue refQueue) {
            super(p, refQueue);
            this.nextEntry = nextEntry;
            this.hash = PropertyCache.hash(p);
        }

        public CacheEntry(Object p, CacheEntry nextEntry) {
            super(p);
            this.nextEntry = nextEntry;
            this.hash = PropertyCache.hash(p);
        }
    }
}

