/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.sourcemap;

import com.github.sommeri.sourcemap.Base64VLQ;
import com.github.sommeri.sourcemap.FilePosition;
import com.github.sommeri.sourcemap.Preconditions;
import com.github.sommeri.sourcemap.SourceMapConsumerV3;
import com.github.sommeri.sourcemap.SourceMapGenerator;
import com.github.sommeri.sourcemap.SourceMapParseException;
import com.github.sommeri.sourcemap.SourceMapSection;
import com.github.sommeri.sourcemap.SourceMapUtil;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SourceMapGeneratorV3
implements SourceMapGenerator {
    private static final int UNMAPPED = -1;
    private List<Mapping> mappings = new ArrayList<Mapping>();
    private LinkedHashMap<String, Integer> sourceFileKeyMap = new LinkedHashMap();
    private LinkedList<String> sourceFileNameMap = new LinkedList();
    private LinkedList<String> sourceFileContentMap = new LinkedList();
    private LinkedHashMap<String, Integer> originalNameMap = new LinkedHashMap();
    private String lastSourceFileName = null;
    private String lastSourceFileContent = null;
    private int lastSourceFileIndex = -1;
    private Mapping lastMapping;
    private FilePosition offsetPosition = new FilePosition(0, 0);
    private FilePosition prefixPosition = new FilePosition(0, 0);

    @Override
    public void reset() {
        this.mappings.clear();
        this.lastMapping = null;
        this.sourceFileKeyMap.clear();
        this.sourceFileNameMap.clear();
        this.sourceFileContentMap.clear();
        this.originalNameMap.clear();
        this.lastSourceFileName = null;
        this.lastSourceFileContent = null;
        this.lastSourceFileIndex = -1;
        this.offsetPosition = new FilePosition(0, 0);
        this.prefixPosition = new FilePosition(0, 0);
    }

    @Override
    public void validate(boolean validate) {
    }

    @Override
    public void setWrapperPrefix(String prefix) {
        int prefixLine = 0;
        int prefixIndex = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == '\n') {
                ++prefixLine;
                prefixIndex = 0;
                continue;
            }
            ++prefixIndex;
        }
        this.prefixPosition = new FilePosition(prefixLine, prefixIndex);
    }

    @Override
    public void setStartingPosition(int offsetLine, int offsetIndex) {
        Preconditions.checkState(offsetLine >= 0);
        Preconditions.checkState(offsetIndex >= 0);
        this.offsetPosition = new FilePosition(offsetLine, offsetIndex);
    }

    @Override
    public void addMapping(String sourceName, String sourceContent, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
        if (sourceName == null && sourceContent == null || sourceStartPosition.getLine() < 0) {
            return;
        }
        FilePosition adjustedStart = startPosition;
        FilePosition adjustedEnd = endPosition;
        if (this.offsetPosition.getLine() != 0 || this.offsetPosition.getColumn() != 0) {
            adjustedStart = this.adjustPosition(startPosition, this.offsetPosition);
            adjustedEnd = this.adjustPosition(endPosition, this.offsetPosition);
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = sourceName;
        mapping.sourceContent = sourceContent;
        mapping.originalPosition = sourceStartPosition;
        mapping.originalName = symbolName;
        mapping.startPosition = adjustedStart;
        mapping.endPosition = adjustedEnd;
        if (this.lastMapping != null) {
            int lastLine = this.lastMapping.startPosition.getLine();
            int lastColumn = this.lastMapping.startPosition.getColumn();
            int nextLine = mapping.startPosition.getLine();
            int nextColumn = mapping.startPosition.getColumn();
            Preconditions.checkState(nextLine > lastLine || nextLine == lastLine && nextColumn >= lastColumn, "Incorrect source mappings order, previous : (" + lastLine + "," + lastColumn + ")\n" + "new : (" + nextLine + "," + nextColumn + ")\nnode : %s");
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    @Override
    public void addSourceFile(String sourceName, String sourceContent) {
        this.getSourceId(sourceName, sourceContent);
    }

    private FilePosition adjustPosition(FilePosition mapping, FilePosition offset) {
        int offsetLine = offset.getLine();
        int offsetColumn = offset.getColumn();
        if (mapping.getLine() > 0) {
            offsetColumn = 0;
        }
        FilePosition adjustedStart = new FilePosition(mapping.getLine() + offsetLine, mapping.getColumn() + offsetColumn);
        return adjustedStart;
    }

    private List<Mapping> getMappings() {
        return this.mappings;
    }

    @Override
    public void offsetAndAppend(SourceMapGenerator otherGenerator, FilePosition offset) {
        if (!(otherGenerator instanceof SourceMapGeneratorV3)) {
            throw new IllegalStateException("Incompatible generator supplied.");
        }
        SourceMapGeneratorV3 other = (SourceMapGeneratorV3)otherGenerator;
        List<Mapping> otherMappings = other.getMappings();
        for (Mapping mapping : otherMappings) {
            Mapping adjustedMapping = new Mapping();
            adjustedMapping.sourceFile = mapping.sourceFile;
            adjustedMapping.originalPosition = mapping.originalPosition;
            adjustedMapping.originalName = mapping.originalName;
            adjustedMapping.startPosition = this.adjustPosition(mapping.startPosition, offset);
            adjustedMapping.endPosition = this.adjustPosition(mapping.endPosition, offset);
            this.mappings.add(adjustedMapping);
        }
    }

    public void mergeMapSection(int line, int column, String mapSectionContents) throws SourceMapParseException {
        this.setStartingPosition(line, column);
        SourceMapConsumerV3 section = new SourceMapConsumerV3();
        section.parse(mapSectionContents);
        section.visitMappings(new ConsumerEntryVisitor());
    }

    @Override
    public void appendTo(Appendable out, String name) throws IOException {
        int maxLine = this.prepMappings();
        out.append("{\n");
        SourceMapGeneratorV3.appendFirstField(out, "version", "3");
        SourceMapGeneratorV3.appendField(out, "file", SourceMapGeneratorV3.escapeString(name));
        SourceMapGeneratorV3.appendField(out, "lineCount", String.valueOf(maxLine + 1));
        SourceMapGeneratorV3.appendFieldStart(out, "mappings");
        new LineMapper(out).appendLineMappings();
        SourceMapGeneratorV3.appendFieldEnd(out);
        SourceMapGeneratorV3.appendFieldStart(out, "sources");
        out.append("[");
        this.addSourceNameMap(out);
        out.append("]");
        SourceMapGeneratorV3.appendFieldEnd(out);
        SourceMapGeneratorV3.appendFieldStart(out, "sourcesContent");
        out.append("[");
        this.addSourceContentMap(out);
        out.append("]");
        SourceMapGeneratorV3.appendFieldEnd(out);
        SourceMapGeneratorV3.appendFieldStart(out, "names");
        out.append("[");
        this.addSymbolNameMap(out);
        out.append("]");
        SourceMapGeneratorV3.appendFieldEnd(out);
        out.append("\n}\n");
    }

    private void addSourceNameMap(Appendable out) throws IOException {
        this.addValuesList(out, this.sourceFileNameMap);
    }

    private void addSourceContentMap(Appendable out) throws IOException {
        this.addValuesList(out, this.sourceFileContentMap);
    }

    private void addSymbolNameMap(Appendable out) throws IOException {
        this.addNameMap(out, this.originalNameMap);
    }

    private void addNameMap(Appendable out, Map<String, Integer> map) throws IOException {
        int i = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            if (i != 0) {
                out.append(",");
            }
            out.append(key == null ? null : SourceMapGeneratorV3.escapeString(key));
            ++i;
        }
    }

    private void addValuesList(Appendable out, List<String> list) throws IOException {
        int i = 0;
        for (String string : list) {
            if (i != 0) {
                out.append(",");
            }
            out.append(string == null ? null : SourceMapGeneratorV3.escapeString(string));
            ++i;
        }
    }

    private static String escapeString(String value) {
        return SourceMapUtil.escapeString(value);
    }

    private static void appendFirstField(Appendable out, String name, CharSequence value) throws IOException {
        out.append("\"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendField(Appendable out, String name, CharSequence value) throws IOException {
        out.append(",\n");
        out.append("\"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendFieldStart(Appendable out, String name) throws IOException {
        SourceMapGeneratorV3.appendField(out, name, "");
    }

    private static void appendFieldEnd(Appendable out) throws IOException {
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int id = 0;
        int maxLine = 0;
        for (Mapping m : this.mappings) {
            if (!m.used) continue;
            m.id = id++;
            int endPositionLine = m.endPosition.getLine();
            maxLine = Math.max(maxLine, endPositionLine);
        }
        return maxLine + this.prefixPosition.getLine();
    }

    @Override
    public void appendIndexMapTo(Appendable out, String name, List<SourceMapSection> sections) throws IOException {
        out.append("{\n");
        SourceMapGeneratorV3.appendFirstField(out, "version", "3");
        SourceMapGeneratorV3.appendField(out, "file", SourceMapGeneratorV3.escapeString(name));
        SourceMapGeneratorV3.appendFieldStart(out, "sections");
        out.append("[\n");
        boolean first = true;
        for (SourceMapSection section : sections) {
            if (first) {
                first = false;
            } else {
                out.append(",\n");
            }
            out.append("{\n");
            SourceMapGeneratorV3.appendFirstField(out, "offset", this.offsetValue(section.getLine(), section.getColumn()));
            if (section.getSectionType() == SourceMapSection.SectionType.URL) {
                SourceMapGeneratorV3.appendField(out, "url", SourceMapGeneratorV3.escapeString(section.getSectionValue()));
            } else if (section.getSectionType() == SourceMapSection.SectionType.MAP) {
                SourceMapGeneratorV3.appendField(out, "map", section.getSectionValue());
            } else {
                throw new IOException("Unexpected section type");
            }
            out.append("\n}");
        }
        out.append("\n]");
        SourceMapGeneratorV3.appendFieldEnd(out);
        out.append("\n}\n");
    }

    private CharSequence offsetValue(int line, int column) throws IOException {
        StringBuilder out = new StringBuilder();
        out.append("{\n");
        SourceMapGeneratorV3.appendFirstField(out, "line", String.valueOf(line));
        SourceMapGeneratorV3.appendField(out, "column", String.valueOf(column));
        out.append("\n}");
        return out;
    }

    private int getSourceId(String sourceName, String sourceContent) {
        if (sourceName != this.lastSourceFileName || sourceContent != this.lastSourceFileContent) {
            this.lastSourceFileName = sourceName;
            this.lastSourceFileContent = sourceContent;
            String key = sourceName != null ? sourceName : sourceContent;
            Integer index = this.sourceFileKeyMap.get(key);
            if (index != null) {
                this.lastSourceFileIndex = index;
            } else {
                this.lastSourceFileIndex = this.sourceFileKeyMap.size();
                this.sourceFileKeyMap.put(key, this.lastSourceFileIndex);
                this.sourceFileNameMap.add(sourceName);
                this.sourceFileContentMap.add(sourceContent);
            }
        }
        return this.lastSourceFileIndex;
    }

    private int getNameId(String symbolName) {
        int originalNameIndex;
        Integer index = this.originalNameMap.get(symbolName);
        if (index != null) {
            originalNameIndex = index;
        } else {
            originalNameIndex = this.originalNameMap.size();
            this.originalNameMap.put(symbolName, originalNameIndex);
        }
        return originalNameIndex;
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private int previousLine = -1;
        private int previousColumn = 0;
        private int previousSourceFileId;
        private int previousSourceLine;
        private int previousSourceColumn;
        private int previousNameId;

        LineMapper(Appendable out) {
            this.out = out;
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            if (this.previousLine != line) {
                this.previousColumn = 0;
            }
            if (line != nextLine || col != nextCol) {
                if (this.previousLine == line) {
                    this.out.append(',');
                }
                this.writeEntry(m, col);
                this.previousLine = line;
                this.previousColumn = col;
            }
            for (int i = line; i <= nextLine && i != nextLine; ++i) {
                this.closeLine(false);
                this.openLine(false);
            }
        }

        void writeEntry(Mapping m, int column) throws IOException {
            Base64VLQ.encode(this.out, column - this.previousColumn);
            this.previousColumn = column;
            if (m != null) {
                int sourceId = SourceMapGeneratorV3.this.getSourceId(m.sourceFile, m.sourceContent);
                Base64VLQ.encode(this.out, sourceId - this.previousSourceFileId);
                this.previousSourceFileId = sourceId;
                int srcline = m.originalPosition.getLine();
                int srcColumn = m.originalPosition.getColumn();
                Base64VLQ.encode(this.out, srcline - this.previousSourceLine);
                this.previousSourceLine = srcline;
                Base64VLQ.encode(this.out, srcColumn - this.previousSourceColumn);
                this.previousSourceColumn = srcColumn;
                if (m.originalName != null) {
                    int nameId = SourceMapGeneratorV3.this.getNameId(m.originalName);
                    Base64VLQ.encode(this.out, nameId - this.previousNameId);
                    this.previousNameId = nameId;
                }
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine(true);
            new MappingTraversal().traverse(this);
            this.closeLine(true);
        }

        private void openLine(boolean firstEntry) throws IOException {
            if (firstEntry) {
                this.out.append('\"');
            }
        }

        private void closeLine(boolean finalEntry) throws IOException {
            this.out.append(';');
            if (finalEntry) {
                this.out.append('\"');
            }
        }
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor v) throws IOException {
            ArrayDeque<Mapping> stack = new ArrayDeque<Mapping>();
            for (Mapping m : SourceMapGeneratorV3.this.mappings) {
                while (!stack.isEmpty() && !this.isOverlapped((Mapping)stack.peek(), m)) {
                    Mapping previous = (Mapping)stack.pop();
                    this.maybeVisit(v, previous);
                }
                Mapping parent = (Mapping)stack.peek();
                this.maybeVisitParent(v, parent, m);
                stack.push(m);
            }
            while (!stack.isEmpty()) {
                Mapping m = (Mapping)stack.pop();
                this.maybeVisit(v, m);
            }
        }

        private int getAdjustedLine(FilePosition p) {
            return p.getLine() + SourceMapGeneratorV3.this.prefixPosition.getLine();
        }

        private int getAdjustedCol(FilePosition p) {
            int rawLine = p.getLine();
            int rawCol = p.getColumn();
            return rawLine != 0 ? rawCol : rawCol + SourceMapGeneratorV3.this.prefixPosition.getColumn();
        }

        private boolean isOverlapped(Mapping m1, Mapping m2) {
            int l1 = m1.endPosition.getLine();
            int l2 = m2.startPosition.getLine();
            int c1 = m1.endPosition.getColumn();
            int c2 = m2.startPosition.getColumn();
            return l1 == l2 && c1 >= c2 || l1 > l2;
        }

        private void maybeVisit(MappingVisitor v, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.endPosition);
            int nextCol = this.getAdjustedCol(m.endPosition);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, m, nextLine, nextCol);
            }
        }

        private void maybeVisitParent(MappingVisitor v, Mapping parent, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.startPosition);
            int nextCol = this.getAdjustedCol(m.startPosition);
            Preconditions.checkState(this.line < nextLine || this.col <= nextCol);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, parent, nextLine, nextCol);
            }
        }

        private void visit(MappingVisitor v, Mapping m, int nextLine, int nextCol) throws IOException {
            Preconditions.checkState(this.line <= nextLine);
            Preconditions.checkState(this.line < nextLine || this.col < nextCol);
            if (this.line == nextLine && this.col == nextCol) {
                Preconditions.checkState(false);
                return;
            }
            v.visit(m, this.line, this.col, nextLine, nextCol);
            this.line = nextLine;
            this.col = nextCol;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            if (m != null) {
                m.used = true;
            }
        }
    }

    static class Mapping {
        int id = -1;
        String sourceFile;
        String sourceContent;
        FilePosition originalPosition;
        FilePosition startPosition;
        FilePosition endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }

    class ConsumerEntryVisitor
    implements SourceMapConsumerV3.EntryVisitor {
        ConsumerEntryVisitor() {
        }

        @Override
        public void visit(String sourceName, String sourceContent, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
            SourceMapGeneratorV3.this.addMapping(sourceName, sourceContent, symbolName, sourceStartPosition, startPosition, endPosition);
        }
    }
}

