/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.shared.TempStoreOutputStreamFactory;

public class ObjectService {
    private static final int BUFFER_SIZE = 65536;

    public static class BulkUpdateProperties
    extends AbstractAtomPubServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            TempStoreOutputStreamFactory streamFactory = (TempStoreOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser(streamFactory);
            parser.parse((InputStream)request.getInputStream());
            List result = null;
            try {
                BulkUpdateImpl bulkUpdate = parser.getBulkUpdate();
                if (bulkUpdate == null) {
                    throw new CmisInvalidArgumentException("Bulk update data is missing!");
                }
                if (this.stopBeforeService(service)) {
                    return;
                }
                result = service.bulkUpdateProperties(repositoryId, bulkUpdate.getObjectIdAndChangeToken(), bulkUpdate.getProperties(), bulkUpdate.getAddSecondaryTypeIds(), bulkUpdate.getRemoveSecondaryTypeIds(), null);
                if (this.stopAfterService(service)) {
                    return;
                }
            }
            finally {
                parser.release();
            }
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(null, null, null, "Bulk Update Properties", new GregorianCalendar(DateTimeHelper.GMT), null, result == null ? null : BigInteger.valueOf(result.size()));
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "update", null);
            feed.writeSelfLink(selfLink.toString(), null);
            if (result != null) {
                AtomEntry entry = new AtomEntry(feed.getWriter());
                for (BulkUpdateObjectIdAndChangeToken idAndToken : result) {
                    if (idAndToken == null || idAndToken.getId() == null) continue;
                    ObjectDataImpl object = new ObjectDataImpl();
                    PropertiesImpl properties = new PropertiesImpl();
                    object.setProperties((Properties)properties);
                    properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectId", idAndToken.getNewId() != null ? idAndToken.getNewId() : idAndToken.getId()));
                    if (idAndToken.getChangeToken() != null) {
                        properties.addProperty((PropertyData)new PropertyStringImpl("cmis:changeToken", idAndToken.getChangeToken()));
                    }
                    this.writeObjectEntry(service, entry, (ObjectData)object, null, repositoryId, null, null, baseUrl, false, context.getCmisVersion());
                }
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class UpdateProperties
    extends AbstractAtomPubServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            Boolean checkin = this.getBooleanParameter(request, "checkin");
            String checkinComment = this.getStringParameter(request, "checkinComment");
            Boolean major = this.getBooleanParameter(request, "major");
            TempStoreOutputStreamFactory streamFactory = (TempStoreOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser((InputStream)request.getInputStream(), streamFactory);
            Holder objectIdHolder = new Holder((Object)objectId);
            try {
                if (checkin != null && checkin.booleanValue()) {
                    if (this.stopBeforeService(service)) {
                        return;
                    }
                    ContentStream contentStream = parser.getContentStream();
                    service.checkIn(repositoryId, objectIdHolder, major, parser.getProperties(), contentStream, checkinComment, parser.getPolicyIds(), null, null, null);
                    if (this.stopAfterService(service)) {
                        return;
                    }
                } else {
                    Properties properties = parser.getProperties();
                    String changeToken = null;
                    if (properties != null && (changeToken = this.extractChangeToken(properties)) != null) {
                        properties = new PropertiesImpl(properties);
                        ((PropertiesImpl)properties).removeProperty("cmis:changeToken");
                    }
                    if (changeToken == null) {
                        changeToken = this.getStringParameter(request, "changeToken");
                    }
                    if (this.stopBeforeService(service)) {
                        return;
                    }
                    service.updateProperties(repositoryId, objectIdHolder, changeToken == null ? null : new Holder((Object)changeToken), properties, null);
                    if (this.stopAfterService(service)) {
                        return;
                    }
                }
            }
            finally {
                parser.release();
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, (String)objectIdHolder.getValue());
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData object = objectInfo.getObject();
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            String location = this.compileUrl(baseUrl, "entry", (String)objectIdHolder.getValue());
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Content-Location", location);
            response.setHeader("Location", location);
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }

        private String extractChangeToken(Properties properties) {
            if (properties == null) {
                return null;
            }
            Map propertiesMap = properties.getProperties();
            if (propertiesMap == null) {
                return null;
            }
            PropertyData changeTokenProperty = (PropertyData)propertiesMap.get("cmis:changeToken");
            if (!(changeTokenProperty instanceof PropertyString)) {
                return null;
            }
            return (String)((PropertyString)changeTokenProperty).getFirstValue();
        }
    }

    public static class GetContentStream
    extends AbstractAtomPubServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            String streamId = this.getStringParameter(request, "streamId");
            BigInteger offset = context.getOffset();
            BigInteger length = context.getLength();
            if (this.stopBeforeService(service)) {
                return;
            }
            ContentStream content = service.getContentStream(repositoryId, objectId, streamId, offset, length, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (content == null || content.getStream() == null) {
                throw new CmisRuntimeException("Content stream is null!");
            }
            if (this.sendContentStreamHeaders(content, request, response)) {
                return;
            }
            String contentType = content.getMimeType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if ((offset == null || offset.signum() == 0) && length == null) {
                response.setStatus(200);
            } else {
                response.setStatus(206);
                if (content.getBigLength() != null && content.getBigLength().signum() == 1) {
                    BigInteger firstBytePos = offset == null ? BigInteger.ZERO : offset;
                    BigInteger lastBytePos = firstBytePos.add(content.getBigLength().subtract(BigInteger.ONE));
                    response.setHeader("Content-Range", "bytes " + firstBytePos.toString() + "-" + lastBytePos.toString() + "/*");
                }
            }
            response.setContentType(contentType);
            if (content.getFileName() != null) {
                response.setHeader("Content-Disposition", MimeHelper.encodeContentDisposition((String)"attachment", (String)content.getFileName()));
            }
            InputStream in = content.getStream();
            ServletOutputStream out = response.getOutputStream();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out, (int)65536);
                out.flush();
            }
            finally {
                IOUtils.closeQuietly((Closeable)in);
            }
        }
    }

    public static class GetAllowableActions
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            if (this.stopBeforeService(service)) {
                return;
            }
            AllowableActions allowableActions = service.getAllowableActions(repositoryId, objectId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (allowableActions == null) {
                throw new CmisRuntimeException("Allowable Actions is null!");
            }
            response.setStatus(200);
            response.setContentType("application/cmisallowableactions+xml");
            XMLStreamWriter writer = XMLUtils.createWriter((OutputStream)response.getOutputStream());
            XMLUtils.startXmlDocument((XMLStreamWriter)writer);
            XMLConverter.writeAllowableActions((XMLStreamWriter)writer, (CmisVersion)context.getCmisVersion(), (boolean)true, (AllowableActions)allowableActions);
            XMLUtils.endXmlDocument((XMLStreamWriter)writer);
        }
    }

    public static class GetObjectByPath
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String path = this.getStringParameter(request, "path");
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePolicyIds = this.getBooleanParameter(request, "includePolicyIds");
            Boolean includeAcl = this.getBooleanParameter(request, "includeACL");
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectData object = service.getObjectByPath(repositoryId, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, object.getId());
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=entry");
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class GetObject
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            ReturnVersion returnVersion = this.getEnumParameter(request, "returnVersion", ReturnVersion.class);
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePolicyIds = this.getBooleanParameter(request, "includePolicyIds");
            Boolean includeAcl = this.getBooleanParameter(request, "includeACL");
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectData object = null;
            object = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getObjectOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null) : service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=entry");
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class DeleteTree
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = this.getStringParameter(request, "id");
            Boolean allVersions = this.getBooleanParameter(request, "allVersions");
            UnfileObject unfileObjects = this.getEnumParameter(request, "unfileObjects", UnfileObject.class);
            Boolean continueOnFailure = this.getBooleanParameter(request, "continueOnFailure");
            if (this.stopBeforeService(service)) {
                return;
            }
            FailedToDeleteData ftd = service.deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (ftd != null && CollectionsHelper.isNotEmpty((Collection)ftd.getIds())) {
                response.setStatus(500);
                response.setContentType("text/plain");
                PrintWriter pw = response.getWriter();
                pw.println("Failed to delete the following objects:");
                for (String id : ftd.getIds()) {
                    pw.println(id);
                }
                pw.flush();
                return;
            }
            response.setStatus(204);
        }
    }

    public static class SetOrAppendContentStream
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String contentDisposition;
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            String changeToken = this.getStringParameter(request, "changeToken");
            Boolean appendFlag = this.getBooleanParameter(request, "append");
            Boolean overwriteFlag = this.getBooleanParameter(request, "overwriteFlag");
            Boolean isLastChunk = this.getBooleanParameter(request, "isLastChunk");
            ContentStreamImpl contentStream = new ContentStreamImpl();
            contentStream.setStream((InputStream)request.getInputStream());
            contentStream.setMimeType(request.getHeader("Content-Type"));
            String lengthStr = request.getHeader("Content-Length");
            if (lengthStr != null) {
                try {
                    contentStream.setLength(new BigInteger(lengthStr));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((contentDisposition = request.getHeader("Content-Disposition")) != null) {
                contentStream.setFileName(MimeHelper.decodeContentDispositionFilename((String)contentDisposition));
            }
            if (this.stopBeforeService(service)) {
                return;
            }
            Holder objectIdHolder = new Holder((Object)objectId);
            if (Boolean.TRUE.equals(appendFlag)) {
                service.appendContentStream(repositoryId, objectIdHolder, changeToken == null ? null : new Holder((Object)changeToken), (ContentStream)contentStream, Boolean.TRUE.equals(isLastChunk), null);
            } else {
                service.setContentStream(repositoryId, objectIdHolder, overwriteFlag, changeToken == null ? null : new Holder((Object)changeToken), (ContentStream)contentStream, null);
            }
            if (this.stopAfterService(service)) {
                return;
            }
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            String contentLocation = this.compileUrl(this.compileBaseUrl(request, repositoryId), "content", newObjectId);
            String location = this.compileUrl(this.compileBaseUrl(request, repositoryId), "id", newObjectId);
            if (newObjectId.equals(objectId)) {
                if (Boolean.TRUE.equals(appendFlag)) {
                    response.setStatus(200);
                    response.setContentLength(0);
                } else if (!Boolean.FALSE.equals(overwriteFlag)) {
                    response.setStatus(200);
                    response.setContentLength(0);
                } else {
                    response.setStatus(201);
                }
            } else {
                response.setStatus(201);
            }
            response.setHeader("Content-Location", contentLocation);
            response.setHeader("Location", location);
        }
    }

    public static class DeleteContentStream
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            String changeToken = this.getStringParameter(request, "changeToken");
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteContentStream(repositoryId, new Holder((Object)objectId), changeToken == null ? null : new Holder((Object)changeToken), null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(204);
        }
    }

    public static class DeleteObject
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            Boolean allVersions = this.getBooleanParameter(request, "allVersions");
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(204);
        }
    }

    public static class CreateRelationship
    extends AbstractAtomPubServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            TempStoreOutputStreamFactory streamFactory = (TempStoreOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser((InputStream)request.getInputStream(), streamFactory);
            String newObjectId = null;
            try {
                if (this.stopBeforeService(service)) {
                    return;
                }
                newObjectId = service.createRelationship(repositoryId, parser.getProperties(), parser.getPolicyIds(), null, null, null);
                if (this.stopAfterService(service)) {
                    return;
                }
            }
            finally {
                parser.release();
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, newObjectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData object = objectInfo.getObject();
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Location", this.compileUrl(baseUrl, "entry", newObjectId));
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class Create
    extends AbstractAtomPubServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = this.getStringParameter(request, "id");
            String sourceFolderId = this.getStringParameter(request, "sourceFolderId");
            VersioningState versioningState = this.getEnumParameter(request, "versioningState", VersioningState.class);
            TempStoreOutputStreamFactory streamFactory = (TempStoreOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser(streamFactory);
            parser.setIgnoreAtomContentSrc(true);
            parser.parse((InputStream)request.getInputStream());
            String newObjectId = null;
            String objectId = parser.getId();
            try {
                if (this.stopBeforeService(service)) {
                    return;
                }
                if (objectId == null) {
                    ContentStream contentStream = parser.getContentStream();
                    newObjectId = service.create(repositoryId, parser.getProperties(), folderId, contentStream, versioningState, parser.getPolicyIds(), null);
                } else if (sourceFolderId == null || sourceFolderId.trim().length() == 0) {
                    service.addObjectToFolder(repositoryId, objectId, folderId, null, null);
                    newObjectId = objectId;
                } else {
                    Holder objectIdHolder = new Holder((Object)objectId);
                    service.moveObject(repositoryId, objectIdHolder, folderId, sourceFolderId, null);
                    newObjectId = (String)objectIdHolder.getValue();
                }
                if (this.stopAfterService(service)) {
                    return;
                }
            }
            finally {
                parser.release();
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, newObjectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData object = objectInfo.getObject();
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Location", this.compileUrl(baseUrl, "entry", newObjectId));
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }
}

