/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;

public class LobStoreInJar
implements LobStore {
    final int lobBlockSize;
    Database database;
    DataInputStream dataInput;
    final String fileName;
    long realPosition;

    public LobStoreInJar(Database database, int n) {
        this.lobBlockSize = n;
        this.database = database;
        try {
            this.fileName = database.getPath() + ".lobs";
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public byte[] getBlockBytes(int n, int n2) {
        try {
            long l = (long)n * (long)this.lobBlockSize;
            int n3 = n2 * this.lobBlockSize;
            byte[] byArray = new byte[n3];
            this.fileSeek(l);
            this.dataInput.readFully(byArray, 0, n3);
            this.realPosition = l + (long)n3;
            return byArray;
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void setBlockBytes(byte[] byArray, int n, int n2) {
    }

    @Override
    public void setBlockBytes(byte[] byArray, long l, int n, int n2) {
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public void setLength(long l) {
    }

    @Override
    public void close() {
        try {
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void synch() {
    }

    private void resetStream() throws IOException {
        if (this.dataInput != null) {
            this.dataInput.close();
        }
        InputStream inputStream = null;
        try {
            ClassLoader classLoader;
            inputStream = this.getClass().getResourceAsStream(this.fileName);
            if (inputStream == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                inputStream = classLoader.getResourceAsStream(this.fileName);
            }
        }
        catch (Throwable throwable) {
            if (inputStream == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        finally {
            if (inputStream == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.dataInput = new DataInputStream(inputStream);
        this.realPosition = 0L;
    }

    private void fileSeek(long l) throws IOException {
        long l2;
        if (this.dataInput == null) {
            this.resetStream();
        }
        if (l < (l2 = this.realPosition)) {
            this.resetStream();
            l2 = 0L;
        }
        while (l > l2) {
            l2 += this.dataInput.skip(l - l2);
        }
        this.realPosition = l;
    }
}

