/*
 * Decompiled with CFR 0.152.
 */
package org.jline.consoleui.prompt.builder;

import org.jline.consoleui.elements.InputValue;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.reader.Completer;

public class InputValueBuilder {
    private final PromptBuilder promptBuilder;
    private String name;
    private String defaultValue;
    private String message;
    private Character mask;
    private Completer completer;

    public InputValueBuilder(PromptBuilder promptBuilder) {
        this.promptBuilder = promptBuilder;
    }

    public InputValueBuilder name(String name) {
        this.name = name;
        return this;
    }

    public InputValueBuilder defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public InputValueBuilder message(String message) {
        this.message = message;
        return this;
    }

    public InputValueBuilder mask(char mask) {
        this.mask = Character.valueOf(mask);
        return this;
    }

    public PromptBuilder addPrompt() {
        InputValue inputValue = new InputValue(this.name, this.message, null, this.defaultValue);
        if (this.mask != null) {
            inputValue.setMask(this.mask);
        }
        if (this.completer != null) {
            inputValue.setCompleter(this.completer);
        }
        this.promptBuilder.addPrompt(inputValue);
        return this.promptBuilder;
    }

    public InputValueBuilder addCompleter(Completer completer) {
        this.completer = completer;
        return this;
    }
}

