/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.lifecycle.mapping.LifecycleMojo;

public class LifecyclePhase {
    private List<LifecycleMojo> mojos;
    private final Function<String, LifecycleMojo> fromGoalIntoLifecycleMojo = s -> {
        LifecycleMojo lifecycleMojo = new LifecycleMojo();
        lifecycleMojo.setGoal(s.trim());
        return lifecycleMojo;
    };

    public LifecyclePhase() {
    }

    public LifecyclePhase(String goals) {
        this.set(goals);
    }

    public List<LifecycleMojo> getMojos() {
        return this.mojos;
    }

    public void setMojos(List<LifecycleMojo> mojos) {
        this.mojos = mojos;
    }

    public void set(String goals) {
        this.mojos = new ArrayList<LifecycleMojo>();
        if (goals != null && !goals.isEmpty()) {
            String[] mojoGoals = goals.split(",");
            this.mojos = Arrays.stream(mojoGoals).map(this.fromGoalIntoLifecycleMojo).collect(Collectors.toList());
        }
    }

    public String toString() {
        return Optional.ofNullable(this.getMojos()).orElse(Collections.emptyList()).stream().map(LifecycleMojo::getGoal).collect(Collectors.joining(","));
    }

    @Deprecated
    public static Map<String, String> toLegacyMap(Map<String, LifecyclePhase> lifecyclePhases) {
        if (lifecyclePhases == null) {
            return null;
        }
        if (lifecyclePhases.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> phases = new LinkedHashMap<String, String>();
        for (Map.Entry<String, LifecyclePhase> e : lifecyclePhases.entrySet()) {
            phases.put(e.getKey(), e.getValue().toString());
        }
        return phases;
    }
}

