/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.collector;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.DefaultMaven;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.collector.ProjectCollectionStrategy;

@Named(value="PomlessCollectionStrategy")
@Singleton
public class PomlessCollectionStrategy
implements ProjectCollectionStrategy {
    private final ProjectBuilder projectBuilder;

    @Inject
    public PomlessCollectionStrategy(ProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    @Override
    public List<MavenProject> collectProjects(MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest buildingRequest = request.getProjectBuildingRequest();
        UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
        MavenProject project = this.projectBuilder.build((ModelSource)modelSource, buildingRequest).getProject();
        project.setExecutionRoot(true);
        request.setProjectPresent(false);
        return Arrays.asList(project);
    }
}

