/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.transfer.NoTransporterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultTransporterProvider
implements TransporterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransporterProvider.class);
    private final Map<String, TransporterFactory> transporterFactories;

    @Inject
    public DefaultTransporterProvider(Map<String, TransporterFactory> transporterFactories) {
        this.transporterFactories = Collections.unmodifiableMap(transporterFactories);
    }

    public Transporter newTransporter(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        PrioritizedComponents<TransporterFactory> factories = PrioritizedComponents.reuseOrCreate(session, TransporterFactory.class, this.transporterFactories, TransporterFactory::getPriority);
        ArrayList<NoTransporterException> errors = new ArrayList<NoTransporterException>();
        for (PrioritizedComponent<TransporterFactory> factory : factories.getEnabled()) {
            try {
                Transporter transporter = factory.getComponent().newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using transporter ").append(transporter.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, transporter);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    LOGGER.debug(buffer.toString());
                }
                return transporter;
            }
            catch (NoTransporterException e) {
                LOGGER.debug("Could not obtain transporter factory for {}", (Object)repository, (Object)e);
                errors.add(e);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No transporter factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" using the registered transporter factories: ");
            factories.list(buffer);
        }
        NoTransporterException ex = new NoTransporterException(repository, buffer.toString(), errors.size() == 1 ? (Throwable)errors.get(0) : null);
        if (errors.size() > 1) {
            errors.forEach(ex::addSuppressed);
        }
        throw ex;
    }
}

