/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.logging;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.cling.logging.Slf4jConfiguration;
import org.apache.maven.cling.logging.impl.UnsupportedSlf4jBindingConfiguration;
import org.slf4j.ILoggerFactory;

public class Slf4jConfigurationFactory {
    public static final String RESOURCE = "META-INF/maven/slf4j-configuration.properties";

    public static Slf4jConfiguration getConfiguration(ILoggerFactory loggerFactory) {
        String slf4jBinding = loggerFactory.getClass().getCanonicalName();
        try {
            Enumeration<URL> resources = Slf4jConfigurationFactory.class.getClassLoader().getResources(RESOURCE);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    String impl;
                    InputStream is = resource.openStream();
                    Properties properties = new Properties();
                    if (is != null) {
                        try (InputStream in = is;){
                            properties.load(in);
                        }
                    }
                    if ((impl = properties.getProperty(slf4jBinding)) == null) continue;
                    return (Slf4jConfiguration)Class.forName(impl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new UnsupportedSlf4jBindingConfiguration();
    }
}

