/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.xep0124;

import javax.servlet.http.HttpServletRequest;
import org.apache.vysper.mina.codec.StanzaBuilderFactory;
import org.apache.vysper.xml.fragment.AbstractXMLElementBuilder;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.extension.xep0124.BoshHandler;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BoshSaxContentHandler
implements ContentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoshSaxContentHandler.class);
    private final BoshHandler boshHandler;
    private final HttpServletRequest request;
    private final StanzaBuilderFactory builderFactory;
    private AbstractXMLElementBuilder<StanzaBuilder, Stanza> builder;
    private int depth = 0;
    private boolean isBodyPayloadDecoded = false;

    public BoshSaxContentHandler(BoshHandler boshHandler, HttpServletRequest req) {
        this.boshHandler = boshHandler;
        this.request = req;
        this.builderFactory = new StanzaBuilderFactory();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.builder != null) {
            this.builder.addText(new String(ch));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        if (this.depth == 0 && !this.isBodyPayloadDecoded) {
            this.emitStanza();
        } else {
            this.builder.endInnerElement();
        }
    }

    private void emitStanza() {
        this.isBodyPayloadDecoded = true;
        XMLElement element = this.builder.build();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BOSH decoding request: {}", (Object)new Renderer(element).getComplete());
        }
        this.boshHandler.process(this.request, (Stanza)element);
        this.builder = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.depth;
        if (this.builder == null) {
            this.builder = this.builderFactory.createBuilder(localName, uri, this.extractPrefix(qName), null, null);
        } else {
            this.builder.startInnerElement(localName, uri);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            this.builder.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
        }
    }

    private String extractPrefix(String qname) {
        int index = qname.indexOf(58);
        if (index > -1) {
            return qname.substring(0, index);
        }
        return "";
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

