/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.compact;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;

public class Lexer {
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char BEGIN_NODE_TYPE_NAME = '[';
    public static final char END_NODE_TYPE_NAME = ']';
    public static final char EXTENDS = '>';
    public static final char LIST_DELIMITER = ',';
    public static final char PROPERTY_DEFINITION = '-';
    public static final char CHILD_NODE_DEFINITION = '+';
    public static final char BEGIN_TYPE = '(';
    public static final char END_TYPE = ')';
    public static final char DEFAULT = '=';
    public static final char CONSTRAINT = '<';
    public static final String[] ORDERABLE = new String[]{"orderable", "ord", "o"};
    public static final String[] MIXIN = new String[]{"mixin", "mix", "m"};
    public static final String[] PRIMARY = new String[]{"primary", "pri", "!"};
    public static final String[] AUTOCREATED = new String[]{"autocreated", "aut", "a"};
    public static final String[] MANDATORY = new String[]{"mandatory", "man", "m"};
    public static final String[] PROTECTED = new String[]{"protected", "pro", "p"};
    public static final String[] MULTIPLE = new String[]{"multiple", "mul", "*"};
    public static final String[] COPY = new String[]{"copy", "Copy", "COPY"};
    public static final String[] VERSION = new String[]{"version", "Version", "VERSION"};
    public static final String[] INITIALIZE = new String[]{"initialize", "Initialize", "INITIALIZE"};
    public static final String[] COMPUTE = new String[]{"compute", "Compute", "COMPUTE"};
    public static final String[] IGNORE = new String[]{"ignore", "Ignore", "IGNORE"};
    public static final String[] ABORT = new String[]{"abort", "Abort", "ABORT"};
    public static final String[] ATTRIBUTE = new String[]{"primary", "pri", "!", "autocreated", "aut", "a", "mandatory", "man", "m", "protected", "pro", "p", "multiple", "mul", "*", "copy", "Copy", "COPY", "version", "Version", "VERSION", "initialize", "Initialize", "INITIALIZE", "compute", "Compute", "COMPUTE", "ignore", "Ignore", "IGNORE", "abort", "Abort", "ABORT"};
    public static final String[] STRING = new String[]{"string", "String", "STRING"};
    public static final String[] BINARY = new String[]{"binary", "Binary", "BINARY"};
    public static final String[] LONG = new String[]{"long", "Long", "LONG"};
    public static final String[] DOUBLE = new String[]{"double", "Double", "DOUBLE"};
    public static final String[] BOOLEAN = new String[]{"boolean", "Boolean", "BOOLEAN"};
    public static final String[] DATE = new String[]{"date", "Date", "DATE"};
    public static final String[] NAME = new String[]{"name", "Name", "NAME"};
    public static final String[] PATH = new String[]{"path", "Path", "PATH"};
    public static final String[] REFERENCE = new String[]{"reference", "Reference", "REFERENCE"};
    public static final String[] UNDEFINED = new String[]{"undefined", "Undefined", "UNDEFINED", "*"};
    public static final String EOF = "eof";
    private final StreamTokenizer st;
    private final String systemId;

    public Lexer(Reader r, String systemId) {
        this.systemId = systemId;
        this.st = new StreamTokenizer(r);
        this.st.eolIsSignificant(false);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(58, 58);
        this.st.wordChars(95, 95);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.ordinaryChar(91);
        this.st.ordinaryChar(93);
        this.st.ordinaryChar(62);
        this.st.ordinaryChar(44);
        this.st.ordinaryChar(45);
        this.st.ordinaryChar(43);
        this.st.ordinaryChar(40);
        this.st.ordinaryChar(41);
        this.st.ordinaryChar(61);
        this.st.ordinaryChar(60);
    }

    public String getNextToken() throws ParseException {
        try {
            int tokenType = this.st.nextToken();
            if (tokenType == -1) {
                return EOF;
            }
            if (tokenType == -3 || tokenType == 39 || tokenType == 34) {
                return this.st.sval;
            }
            if (tokenType == -2) {
                return String.valueOf(this.st.nval);
            }
            return new String(new char[]{(char)tokenType});
        }
        catch (IOException e) {
            this.fail("IOException while attempting to read input stream", e);
            return null;
        }
    }

    public void fail(String message) throws ParseException {
        throw new ParseException(message, this.st.lineno(), -1, this.systemId);
    }

    public void fail(String message, Throwable e) throws ParseException {
        throw new ParseException(message, e, this.st.lineno(), -1, this.systemId);
    }

    public void fail(Throwable e) throws ParseException {
        throw new ParseException(e, this.st.lineno(), -1, this.systemId);
    }
}

