/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.AbstractPubSubGeneralHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.MultipleSubscriptionException;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class PubSubUnsubscribeHandler
extends AbstractPubSubGeneralHandler {
    public PubSubUnsubscribeHandler(PubSubServiceConfiguration serviceConfiguration) {
        super(serviceConfiguration);
    }

    protected String getWorkerElement() {
        return "unsubscribe";
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        StanzaBuilder sb;
        block9: {
            Entity serverJID = this.serviceConfiguration.getDomainJID();
            CollectionNode root = this.serviceConfiguration.getRootNode();
            Entity sender = PubSubUnsubscribeHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
            EntityImpl subJID = null;
            sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
            sb.startInnerElement("pubsub", "http://jabber.org/protocol/pubsub");
            XMLElement unsub = stanza.getFirstInnerElement().getFirstInnerElement();
            String strSubJID = unsub.getAttributeValue("jid");
            String strSubID = unsub.getAttributeValue("subid");
            try {
                subJID = EntityImpl.parse((String)strSubJID);
            }
            catch (EntityFormatException e) {
                return this.errorStanzaGenerator.generateJIDMalformedErrorStanza(sender, serverJID, stanza);
            }
            if (!sender.getBareJID().equals(subJID.getBareJID())) {
                return this.errorStanzaGenerator.generateInsufficientPrivilegesErrorStanza(sender, serverJID, stanza);
            }
            String nodeName = this.extractNodeName(stanza);
            LeafNode node = root.find(nodeName);
            if (node == null) {
                return this.errorStanzaGenerator.generateNoNodeErrorStanza(sender, serverJID, stanza);
            }
            if (strSubID == null) {
                try {
                    if (!node.unsubscribe((Entity)subJID)) {
                        return this.errorStanzaGenerator.generateNoSuchSubscriberErrorStanza(sender, serverJID, stanza);
                    }
                    break block9;
                }
                catch (MultipleSubscriptionException e) {
                    return this.errorStanzaGenerator.generateSubIDRequiredErrorStanza(sender, serverJID, stanza);
                }
            }
            if (!node.unsubscribe(strSubID, (Entity)subJID)) {
                return this.errorStanzaGenerator.generateSubIDNotValidErrorStanza(sender, serverJID, stanza);
            }
        }
        sb.endInnerElement();
        return new IQStanza((Stanza)sb.build());
    }
}

