/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.fragment;

import java.util.Map;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.ResolverNamespaceResolver;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xml.fragment.XMLText;

public class Renderer {
    private XMLElement topElement;
    private StringBuilder openElementBuffer = new StringBuilder();
    private StringBuilder elementContentBuffer = new StringBuilder();
    private StringBuilder closeElementBuffer = new StringBuilder();
    private static final String COLON = ":";

    public Renderer(XMLElement element) {
        this.topElement = element;
        ResolverNamespaceResolver nsResolver = new ResolverNamespaceResolver();
        this.renderXMLElement(this.topElement, nsResolver, this.openElementBuffer, this.elementContentBuffer, this.closeElementBuffer);
    }

    public String getOpeningElement() {
        return this.openElementBuffer.toString();
    }

    public String getElementContent() {
        return this.elementContentBuffer.toString();
    }

    public String getClosingElement() {
        return this.closeElementBuffer.toString();
    }

    public String getComplete() {
        return this.openElementBuffer.toString() + this.elementContentBuffer.toString() + this.closeElementBuffer.toString();
    }

    private void renderXMLElement(XMLElement element, ResolverNamespaceResolver nsResolver, StringBuilder openElementBuffer, StringBuilder elementContentBuffer, StringBuilder closeElementBuffer) {
        nsResolver.push(element);
        openElementBuffer.append("<");
        this.renderElementName(openElementBuffer, element, nsResolver);
        Map<String, String> nsAttrs = nsResolver.getNamespaceDeclarations();
        for (Map.Entry<String, String> nsAttr : nsAttrs.entrySet()) {
            openElementBuffer.append(" ");
            String name = nsAttr.getKey().length() == 0 ? "xmlns" : "xmlns:" + nsAttr.getKey();
            this.renderAttribute(openElementBuffer, name, nsAttr.getValue());
        }
        for (Attribute attribute : element.getAttributes()) {
            if (attribute.getName().startsWith("xmlns")) continue;
            openElementBuffer.append(" ");
            this.renderAttribute(openElementBuffer, attribute, nsResolver);
        }
        openElementBuffer.append(">");
        for (XMLFragment xmlFragment : element.getInnerFragments()) {
            if (xmlFragment instanceof XMLElement) {
                this.renderXMLElement((XMLElement)xmlFragment, nsResolver, elementContentBuffer, elementContentBuffer, elementContentBuffer);
                continue;
            }
            if (xmlFragment instanceof XMLText) {
                elementContentBuffer.append(this.escapeTextValue(((XMLText)xmlFragment).getText()));
                continue;
            }
            if (xmlFragment == null) continue;
            throw new UnsupportedOperationException("cannot render XML fragment of type " + xmlFragment.getClass().getName());
        }
        closeElementBuffer.append("</");
        this.renderElementName(closeElementBuffer, element, nsResolver);
        closeElementBuffer.append(">");
        nsResolver.pop();
    }

    private boolean hasXmlnsReservedName(Attribute attribute) {
        String name = attribute.getName();
        return name.equals("xmlns") || name.startsWith("xmlns:");
    }

    private void renderElementName(StringBuilder buffer, XMLElement element, ResolverNamespaceResolver nsResolver) {
        String prefix;
        if (element.getNamespacePrefix() != null && element.getNamespacePrefix().length() > 0) {
            buffer.append(element.getNamespacePrefix()).append(COLON);
        } else if (element.getNamespaceURI().length() > 0 && (prefix = nsResolver.resolvePrefix(element.getNamespaceURI())) != null && prefix.length() > 0) {
            buffer.append(prefix).append(COLON);
        }
        buffer.append(element.getName());
    }

    private void renderAttribute(StringBuilder buffer, Attribute attribute, ResolverNamespaceResolver nsResolver) {
        String qname = !attribute.getNamespaceUri().equals("") ? nsResolver.resolvePrefix(attribute.getNamespaceUri()) + COLON + attribute.getName() : attribute.getName();
        this.renderAttribute(buffer, qname, attribute.getValue());
    }

    private void renderAttribute(StringBuilder buffer, String qname, String value) {
        buffer.append(qname).append("=\"").append(this.escapeAttributeValue(value)).append("\"");
    }

    private String escapeAttributeValue(String value) {
        return value.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String escapeTextValue(String value) {
        return value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

