/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons;

import java.util.Arrays;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.QItemDefinitionImpl;

public class QPropertyDefinitionImpl
extends QItemDefinitionImpl
implements QPropertyDefinition {
    private final int requiredType;
    private final String[] valueConstraints;
    private final QValue[] defaultValues;
    private final boolean multiple;

    public QPropertyDefinitionImpl(QPropertyDefinition propDef) {
        this(propDef.getName(), propDef.getDeclaringNodeType(), propDef.isAutoCreated(), propDef.isMandatory(), propDef.getOnParentVersion(), propDef.isProtected(), propDef.getDefaultValues(), propDef.isMultiple(), propDef.getRequiredType(), propDef.getValueConstraints());
    }

    public QPropertyDefinitionImpl(Name name, Name declaringNodeType, boolean isAutoCreated, boolean isMandatory, int onParentVersion, boolean isProtected, QValue[] defaultValues, boolean isMultiple, int requiredType, String[] valueConstraints) {
        super(name, declaringNodeType, isAutoCreated, isMandatory, onParentVersion, isProtected);
        if (valueConstraints == null) {
            throw new NullPointerException("valueConstraints");
        }
        this.defaultValues = defaultValues;
        this.multiple = isMultiple;
        this.requiredType = requiredType;
        this.valueConstraints = valueConstraints;
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public QValue[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean definesNode() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QPropertyDefinition) {
            QPropertyDefinition other = (QPropertyDefinition)obj;
            return super.equals(obj) && this.requiredType == other.getRequiredType() && Arrays.equals(this.valueConstraints, other.getValueConstraints()) && Arrays.equals(this.defaultValues, other.getDefaultValues()) && this.multiple == other.isMultiple();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDeclaringNodeType().toString());
            sb.append('/');
            if (this.definesResidual()) {
                sb.append('*');
            } else {
                sb.append(this.getName().toString());
            }
            sb.append('/');
            sb.append(this.getRequiredType());
            sb.append('/');
            sb.append(this.isMultiple() ? 1 : 0);
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }
}

