/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultPresenceHandler;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.MUCStanzaBuilder;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.handler.MUCHandlerHelper;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliation;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliations;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Conference;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Occupant;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Role;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Room;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.RoomType;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.History;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.MucUserItem;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.Status;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas.X;
import org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.ServerAdministrationService;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUCPresenceHandler
extends DefaultPresenceHandler {
    final Logger logger = LoggerFactory.getLogger(MUCPresenceHandler.class);
    private Conference conference;

    public MUCPresenceHandler(Conference conference) {
        this.conference = conference;
    }

    protected boolean verifyNamespace(Stanza stanza) {
        return true;
    }

    private Stanza createPresenceErrorStanza(Entity from, Entity to, String id, String type, String errorName) {
        return MUCHandlerHelper.createErrorStanza("presence", "jabber:client", from, to, id, type, errorName, Arrays.asList(new XMLElement[]{new X(new XMLElement[0])}));
    }

    protected Stanza executePresenceLogic(PresenceStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity roomAndNick = stanza.getTo();
        Entity occupantJid = stanza.getFrom();
        Entity roomJid = roomAndNick.getBareJID();
        String nick = roomAndNick.getResource();
        if (nick == null) {
            return this.createPresenceErrorStanza(roomJid, occupantJid, stanza.getID(), "modify", "jid-malformed");
        }
        String type = stanza.getType();
        if (type == null) {
            return this.available(stanza, roomJid, occupantJid, nick, serverRuntimeContext);
        }
        if (type.equals("unavailable")) {
            return this.unavailable(stanza, roomJid, occupantJid, nick, serverRuntimeContext);
        }
        throw new RuntimeException("Presence type not handled by MUC module: " + type);
    }

    private String getInnerElementText(XMLElement element, String childName) {
        try {
            XMLElement childElm = element.getSingleInnerElementsNamed(childName);
            if (childElm != null && childElm.getInnerText() != null) {
                return childElm.getInnerText().getText();
            }
            return null;
        }
        catch (XMLSemanticError e) {
            return null;
        }
    }

    private Stanza available(PresenceStanza stanza, Entity roomJid, Entity newOccupantJid, String nick, ServerRuntimeContext serverRuntimeContext) {
        boolean newRoom = false;
        Room room = this.conference.findRoom(roomJid);
        if (room == null) {
            room = this.conference.createRoom(roomJid, roomJid.getNode(), new RoomType[0]);
            newRoom = true;
        }
        if (room.isInRoom(newOccupantJid)) {
            this.logger.debug("{} has requested to change nick in room {}", (Object)newOccupantJid, (Object)roomJid);
            Occupant occupant = room.findOccupantByJID(newOccupantJid);
            if (nick.equals(occupant.getNick())) {
                for (Occupant receiver : room.getOccupants()) {
                    this.sendChangeShowStatus(occupant, receiver, room, this.getInnerElementText((XMLElement)stanza, "show"), this.getInnerElementText((XMLElement)stanza, "status"), serverRuntimeContext);
                }
            } else {
                if (room.isInRoom(nick)) {
                    return this.createPresenceErrorStanza(roomJid, newOccupantJid, stanza.getID(), "cancel", "conflict");
                }
                String oldNick = occupant.getNick();
                occupant.setNick(nick);
                for (Occupant receiver : room.getOccupants()) {
                    this.sendChangeNickUnavailable(occupant, oldNick, receiver, room, serverRuntimeContext);
                }
                for (Occupant receiver : room.getOccupants()) {
                    this.sendChangeNickAvailable(occupant, receiver, room, serverRuntimeContext);
                }
            }
        } else {
            Affiliations roomAffiliations;
            ServerAdministrationService adhocCommandsService;
            Occupant newOccupant;
            this.logger.debug("{} has requested to enter room {}", (Object)newOccupantJid, (Object)roomJid);
            boolean nickConflict = room.isInRoom(nick);
            boolean nickRewritten = false;
            int counter = 1;
            String rewrittenNick = null;
            while (nickConflict && counter < 100 && room.rewritesDuplicateNick()) {
                rewrittenNick = nick + "_" + counter;
                nickConflict = room.isInRoom(rewrittenNick);
                if (nickConflict) {
                    ++counter;
                    continue;
                }
                nick = rewrittenNick;
                nickRewritten = true;
            }
            if (nickConflict) {
                return this.createPresenceErrorStanza(roomJid, newOccupantJid, stanza.getID(), "cancel", "conflict");
            }
            if (room.isRoomType(RoomType.PasswordProtected)) {
                X x = X.fromStanza((Stanza)stanza);
                String password = null;
                if (x != null) {
                    password = x.getPasswordValue();
                }
                if (password == null || !password.equals(room.getPassword())) {
                    return this.createPresenceErrorStanza(roomJid, newOccupantJid, stanza.getID(), "auth", "not-authorized");
                }
            }
            try {
                newOccupant = room.addOccupant(newOccupantJid, nick);
            }
            catch (RuntimeException e) {
                return this.createPresenceErrorStanza(roomJid, newOccupantJid, stanza.getID(), "auth", e.getMessage());
            }
            if (newRoom) {
                room.getAffiliations().add(newOccupantJid, Affiliation.Owner);
                newOccupant.setRole(Role.Moderator);
            }
            if ((adhocCommandsService = (ServerAdministrationService)serverRuntimeContext.getServerRuntimeContextService("ServerAdministrationService")) != null && adhocCommandsService.isAdmin(newOccupantJid.getBareJID()) && (roomAffiliations = room.getAffiliations()).getAffiliation(newOccupantJid) != Affiliation.Owner) {
                roomAffiliations.add(newOccupantJid, Affiliation.Admin);
                newOccupant.setRole(Role.Moderator);
            }
            for (Occupant occupant : room.getOccupants()) {
                this.sendExistingOccupantToNewOccupant(newOccupant, occupant, room, serverRuntimeContext);
            }
            for (Occupant occupant : room.getOccupants()) {
                this.sendNewOccupantPresenceToExisting(newOccupant, occupant, room, serverRuntimeContext, nickRewritten);
            }
            boolean includeJid = room.isRoomType(RoomType.NonAnonymous);
            List<Stanza> history = room.getHistory().createStanzas(newOccupant, includeJid, History.fromStanza((Stanza)stanza));
            this.relayStanzas(newOccupantJid, history, serverRuntimeContext);
            this.logger.debug("{} successfully entered room {}", (Object)newOccupantJid, (Object)roomJid);
        }
        return null;
    }

    private Stanza unavailable(PresenceStanza stanza, Entity roomJid, Entity occupantJid, String nick, ServerRuntimeContext serverRuntimeContext) {
        Occupant exitingOccupant;
        Room room = this.conference.findRoom(roomJid);
        if (room != null && (exitingOccupant = room.findOccupantByJID(occupantJid)) != null) {
            Set<Occupant> allOccupants = room.getOccupants();
            room.removeOccupant(occupantJid);
            String statusMessage = null;
            try {
                XMLElement statusElement = stanza.getSingleInnerElementsNamed("status");
                if (statusElement != null && statusElement.getInnerText() != null) {
                    statusMessage = statusElement.getInnerText().getText();
                }
            }
            catch (XMLSemanticError e) {
                // empty catch block
            }
            for (Occupant occupant : allOccupants) {
                this.sendExitRoomPresenceToExisting(exitingOccupant, occupant, room, statusMessage, serverRuntimeContext);
            }
            if (room.isRoomType(RoomType.Temporary) && room.isEmpty()) {
                this.conference.deleteRoom(roomJid);
            }
        }
        return null;
    }

    private void sendExistingOccupantToNewOccupant(Occupant newOccupant, Occupant existingOccupant, Room room, ServerRuntimeContext serverRuntimeContext) {
        if (existingOccupant.getJid().equals(newOccupant.getJid())) {
            return;
        }
        EntityImpl roomAndOccupantNick = new EntityImpl(room.getJID(), existingOccupant.getNick());
        Stanza presenceToNewOccupant = MUCStanzaBuilder.createPresenceStanza((Entity)roomAndOccupantNick, newOccupant.getJid(), null, "http://jabber.org/protocol/muc#user", new MucUserItem(existingOccupant.getAffiliation(), existingOccupant.getRole()));
        this.logger.debug("Room presence from {} sent to {}", (Object)newOccupant, (Object)roomAndOccupantNick);
        this.relayStanza(newOccupant.getJid(), presenceToNewOccupant, serverRuntimeContext);
    }

    private void sendNewOccupantPresenceToExisting(Occupant newOccupant, Occupant existingOccupant, Room room, ServerRuntimeContext serverRuntimeContext, boolean nickRewritten) {
        EntityImpl roomAndNewUserNick = new EntityImpl(room.getJID(), newOccupant.getNick());
        ArrayList<XMLElement> inner = new ArrayList<XMLElement>();
        boolean includeJid = room.isRoomType(RoomType.NonAnonymous) || room.isRoomType(RoomType.SemiAnonymous) && existingOccupant.getRole() == Role.Moderator;
        inner.add(new MucUserItem(newOccupant, includeJid, false));
        if (existingOccupant.getJid().equals(newOccupant.getJid())) {
            if (room.isRoomType(RoomType.NonAnonymous)) {
                inner.add(new Status(Status.StatusCode.ROOM_NON_ANONYMOUS));
            }
            inner.add(new Status(Status.StatusCode.OWN_PRESENCE));
            if (nickRewritten) {
                inner.add(new Status(Status.StatusCode.NICK_MODIFIED));
            }
        }
        Stanza presenceToExisting = MUCStanzaBuilder.createPresenceStanza((Entity)roomAndNewUserNick, existingOccupant.getJid(), null, "http://jabber.org/protocol/muc#user", inner);
        this.logger.debug("Room presence from {} sent to {}", (Object)roomAndNewUserNick, (Object)existingOccupant);
        this.relayStanza(existingOccupant.getJid(), presenceToExisting, serverRuntimeContext);
    }

    private void sendChangeNickUnavailable(Occupant changer, String oldNick, Occupant receiver, Room room, ServerRuntimeContext serverRuntimeContext) {
        EntityImpl roomAndOldNick = new EntityImpl(room.getJID(), oldNick);
        ArrayList<XMLElement> inner = new ArrayList<XMLElement>();
        boolean includeJid = this.includeJidInItem(room, receiver);
        inner.add(new MucUserItem(changer, includeJid, true));
        inner.add(new Status(Status.StatusCode.NEW_NICK));
        if (receiver.getJid().equals(changer.getJid())) {
            inner.add(new Status(Status.StatusCode.OWN_PRESENCE));
        }
        Stanza presenceToReceiver = MUCStanzaBuilder.createPresenceStanza((Entity)roomAndOldNick, receiver.getJid(), PresenceStanzaType.UNAVAILABLE, "http://jabber.org/protocol/muc#user", inner);
        this.logger.debug("Room presence from {} sent to {}", (Object)roomAndOldNick, (Object)receiver);
        this.relayStanza(receiver.getJid(), presenceToReceiver, serverRuntimeContext);
    }

    private void sendChangeShowStatus(Occupant changer, Occupant receiver, Room room, String show, String status, ServerRuntimeContext serverRuntimeContext) {
        EntityImpl roomAndNick = new EntityImpl(room.getJID(), changer.getNick());
        StanzaBuilder builder = StanzaBuilder.createPresenceStanza((Entity)roomAndNick, (Entity)receiver.getJid(), null, null, (String)show, (String)status);
        boolean includeJid = this.includeJidInItem(room, receiver);
        builder.addPreparedElement((XMLElement)new X("http://jabber.org/protocol/muc#user", new MucUserItem(changer, includeJid, true)));
        this.logger.debug("Room presence from {} sent to {}", (Object)roomAndNick, (Object)receiver);
        this.relayStanza(receiver.getJid(), (Stanza)builder.build(), serverRuntimeContext);
    }

    private boolean includeJidInItem(Room room, Occupant receiver) {
        return room.isRoomType(RoomType.NonAnonymous) || room.isRoomType(RoomType.SemiAnonymous) && receiver.getRole() == Role.Moderator;
    }

    private void sendChangeNickAvailable(Occupant changer, Occupant receiver, Room room, ServerRuntimeContext serverRuntimeContext) {
        EntityImpl roomAndOldNick = new EntityImpl(room.getJID(), changer.getNick());
        ArrayList<XMLElement> inner = new ArrayList<XMLElement>();
        boolean includeJid = this.includeJidInItem(room, receiver);
        inner.add(new MucUserItem(changer, includeJid, false));
        if (receiver.getJid().equals(changer.getJid())) {
            inner.add(new Status(Status.StatusCode.OWN_PRESENCE));
        }
        Stanza presenceToReceiver = MUCStanzaBuilder.createPresenceStanza((Entity)roomAndOldNick, receiver.getJid(), null, "http://jabber.org/protocol/muc#user", inner);
        this.relayStanza(receiver.getJid(), presenceToReceiver, serverRuntimeContext);
    }

    private void sendExitRoomPresenceToExisting(Occupant exitingOccupant, Occupant existingOccupant, Room room, String statusMessage, ServerRuntimeContext serverRuntimeContext) {
        EntityImpl roomAndNewUserNick = new EntityImpl(room.getJID(), exitingOccupant.getNick());
        ArrayList<XMLElement> inner = new ArrayList<XMLElement>();
        inner.add(new MucUserItem(null, null, existingOccupant.getAffiliation(), Role.None));
        boolean ownStanza = existingOccupant.getJid().equals(exitingOccupant.getJid());
        if (ownStanza || statusMessage != null) {
            Status status = ownStanza ? new Status(Status.StatusCode.OWN_PRESENCE, statusMessage) : new Status(statusMessage);
            inner.add(status);
        }
        Stanza presenceToExisting = MUCStanzaBuilder.createPresenceStanza((Entity)roomAndNewUserNick, existingOccupant.getJid(), PresenceStanzaType.UNAVAILABLE, "http://jabber.org/protocol/muc#user", inner);
        this.relayStanza(existingOccupant.getJid(), presenceToExisting, serverRuntimeContext);
    }

    protected void relayStanzas(Entity receiver, List<Stanza> stanzas, ServerRuntimeContext serverRuntimeContext) {
        for (Stanza stanza : stanzas) {
            this.relayStanza(receiver, stanza, serverRuntimeContext);
        }
    }

    protected void relayStanza(Entity receiver, Stanza stanza, ServerRuntimeContext serverRuntimeContext) {
        try {
            serverRuntimeContext.getStanzaRelay().relay(receiver, stanza, (DeliveryFailureStrategy)new IgnoreFailureStrategy());
        }
        catch (DeliveryException e) {
            this.logger.warn("presence relaying failed ", (Throwable)e);
        }
    }
}

