/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xmpp.modules.DefaultModule;
import org.apache.vysper.xmpp.modules.ServerRuntimeContextService;
import org.apache.vysper.xmpp.modules.servicediscovery.collection.ServiceDiscoveryRequestListenerRegistry;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ComponentInfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ItemRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServerInfoRequestListener;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultDiscoAwareModule
extends DefaultModule {
    final Logger logger = LoggerFactory.getLogger(DefaultDiscoAwareModule.class);

    @Override
    public void initialize(ServerRuntimeContext serverRuntimeContext) {
        super.initialize(serverRuntimeContext);
        ServerRuntimeContextService service = serverRuntimeContext.getServerRuntimeContextService("discoRequestListenerRegistry");
        if (service == null) {
            this.logger.error("cannot register disco request listeners: no registry service found");
            return;
        }
        ServiceDiscoveryRequestListenerRegistry requestListenerRegistry = (ServiceDiscoveryRequestListenerRegistry)((Object)service);
        ArrayList<InfoRequestListener> infoRequestListeners = new ArrayList<InfoRequestListener>();
        this.addInfoRequestListeners(infoRequestListeners);
        for (InfoRequestListener infoRequestListener : infoRequestListeners) {
            if (infoRequestListener == null) continue;
            requestListenerRegistry.addInfoRequestListener(infoRequestListener);
        }
        ArrayList<ServerInfoRequestListener> serverInfoRequestListeners = new ArrayList<ServerInfoRequestListener>();
        this.addServerInfoRequestListeners(serverInfoRequestListeners);
        for (ServerInfoRequestListener serverInfoRequestListener : serverInfoRequestListeners) {
            if (serverInfoRequestListener == null) continue;
            requestListenerRegistry.addServerInfoRequestListener(serverInfoRequestListener);
        }
        ArrayList<ComponentInfoRequestListener> componentInfoRequestListeners = new ArrayList<ComponentInfoRequestListener>();
        this.addComponentInfoRequestListeners(componentInfoRequestListeners);
        for (ComponentInfoRequestListener componentInfoRequestListener : componentInfoRequestListeners) {
            if (componentInfoRequestListener == null) continue;
            requestListenerRegistry.addComponentInfoRequestListener(componentInfoRequestListener);
        }
        ArrayList<ItemRequestListener> itemRequestListeners = new ArrayList<ItemRequestListener>();
        this.addItemRequestListeners(itemRequestListeners);
        for (ItemRequestListener itemRequestListener : itemRequestListeners) {
            if (itemRequestListener == null) continue;
            requestListenerRegistry.addItemRequestListener(itemRequestListener);
        }
    }

    protected void addInfoRequestListeners(List<InfoRequestListener> infoRequestListeners) {
    }

    protected void addServerInfoRequestListeners(List<ServerInfoRequestListener> serverInfoRequestListeners) {
    }

    protected void addComponentInfoRequestListeners(List<ComponentInfoRequestListener> componentInfoRequestListeners) {
    }

    protected void addItemRequestListeners(List<ItemRequestListener> itemRequestListeners) {
    }
}

