/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.base.handler;

import org.apache.vysper.xml.fragment.XMLElementVerifier;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.XMPPVersion;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.server.response.ServerResponses;
import org.apache.vysper.xmpp.stanza.Stanza;

public class StreamStartHandler
implements StanzaHandler {
    public String getName() {
        return "stream";
    }

    public boolean verify(Stanza stanza) {
        if (stanza == null) {
            return false;
        }
        if (!this.getName().equals(stanza.getName())) {
            return false;
        }
        String namespaceURI = stanza.getNamespaceURI();
        if (namespaceURI == null) {
            return false;
        }
        return namespaceURI.equals("jabber:client") || namespaceURI.equals("jabber:server");
    }

    public boolean isSessionRequired() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResponseStanzaContainer execute(Stanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        XMLElementVerifier xmlElementVerifier = stanza.getVerifier();
        boolean jabberNamespace = "http://etherx.jabber.org/streams".equals(stanza.getNamespaceURI());
        boolean clientCall = xmlElementVerifier.namespacePresent("jabber:client");
        boolean serverCall = xmlElementVerifier.namespacePresent("jabber:server");
        if (clientCall && serverCall) {
            serverCall = false;
        }
        if (serverCall) {
            sessionContext.setServerToServer();
        } else {
            sessionContext.setClientToServer();
        }
        if (sessionStateHolder.getState() != SessionState.INITIATED && sessionStateHolder.getState() != SessionState.ENCRYPTED && sessionStateHolder.getState() != SessionState.AUTHENTICATED) {
            return this.respondUnsupportedStanzaType("unexpected stream start");
        }
        if (!jabberNamespace) {
            return this.respondIllegalNamespaceError("namespace is mandatory: http://etherx.jabber.org/streams");
        }
        String xmlLang = stanza.getXMLLang();
        sessionContext.setXMLLang(xmlLang);
        XMPPVersion responseVersion = null;
        String versionAttributeValue = stanza.getAttributeValue("version");
        if (versionAttributeValue != null) {
            XMPPVersion clientVersion;
            try {
                clientVersion = new XMPPVersion(versionAttributeValue);
            }
            catch (IllegalArgumentException e) {
                return this.respondUnsupportedVersionError(xmlLang, versionAttributeValue, "illegal version value: ");
            }
            if (!clientVersion.equals(XMPPVersion.VERSION_1_0)) {
                if (clientVersion.getMajor() != XMPPVersion.VERSION_1_0.getMajor()) return this.respondUnsupportedVersionError(xmlLang, versionAttributeValue, "major version change not supported: ");
                responseVersion = XMPPVersion.VERSION_1_0;
            } else {
                responseVersion = clientVersion;
            }
        }
        if (xmlElementVerifier.attributePresent("id")) {
            // empty if block
        }
        Stanza responseStanza = null;
        if (clientCall) {
            String toValue = stanza.getAttributeValue("to");
            if (toValue != null) {
                try {
                    EntityImpl.parse(toValue);
                }
                catch (EntityFormatException e) {
                    return new ResponseStanzaContainerImpl(ServerErrorResponses.getStreamError(StreamErrorCondition.IMPROPER_ADDRESSING, sessionContext.getXMLLang(), "could not parse incoming stanza's TO attribute", null));
                }
            }
            responseStanza = new ServerResponses().getStreamOpenerForClient(sessionContext.getServerJID(), responseVersion, sessionContext);
        } else if (serverCall) {
            String fromValue = stanza.getAttributeValue("from");
            if (fromValue != null) {
                try {
                    EntityImpl.parse(fromValue);
                }
                catch (EntityFormatException e) {
                    return new ResponseStanzaContainerImpl(ServerErrorResponses.getStreamError(StreamErrorCondition.INVALID_FROM, sessionContext.getXMLLang(), "could not parse incoming stanza's FROM attribute", null));
                }
            }
            responseStanza = new ServerResponses().getStreamOpenerForServerAcceptor(sessionContext.getServerJID(), responseVersion, sessionContext, serverRuntimeContext.getSslContext() != null);
        } else {
            String descriptiveText = "one of the two namespaces must be present: jabber:client or jabber:server";
            return this.respondIllegalNamespaceError(descriptiveText);
        }
        switch (sessionStateHolder.getState()) {
            case AUTHENTICATED: 
            case ENCRYPTED: {
                break;
            }
            default: {
                sessionStateHolder.setState(SessionState.STARTED);
            }
        }
        if (responseStanza == null) return null;
        return new ResponseStanzaContainerImpl(responseStanza);
    }

    private ResponseStanzaContainer respondIllegalNamespaceError(String descriptiveText) {
        return new ResponseStanzaContainerImpl(ServerErrorResponses.getStreamError(StreamErrorCondition.INVALID_NAMESPACE, null, descriptiveText, null));
    }

    private ResponseStanzaContainer respondUnsupportedStanzaType(String descriptiveText) {
        return new ResponseStanzaContainerImpl(ServerErrorResponses.getStreamError(StreamErrorCondition.UNSUPPORTED_STANZA_TYPE, null, descriptiveText, null));
    }

    private ResponseStanzaContainer respondUnsupportedVersionError(String xmlLang, String versionAttributeValue, String errorMessage) {
        if (xmlLang == null) {
            xmlLang = "en_US";
        }
        Stanza error = ServerErrorResponses.getStreamError(StreamErrorCondition.UNSUPPORTED_VERSION, xmlLang, errorMessage + versionAttributeValue, null);
        return new ResponseStanzaContainerImpl(error);
    }
}

