/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.roster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLElementVerifier;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.roster.AskSubscriptionType;
import org.apache.vysper.xmpp.modules.roster.Roster;
import org.apache.vysper.xmpp.modules.roster.RosterBadRequestException;
import org.apache.vysper.xmpp.modules.roster.RosterConfiguration;
import org.apache.vysper.xmpp.modules.roster.RosterException;
import org.apache.vysper.xmpp.modules.roster.RosterGroup;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.modules.roster.RosterNotAcceptableException;
import org.apache.vysper.xmpp.modules.roster.SubscriptionType;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;
import org.apache.vysper.xmpp.stanza.IQStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RosterUtils {
    public static Map<SubscriptionType, List<RosterItem>> getRosterItemsByState(RosterManager rosterManager, Entity user) {
        Roster roster;
        HashMap<SubscriptionType, List<RosterItem>> rosterItemMap = new HashMap<SubscriptionType, List<RosterItem>>();
        rosterItemMap.put(SubscriptionType.FROM, new ArrayList());
        rosterItemMap.put(SubscriptionType.TO, new ArrayList());
        rosterItemMap.put(SubscriptionType.BOTH, new ArrayList());
        rosterItemMap.put(SubscriptionType.REMOVE, new ArrayList());
        rosterItemMap.put(SubscriptionType.NONE, new ArrayList());
        try {
            roster = rosterManager.retrieve(user);
        }
        catch (RosterException e) {
            throw new RuntimeException("could not retrieve roster for user " + user.getFullQualifiedName());
        }
        for (RosterItem rosterItem : roster) {
            ((List)rosterItemMap.get((Object)rosterItem.getSubscriptionType())).add(rosterItem);
        }
        return rosterItemMap;
    }

    public static RosterItem parseRosterItem(IQStanza stanza) throws RosterBadRequestException, RosterNotAcceptableException {
        return RosterUtils.parseRosterItem(stanza, false);
    }

    public static RosterItem parseRosterItemForTesting(IQStanza stanza) throws RosterBadRequestException, RosterNotAcceptableException {
        return RosterUtils.parseRosterItem(stanza, true);
    }

    private static RosterItem parseRosterItem(IQStanza stanza, boolean parseSubscriptionTypes) throws RosterBadRequestException, RosterNotAcceptableException {
        EntityImpl contact;
        SubscriptionType subscription;
        String name;
        XMLElement itemElement;
        XMLElement queryElement;
        try {
            queryElement = stanza.getSingleInnerElementsNamed("query");
            if (queryElement == null) {
                throw new XMLSemanticError("missing query node");
            }
        }
        catch (XMLSemanticError xmlSemanticError) {
            throw new RosterBadRequestException("roster set needs a single query node.");
        }
        try {
            itemElement = queryElement.getSingleInnerElementsNamed("item");
            if (itemElement == null) {
                throw new XMLSemanticError("missing item node");
            }
        }
        catch (XMLSemanticError xmlSemanticError) {
            throw new RosterBadRequestException("roster set needs a single item node.");
        }
        Attribute attributeJID = itemElement.getAttribute("jid");
        if (attributeJID == null || attributeJID.getValue() == null) {
            throw new RosterBadRequestException("missing 'jid' attribute on item node");
        }
        XMLElementVerifier verifier = itemElement.getVerifier();
        String string = name = verifier.attributePresent("name") ? itemElement.getAttribute("name").getValue() : null;
        if (name != null && name.length() > RosterConfiguration.ROSTER_ITEM_NAME_MAX_LENGTH) {
            throw new RosterNotAcceptableException("roster name too long: " + name.length());
        }
        SubscriptionType subscriptionType = subscription = verifier.attributePresent("subscription") ? SubscriptionType.valueOf(itemElement.getAttribute("subscription").getValue().toUpperCase()) : SubscriptionType.NONE;
        if (!parseSubscriptionTypes && subscription != SubscriptionType.REMOVE) {
            subscription = SubscriptionType.NONE;
        }
        AskSubscriptionType askSubscriptionType = AskSubscriptionType.NOT_SET;
        if (parseSubscriptionTypes) {
            askSubscriptionType = verifier.attributePresent("ask") ? AskSubscriptionType.valueOf("ASK_" + itemElement.getAttribute("ask").getValue().toUpperCase()) : AskSubscriptionType.NOT_SET;
        }
        String contactJid = attributeJID.getValue();
        try {
            contact = EntityImpl.parse(contactJid);
        }
        catch (EntityFormatException e) {
            throw new RosterNotAcceptableException("jid cannot be parsed: " + contactJid);
        }
        ArrayList<RosterGroup> groups = new ArrayList<RosterGroup>();
        List groupElements = itemElement.getInnerElementsNamed("group");
        if (groupElements != null) {
            for (XMLElement groupElement : groupElements) {
                String groupName = null;
                try {
                    groupName = groupElement.getSingleInnerText().getText();
                }
                catch (XMLSemanticError xmlSemanticError) {
                    throw new RosterBadRequestException("roster item group node is malformed");
                }
                if (StringUtils.isEmpty((String)groupName)) {
                    throw new RosterNotAcceptableException("roster item group name of zero length");
                }
                if (groupName.length() > RosterConfiguration.ROSTER_GROUP_NAME_MAX_LENGTH) {
                    throw new RosterNotAcceptableException("roster item group name too long: " + groupName.length());
                }
                RosterGroup group = new RosterGroup(groupName);
                if (groups.contains(group) && !RosterConfiguration.ROSTER_ITEM_GROUP_ALLOW_DUPLICATES) {
                    throw new RosterNotAcceptableException("duplicate roster group name: " + groupName);
                }
                groups.add(group);
            }
        }
        RosterItem rosterItem = new RosterItem(contact, name, subscription, askSubscriptionType, groups);
        return rosterItem;
    }
}

