/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.vysper.mina.TCPEndpoint;
import org.apache.vysper.storage.inmemory.MemoryStorageProviderRegistry;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.modules.Module;
import org.apache.vysper.xmpp.modules.extension.xep0049_privatedata.PrivateDataModule;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandsModule;
import org.apache.vysper.xmpp.modules.extension.xep0054_vcardtemp.VcardTempModule;
import org.apache.vysper.xmpp.modules.extension.xep0077_inbandreg.InBandRegistrationModule;
import org.apache.vysper.xmpp.modules.extension.xep0092_software_version.SoftwareVersionModule;
import org.apache.vysper.xmpp.modules.extension.xep0119_xmppping.XmppPingModule;
import org.apache.vysper.xmpp.modules.extension.xep0133_service_administration.ServiceAdministrationModule;
import org.apache.vysper.xmpp.modules.extension.xep0202_entity_time.EntityTimeModule;
import org.apache.vysper.xmpp.server.XMPPServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMain {
    public static void main(String[] args) throws AccountCreationException, FileNotFoundException {
        String domain = "vysper.org";
        String addedModuleProperty = System.getProperty("vysper.add.module");
        List<Module> listOfModules = null;
        if (addedModuleProperty != null) {
            String[] moduleClassNames = addedModuleProperty.split(",");
            listOfModules = ServerMain.createModuleInstances(moduleClassNames);
        }
        MemoryStorageProviderRegistry providerRegistry = new MemoryStorageProviderRegistry();
        EntityImpl adminJID = EntityImpl.parseUnchecked("admin@" + domain);
        AccountManagement accountManagement = (AccountManagement)providerRegistry.retrieve(AccountManagement.class);
        String initialPassword = System.getProperty("vysper.admin.initial.password", "CHOOSE SECURE PASSWORD");
        if (!accountManagement.verifyAccountExists(adminJID)) {
            accountManagement.addUser(adminJID, initialPassword);
        }
        XMPPServer server = new XMPPServer(domain);
        server.addEndpoint(new TCPEndpoint());
        server.setStorageProviderRegistry(providerRegistry);
        server.setTLSCertificateInfo(new File("src/main/config/bogus_mina_tls.cert"), "boguspw");
        try {
            server.start();
            System.out.println("vysper server is running...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        server.addModule(new SoftwareVersionModule());
        server.addModule(new EntityTimeModule());
        server.addModule(new VcardTempModule());
        server.addModule(new XmppPingModule());
        server.addModule(new PrivateDataModule());
        server.addModule(new InBandRegistrationModule());
        server.addModule(new AdhocCommandsModule());
        ServiceAdministrationModule serviceAdministrationModule = new ServiceAdministrationModule();
        serviceAdministrationModule.setAddAdminJIDs(Arrays.asList(adminJID));
        server.addModule(serviceAdministrationModule);
        if (listOfModules != null) {
            for (Module module : listOfModules) {
                server.addModule(module);
            }
        }
    }

    private static List<Module> createModuleInstances(String[] moduleClassNames) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String moduleClassName : moduleClassNames) {
            Class<?> moduleClass;
            try {
                moduleClass = Class.forName(moduleClassName);
            }
            catch (ClassCastException e) {
                System.err.println("not a Vysper module class: " + moduleClassName);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.err.println("could not load module class " + moduleClassName);
                continue;
            }
            try {
                Module module = (Module)moduleClass.newInstance();
                modules.add(module);
            }
            catch (Exception e) {
                System.err.println("failed to instantiate module class " + moduleClassName);
            }
        }
        return modules;
    }
}

