/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.util.AbstractAttributeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestHeaderValuesMap
extends AbstractAttributeMap<String[]> {
    private final HttpServletRequest _httpServletRequest;
    private final Map<String, String[]> _valueCache = new HashMap<String, String[]>();

    RequestHeaderValuesMap(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    @Override
    protected String[] getAttribute(String key) {
        String[] ret = this._valueCache.get(key);
        if (ret == null) {
            ret = this.toArray(this._httpServletRequest.getHeaders(key));
            this._valueCache.put(key, ret);
        }
        return ret;
    }

    @Override
    protected void setAttribute(String key, String[] value) {
        throw new UnsupportedOperationException("Cannot set HttpServletRequest HeaderValues");
    }

    @Override
    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("Cannot remove HttpServletRequest HeaderValues");
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        return this._httpServletRequest.getHeaderNames();
    }

    private String[] toArray(Enumeration<String> e) {
        ArrayList<String> ret = new ArrayList<String>();
        while (e.hasMoreElements()) {
            ret.add(e.nextElement());
        }
        return ret.toArray(new String[ret.size()]);
    }
}

