/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowHandler;
import javax.faces.lifecycle.ClientWindow;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.myfaces.cdi.JsfApplicationArtifactHolder;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.context.ExceptionHandlerImpl;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.flow.FlowUtils;
import org.apache.myfaces.flow.cdi.ClientWindowFacesFlowLRUMap;
import org.apache.myfaces.flow.cdi.FacesFlowClientWindowCollection;
import org.apache.myfaces.flow.cdi.FlowScopedContextImpl;

@SessionScoped
public class FlowScopeBeanHolder
implements Serializable {
    private Map<String, ContextualStorage> storageMap;
    private Map<String, List<String>> activeFlowMapKeys;
    private FacesFlowClientWindowCollection windowCollection;
    public static final String CURRENT_FLOW_SCOPE_MAP = "oam.CURRENT_FLOW_SCOPE_MAP";
    public static final String CREATED = FlowScopeBeanHolder.class.getName() + ".CREATED";
    @Inject
    JsfApplicationArtifactHolder applicationContextBean;

    @PostConstruct
    public void init() {
        this.storageMap = new ConcurrentHashMap<String, ContextualStorage>();
        this.activeFlowMapKeys = new ConcurrentHashMap<String, List<String>>();
        this.windowCollection = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.refreshClientWindow(facesContext);
        facesContext.getExternalContext().getSessionMap().put(CREATED, true);
    }

    public ContextualStorage getContextualStorage(BeanManager beanManager, String flowClientWindowId) {
        return this.storageMap.computeIfAbsent(flowClientWindowId, k -> new ContextualStorage(beanManager, true));
    }

    public ContextualStorage getContextualStorageNoCreate(BeanManager beanManager, String flowClientWindowId) {
        return this.storageMap.get(flowClientWindowId);
    }

    public Map<String, ContextualStorage> getStorageMap() {
        return this.storageMap;
    }

    public Map<Object, Object> getFlowScopeMap(BeanManager beanManager, String flowClientWindowId, boolean create) {
        HashMap map = null;
        if (create) {
            ContextualStorage contextualStorage = this.getContextualStorage(beanManager, flowClientWindowId);
            ContextualInstanceInfo info = contextualStorage.getStorage().computeIfAbsent(CURRENT_FLOW_SCOPE_MAP, k -> new ContextualInstanceInfo());
            map = (HashMap)info.getContextualInstance();
            if (map == null) {
                map = new HashMap();
                info.setContextualInstance(map);
            }
        } else {
            ContextualInstanceInfo<?> info;
            ContextualStorage contextualStorage = this.getContextualStorageNoCreate(beanManager, flowClientWindowId);
            if (contextualStorage != null && (info = contextualStorage.getStorage().get(CURRENT_FLOW_SCOPE_MAP)) != null) {
                map = (Map)info.getContextualInstance();
            }
        }
        return map;
    }

    public Map<String, ContextualStorage> forceNewStorage() {
        Map<String, ContextualStorage> oldStorageMap = this.storageMap;
        this.storageMap = new ConcurrentHashMap<String, ContextualStorage>();
        return oldStorageMap;
    }

    public void destroyBeans() {
        Map<String, ContextualStorage> oldContextStorages = this.forceNewStorage();
        for (ContextualStorage contextualStorage : oldContextStorages.values()) {
            FlowScopedContextImpl.destroyAllActive(contextualStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void destroyBeansOnPreDestroy() {
        Map<String, ContextualStorage> oldContextStorages = this.forceNewStorage();
        if (!oldContextStorages.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ServletContext servletContext = null;
            if (facesContext == null) {
                try {
                    servletContext = this.applicationContextBean.getServletContext();
                }
                catch (Throwable e) {
                    Logger.getLogger(FlowScopeBeanHolder.class.getName()).log(Level.WARNING, "Cannot locate servletContext to create FacesContext on @PreDestroy flow scope beans. The beans will be destroyed without active FacesContext instance.");
                    servletContext = null;
                }
            }
            if (facesContext == null && servletContext != null) {
                try {
                    StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                    ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                    facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, false);
                    for (ContextualStorage contextualStorage : oldContextStorages.values()) {
                        FlowScopedContextImpl.destroyAllActive(contextualStorage);
                    }
                }
                finally {
                    facesContext.release();
                }
            } else {
                for (ContextualStorage contextualStorage : oldContextStorages.values()) {
                    FlowScopedContextImpl.destroyAllActive(contextualStorage);
                }
            }
        }
    }

    public void refreshClientWindow(FacesContext facesContext) {
        ClientWindow cw;
        if (this.windowCollection == null) {
            Integer ft = MyfacesConfig.getCurrentInstance(facesContext).getNumberOfFacesFlowClientWindowIdsInSession();
            this.windowCollection = new FacesFlowClientWindowCollection(new ClientWindowFacesFlowLRUMap(ft));
        }
        if ((cw = facesContext.getExternalContext().getClientWindow()) != null && cw.getId() != null) {
            this.windowCollection.setFlowScopeBeanHolder(this);
            this.windowCollection.put(cw.getId(), "");
        }
    }

    public void clearFlowMap(String clientWindowId) {
        List<String> activeFlowKeys = this.activeFlowMapKeys.remove(clientWindowId);
        if (activeFlowKeys != null && !activeFlowKeys.isEmpty()) {
            for (String flowMapKey : activeFlowKeys) {
                ContextualStorage contextualStorage = this.storageMap.remove(flowMapKey);
                if (contextualStorage == null) continue;
                FlowScopedContextImpl.destroyAllActive(contextualStorage);
            }
        }
    }

    public List<String> getActiveFlowMapKeys(FacesContext facesContext) {
        ClientWindow cw = facesContext.getExternalContext().getClientWindow();
        String baseKey = cw.getId();
        List<String> activeFlowKeys = this.activeFlowMapKeys.get(baseKey);
        if (activeFlowKeys == null) {
            return Collections.emptyList();
        }
        return activeFlowKeys;
    }

    public void createCurrentFlowScope(FacesContext facesContext) {
        ClientWindow cw = facesContext.getExternalContext().getClientWindow();
        String baseKey = cw.getId();
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        String flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
        List activeFlowKeys = this.activeFlowMapKeys.computeIfAbsent(baseKey, k -> new ArrayList());
        activeFlowKeys.add(0, flowMapKey);
        this.activeFlowMapKeys.put(baseKey, activeFlowKeys);
        this.refreshClientWindow(facesContext);
    }

    public void destroyCurrentFlowScope(FacesContext facesContext) {
        List<String> activeFlowKeys;
        ClientWindow cw = facesContext.getExternalContext().getClientWindow();
        String baseKey = cw.getId();
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        String flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
        ContextualStorage contextualStorage = this.storageMap.remove(flowMapKey);
        if (contextualStorage != null) {
            FlowScopedContextImpl.destroyAllActive(contextualStorage);
        }
        if ((activeFlowKeys = this.activeFlowMapKeys.get(baseKey)) != null && !activeFlowKeys.isEmpty()) {
            activeFlowKeys.remove(flowMapKey);
        }
    }
}

