/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.myfaces.cdi.FacesScopeContext;
import org.apache.myfaces.context.ReleasableFacesContextFactory;
import org.apache.myfaces.context.servlet.FacesContextImplBase;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.lang.Assert;

public class FacesContextImpl
extends FacesContextImplBase {
    static final String RE_SPLITTER = "[\\s\\t\\r\\n]*\\,[\\s\\t\\r\\n]*";
    private Map<String, List<FacesMessage>> _messages = null;
    private List<FacesMessage> _orderedMessages = null;
    private PhaseId _currentPhaseId;
    private ResponseStream _responseStream = null;
    private ResponseWriter _responseWriter = null;
    private FacesMessage.Severity _maximumSeverity = null;
    private boolean _renderResponse = false;
    private boolean _responseComplete = false;
    private boolean _validationFailed = false;
    private PartialViewContext _partialViewContext = null;
    private ReleasableFacesContextFactory _facesContextFactory = null;
    private PartialViewContextFactory _partialViewContextFactory = null;
    private RenderKitFactory _renderKitFactory = null;

    public FacesContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        this(new ServletExternalContextImpl(servletContext, servletRequest, servletResponse));
    }

    private FacesContextImpl(ServletExternalContextImpl externalContext) {
        this(externalContext, externalContext, null);
    }

    public FacesContextImpl(ExternalContext externalContext, ExternalContext defaultExternalContext, ReleasableFacesContextFactory facesContextFactory) {
        super(externalContext, defaultExternalContext);
        this._facesContextFactory = facesContextFactory;
    }

    public FacesContextImpl(ExternalContext externalContext, ExternalContext defaultExternalContext, ReleasableFacesContextFactory facesContextFactory, ApplicationFactory applicationFactory, RenderKitFactory renderKitFactory, PartialViewContextFactory partialViewContextFactory) {
        super(externalContext, defaultExternalContext, applicationFactory, renderKitFactory);
        this._facesContextFactory = facesContextFactory;
        this._renderKitFactory = renderKitFactory;
        this._partialViewContextFactory = partialViewContextFactory;
    }

    @Override
    public final void release() {
        this.assertNotReleased();
        if (ExternalSpecifications.isCDIAvailable(this.getExternalContext())) {
            FacesScopeContext.destroyAllActive(this);
        }
        this._messages = null;
        this._orderedMessages = null;
        this._currentPhaseId = null;
        this._responseStream = null;
        this._responseWriter = null;
        this._maximumSeverity = null;
        this._partialViewContext = null;
        this._renderKitFactory = null;
        this._partialViewContextFactory = null;
        if (this._facesContextFactory != null) {
            this._facesContextFactory.release();
            this._facesContextFactory = null;
        }
        super.release();
    }

    public final FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        return this._maximumSeverity;
    }

    public final void addMessage(String clientId, FacesMessage message) {
        this.assertNotReleased();
        Assert.notNull(message, "message");
        if (this._messages == null) {
            this._messages = new LinkedHashMap<String, List<FacesMessage>>(5, 1.0f);
            this._orderedMessages = new ArrayList<FacesMessage>();
        }
        List lst = this._messages.computeIfAbsent(clientId, k -> new ArrayList(3));
        lst.add(message);
        this._orderedMessages.add(message);
        FacesMessage.Severity serSeverity = message.getSeverity();
        if (serSeverity != null) {
            if (this._maximumSeverity == null) {
                this._maximumSeverity = serSeverity;
            } else if (serSeverity.compareTo((Object)this._maximumSeverity) > 0) {
                this._maximumSeverity = serSeverity;
            }
        }
    }

    public List<FacesMessage> getMessageList() {
        this.assertNotReleased();
        if (this._messages == null) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        return Collections.unmodifiableList(this._orderedMessages);
    }

    public List<FacesMessage> getMessageList(String clientId) {
        this.assertNotReleased();
        if (this._messages == null || !this._messages.containsKey(clientId)) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        return this._messages.get(clientId);
    }

    public final Iterator<FacesMessage> getMessages() {
        this.assertNotReleased();
        if (this._messages == null) {
            return Collections.emptyIterator();
        }
        return this._orderedMessages.iterator();
    }

    public final Iterator<FacesMessage> getMessages(String clientId) {
        this.assertNotReleased();
        if (this._messages == null || !this._messages.containsKey(clientId)) {
            return Collections.emptyIterator();
        }
        return this._messages.get(clientId).iterator();
    }

    public final Iterator<String> getClientIdsWithMessages() {
        this.assertNotReleased();
        if (this._messages == null || this._messages.isEmpty()) {
            return Collections.emptyIterator();
        }
        return this._messages.keySet().iterator();
    }

    public PhaseId getCurrentPhaseId() {
        this.assertNotReleased();
        return this._currentPhaseId;
    }

    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        this.assertNotReleased();
        this._currentPhaseId = currentPhaseId;
    }

    public PartialViewContext getPartialViewContext() {
        this.assertNotReleased();
        if (this._partialViewContext == null) {
            if (this._partialViewContextFactory == null) {
                this._partialViewContextFactory = (PartialViewContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.PartialViewContextFactory");
            }
            this._partialViewContext = this._partialViewContextFactory.getPartialViewContext(this.getCurrentFacesContext());
        }
        return this._partialViewContext;
    }

    public final boolean getRenderResponse() {
        this.assertNotReleased();
        return this._renderResponse;
    }

    public final void renderResponse() {
        this.assertNotReleased();
        this._renderResponse = true;
    }

    public final boolean getResponseComplete() {
        this.assertNotReleased();
        return this._responseComplete;
    }

    public final void responseComplete() {
        this.assertNotReleased();
        this._responseComplete = true;
    }

    public final void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        Assert.notNull(responseStream, "responseStream");
        this._responseStream = responseStream;
    }

    public final ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this._responseStream;
    }

    public final void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        Assert.notNull(responseWriter, "responseWriter");
        this._responseWriter = responseWriter;
    }

    public final ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this._responseWriter;
    }

    public boolean isPostback() {
        this.assertNotReleased();
        RenderKit renderKit = this.getRenderKit();
        FacesContext facesContext = this.getCurrentFacesContext();
        if (renderKit == null) {
            String renderKitId = facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext);
            if (this._renderKitFactory == null) {
                this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            }
            renderKit = this._renderKitFactory.getRenderKit(facesContext, renderKitId);
        }
        return renderKit.getResponseStateManager().isPostback(facesContext);
    }

    public void validationFailed() {
        this.assertNotReleased();
        this._validationFailed = true;
    }

    public boolean isValidationFailed() {
        this.assertNotReleased();
        return this._validationFailed;
    }
}

