/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.jsp;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.faces.FacesException;
import javax.faces.application.ViewVisitOption;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.ResponseStateManager;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.myfaces.application.viewstate.StateCacheUtils;
import org.apache.myfaces.view.ServletViewResponseWrapper;
import org.apache.myfaces.view.ViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.jsp.FaceletsOnlyException;
import org.apache.myfaces.view.jsp.JspViewDeclarationLanguageBase;
import org.apache.myfaces.view.jsp.JspViewDeclarationLanguageStrategy;

public class JspViewDeclarationLanguage
extends JspViewDeclarationLanguageBase {
    public static final Logger log = Logger.getLogger(JspViewDeclarationLanguage.class.getName());
    public static final String[] FACELETS_ONLY_F_TAGS = new String[]{"ajax", "event", "metadata"};
    public static final String[] FACELETS_ONLY_H_TAGS = new String[]{"outputScript", "outputStylesheet", "head", "body", "button", "link"};
    private final ViewDeclarationLanguageStrategy _strategy;
    private LinkedList<String> _suffixes;

    public JspViewDeclarationLanguage() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New JspViewDeclarationLanguage instance created");
        }
        this._strategy = new JspViewDeclarationLanguageStrategy();
    }

    public JspViewDeclarationLanguage(FacesContext facesContext, ViewDeclarationLanguageStrategy strategy, LinkedList<String> suffixes) {
        this._strategy = strategy;
        this._suffixes = suffixes;
    }

    @Override
    public void buildView(FacesContext context, UIViewRoot view) throws IOException {
        boolean errorResponse;
        super.buildView(context, view);
        ExternalContext externalContext = context.getExternalContext();
        ServletResponse response = (ServletResponse)externalContext.getResponse();
        ServletRequest request = (ServletRequest)externalContext.getRequest();
        Locale locale = view.getLocale();
        response.setLocale(locale);
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)context.getViewRoot().getLocale());
        String viewId = view.getViewId();
        ServletViewResponseWrapper wrappedResponse = new ServletViewResponseWrapper((HttpServletResponse)response);
        externalContext.setResponse((Object)wrappedResponse);
        try {
            externalContext.dispatch(viewId);
        }
        catch (FacesException e) {
            String message = e.getMessage();
            if (message != null) {
                if (message.contains("\"f\"") || message.contains("\"http://xmlns.jcp.org/jsf/core\"")) {
                    for (String tag : FACELETS_ONLY_F_TAGS) {
                        if (!message.contains('\"' + tag + '\"')) continue;
                        String exceptionMessage = "The tag f:" + tag + " is only available on facelets.";
                        throw new FacesException(exceptionMessage, (Throwable)new FaceletsOnlyException(exceptionMessage, e.getCause()));
                    }
                } else if (message.contains("\"h\"") || message.contains("\"http://xmlns.jcp.org/jsf/html\"")) {
                    for (String tag : FACELETS_ONLY_H_TAGS) {
                        if (!message.contains('\"' + tag + '\"')) continue;
                        String exceptionMessage = "The tag h:" + tag + " is only available on facelets.";
                        throw new FacesException(exceptionMessage, (Throwable)new FaceletsOnlyException(exceptionMessage, e.getCause()));
                    }
                } else {
                    String namespace = null;
                    if (message.contains("http://xmlns.jcp.org/jsf/facelets")) {
                        namespace = "http://xmlns.jcp.org/jsf/facelets";
                    } else if (message.contains("http://xmlns.jcp.org/jsf/composite")) {
                        namespace = "http://xmlns.jcp.org/jsf/composite";
                    }
                    if (namespace != null) {
                        String exceptionMessage = "All tags with namespace " + namespace + " are only available on facelets.";
                        throw new FacesException(exceptionMessage, (Throwable)new FaceletsOnlyException(exceptionMessage, e.getCause()));
                    }
                }
            }
            throw e;
        }
        finally {
            externalContext.setResponse((Object)response);
        }
        boolean bl = errorResponse = wrappedResponse.getStatus() < 200 || wrappedResponse.getStatus() > 299;
        if (errorResponse) {
            wrappedResponse.flushToWrappedResponse();
            return;
        }
        if (!context.getPartialViewContext().isPartialRequest()) {
            this.setAfterViewTagResponseWrapper(externalContext, wrappedResponse);
        }
        context.getApplication().publishEvent(context, PostAddToViewEvent.class, UIViewRoot.class, (Object)view);
    }

    @Override
    protected boolean isViewStateAlreadyEncoded(FacesContext context) {
        ResponseStateManager responseStateManager = context.getRenderKit().getResponseStateManager();
        if (StateCacheUtils.isMyFacesResponseStateManager(responseStateManager)) {
            return !StateCacheUtils.getMyFacesResponseStateManager(responseStateManager).isWriteStateAfterRenderViewRequired(context);
        }
        return false;
    }

    @Override
    protected void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    public boolean viewExists(FacesContext facesContext, String viewId) {
        if (this._strategy.handles(viewId)) {
            return super.viewExists(facesContext, viewId);
        }
        return false;
    }

    public Stream<String> getViews(FacesContext facesContext, String path, int maxDepth, ViewVisitOption ... options) {
        Stream<String> stream = super.getViews(facesContext, path, maxDepth, options);
        stream = stream.filter(f -> this._strategy.handles((String)f) && this.isValidJSPView(facesContext, (String)f));
        if (options != null && Arrays.binarySearch(options, ViewVisitOption.RETURN_AS_MINIMAL_IMPLICIT_OUTCOME) >= 0) {
            stream = stream.map(f -> this._strategy.getMinimalImplicitOutcome((String)f));
        }
        return stream;
    }

    private boolean isValidJSPView(FacesContext facesContext, String path) {
        boolean isValid = false;
        if (this._suffixes == null) {
            this._suffixes = JspViewDeclarationLanguageStrategy.loadSuffixes(facesContext.getExternalContext());
        }
        for (String suffix : this._suffixes) {
            if (path == null || !path.endsWith(suffix)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }
}

