/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlSelectOneRadio;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.SharedRendererUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlRadioRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlRadioRendererBase.class.getName());
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String LAYOUT_LIST = "list";
    private static final Set<VisitHint> FIND_SELECT_LIST_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_UNRENDERED, VisitHint.SKIP_ITERATION));
    private Map<String, UISelectOne> groupFirst = new HashMap<String, UISelectOne>();

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String group;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        UISelectOne selectOne = (UISelectOne)uiComponent;
        String layout = this.getLayout(selectOne);
        Boolean usingTable = Boolean.FALSE;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                usingTable = Boolean.TRUE;
            } else if (layout.equals(LINE_DIRECTION)) {
                usingTable = Boolean.FALSE;
            } else if (layout.equals(LAYOUT_LIST)) {
                usingTable = null;
            } else {
                log.severe("Wrong layout '" + layout + "' defined for component " + ComponentUtils.getPathToComponent(selectOne));
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        String string = group = selectOne instanceof HtmlSelectOneRadio ? selectOne.getGroup() : null;
        if (group != null && !group.isEmpty()) {
            List<SelectItem> selectItemList;
            if (!this.groupFirst.containsKey(group)) {
                this.groupFirst.put(group, selectOne);
            }
            if ((selectItemList = RendererUtils.getSelectItemList(selectOne, facesContext)) != null && !selectItemList.isEmpty()) {
                Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, selectOne);
                String currentValue = null;
                currentValue = selectOne.getValueExpression("value") != null ? RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(facesContext, selectOne) : RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(facesContext, this.groupFirst.get(group));
                SelectItem selectItem = selectItemList.get(0);
                this.renderGroupOrItemRadio(facesContext, selectOne, selectItem, currentValue, converter, usingTable, group, 0);
            } else {
                UIForm form = ComponentUtils.findClosest(UIForm.class, uiComponent);
                GetSelectItemListCallback callback = new GetSelectItemListCallback(selectOne, group);
                form.visitTree(VisitContext.createVisitContext(facesContext, null, FIND_SELECT_LIST_HINTS), callback);
                this.renderGroupOrItemRadio(facesContext, selectOne, callback.getSelectItem(), callback.getCurrentValue(), callback.getConverter(), usingTable, group, callback.getIndex());
            }
        } else {
            writer.startElement(usingTable != null ? "table" : "ul", selectOne);
            if (usingTable != null) {
                HtmlRendererUtils.renderHTMLAttributes(writer, selectOne, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, selectOne, HTML.UL_PASSTHROUGH_ATTRIBUTES);
            }
            if (behaviors != null && !behaviors.isEmpty()) {
                writer.writeAttribute("id", selectOne.getClientId(facesContext), null);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, selectOne, facesContext);
            }
            if (usingTable == Boolean.FALSE) {
                writer.startElement("tr", null);
            }
            List<SelectItem> selectItemList = RendererUtils.getSelectItemList(selectOne, facesContext);
            Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, selectOne);
            String currentValue = RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(facesContext, selectOne);
            int itemNum = 0;
            for (int i = 0; i < selectItemList.size(); ++i) {
                SelectItem selectItem = selectItemList.get(i);
                itemNum = this.renderGroupOrItemRadio(facesContext, selectOne, selectItem, currentValue, converter, usingTable, itemNum);
            }
            if (usingTable == Boolean.FALSE) {
                writer.endElement("tr");
            }
            writer.endElement(usingTable != null ? "table" : "ul");
        }
    }

    protected String getLayout(UIComponent selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getLayout();
        }
        return (String)selectOne.getAttributes().get("layout");
    }

    protected String getStyleClass(UISelectOne selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getStyleClass();
        }
        return (String)selectOne.getAttributes().get("styleClass");
    }

    protected int renderGroupOrItemRadio(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Object currentValue, Converter converter, Boolean usingTable, Integer itemNum) throws IOException {
        return this.renderGroupOrItemRadio(facesContext, uiComponent, selectItem, currentValue, converter, usingTable, null, itemNum);
    }

    protected int renderGroupOrItemRadio(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Object currentValue, Converter converter, Boolean usingTable, String group, Integer itemNum) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        UISelectOne selectOne = (UISelectOne)uiComponent;
        if (isSelectItemGroup) {
            SelectItem[] selectItems;
            if (usingTable == Boolean.TRUE) {
                writer.startElement("tr", null);
            }
            writer.startElement(usingTable != null ? "td" : "li", null);
            if (selectItem.isEscape()) {
                writer.writeText(selectItem.getLabel(), "label");
            } else {
                writer.write(selectItem.getLabel());
            }
            if (usingTable != null) {
                writer.endElement("td");
            }
            if (usingTable == Boolean.TRUE) {
                writer.endElement("tr");
                writer.startElement("tr", null);
            }
            if (usingTable != null) {
                writer.startElement("td", null);
            }
            writer.startElement(usingTable != null ? "table" : "ul", null);
            if (usingTable != null) {
                int border = 0;
                Object borderObj = uiComponent.getAttributes().get("border");
                if (null != borderObj) {
                    border = (Integer)borderObj;
                }
                if (Integer.MIN_VALUE != border) {
                    writer.writeAttribute("border", border, "border");
                }
            }
            if (usingTable == Boolean.FALSE) {
                writer.startElement("tr", null);
            }
            SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
            for (SelectItem groupSelectItem : selectItems = selectItemGroup.getSelectItems()) {
                itemNum = this.renderGroupOrItemRadio(facesContext, selectOne, groupSelectItem, currentValue, converter, usingTable, itemNum);
            }
            if (usingTable == Boolean.FALSE) {
                writer.endElement("tr");
            }
            writer.endElement(usingTable != null ? "table" : "ul");
            writer.endElement(usingTable != null ? "td" : "li");
            if (usingTable == Boolean.TRUE) {
                writer.endElement("tr");
            }
        } else {
            boolean itemChecked;
            String itemStrValue = SharedRendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectOne, converter, selectItem.getValue());
            boolean bl = itemStrValue == null ? itemStrValue == currentValue : ("".equals(itemStrValue) ? currentValue == null || itemStrValue.equals(currentValue) : (itemChecked = itemStrValue.equals(currentValue)));
            if (HtmlRendererUtils.isHideNoSelectionOption(uiComponent) && selectItem.isNoSelectionOption() && currentValue != null && !"".equals(currentValue) && !itemChecked) {
                return itemNum;
            }
            boolean renderGroupId = false;
            if (group != null && !group.isEmpty()) {
                renderGroupId = true;
            } else {
                if (usingTable == Boolean.TRUE) {
                    writer.startElement("tr", null);
                }
                writer.startElement(usingTable != null ? "td" : "li", null);
            }
            boolean itemDisabled = selectItem.isDisabled();
            String itemId = this.renderRadio(facesContext, selectOne, itemStrValue, itemDisabled, itemChecked, renderGroupId, renderGroupId ? null : itemNum);
            boolean componentDisabled = this.isDisabled(facesContext, selectOne);
            boolean disabled = componentDisabled || itemDisabled;
            HtmlRendererUtils.renderLabel(writer, selectOne, renderGroupId ? selectOne.getClientId(facesContext) : itemId, selectItem, disabled);
            if (group == null || group.length() <= 0) {
                writer.endElement(usingTable != null ? "td" : "li");
                if (usingTable == Boolean.TRUE) {
                    writer.endElement("tr");
                }
            }
            Integer n = itemNum;
            Integer n2 = itemNum = Integer.valueOf(itemNum + 1);
        }
        return itemNum;
    }

    protected String renderRadio(FacesContext facesContext, UIInput uiComponent, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String group;
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = itemNum == null ? null : clientId + facesContext.getNamingContainerSeparatorChar() + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", itemId, null);
        } else if (renderId) {
            writer.writeAttribute("id", clientId, null);
        }
        writer.writeAttribute("type", "radio", null);
        String string = group = uiComponent instanceof HtmlSelectOneRadio ? ((HtmlSelectOneRadio)uiComponent).getGroup() : null;
        if (group != null && !group.isEmpty()) {
            UIForm form = ComponentUtils.findClosest(UIForm.class, uiComponent);
            writer.writeAttribute("name", form.getClientId(facesContext) + facesContext.getNamingContainerSeparatorChar() + group, null);
        } else {
            writer.writeAttribute("name", clientId, null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        if (checked) {
            writer.writeAttribute("checked", "checked", null);
        }
        if (group != null && group.length() > 0) {
            if (value != null) {
                writer.writeAttribute("value", clientId + facesContext.getNamingContainerSeparatorChar() + value, null);
            } else {
                writer.writeAttribute("value", clientId + facesContext.getNamingContainerSeparatorChar(), null);
            }
        } else if (value != null) {
            writer.writeAttribute("value", value, null);
        } else {
            writer.writeAttribute("value", "", null);
        }
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderChangeEventProperty(writer, commonPropertiesMarked, uiComponent);
                CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                CommonHtmlAttributesUtil.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, uiComponent);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    long commonEventsMarked = CommonHtmlEventsUtil.getMarkedEvents(uiComponent);
                    CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                    CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, (String)(itemId != null ? itemId : clientId), behaviors);
                }
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        writer.endElement("input");
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)uiComponent).isDisabled();
        }
        return AttributeUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UIInput) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        }
        if (uiComponent instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(uiComponent)) {
            ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        return RendererUtils.getConvertedUISelectOneValue(facesContext, (UISelectOne)uiComponent, submittedValue);
    }

    private static class GetSelectItemListCallback
    implements VisitCallback {
        private final UISelectOne selectOneRadio;
        private final String group;
        private final List<UISelectOne> selectOneRadios;
        private int index;
        private SelectItem selectItem;
        private Converter converter;
        private Object currentValue;

        public GetSelectItemListCallback(UISelectOne selectOneRadio, String group) {
            this.selectOneRadio = selectOneRadio;
            this.group = group;
            this.selectOneRadios = new ArrayList<UISelectOne>();
        }

        @Override
        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target instanceof UISelectOne) {
                UISelectOne targetSelectOneRadio = (UISelectOne)target;
                String targetGroup = targetSelectOneRadio.getGroup();
                if (this.group.equals(targetGroup)) {
                    this.selectOneRadios.add(targetSelectOneRadio);
                    this.index = this.selectOneRadios.indexOf(this.selectOneRadio);
                    if (this.index != -1) {
                        UISelectOne first = this.selectOneRadios.get(0);
                        List<SelectItem> selectItemList = RendererUtils.getSelectItemList(first, context.getFacesContext());
                        if (selectItemList == null || selectItemList.isEmpty()) {
                            throw new FacesException("UISelectOne with id=\"" + first.getId() + "\" and group=\"" + this.group + "\" does not have any UISelectItems!");
                        }
                        this.selectItem = selectItemList.get(this.index);
                        this.converter = HtmlRendererUtils.findUIOutputConverterFailSafe(context.getFacesContext(), first);
                        this.currentValue = RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(context.getFacesContext(), first);
                        return VisitResult.COMPLETE;
                    }
                    return VisitResult.REJECT;
                }
                return VisitResult.REJECT;
            }
            return VisitResult.ACCEPT;
        }

        public int getIndex() {
            return this.index;
        }

        public SelectItem getSelectItem() {
            return this.selectItem;
        }

        public Converter getConverter() {
            return this.converter;
        }

        public Object getCurrentValue() {
            return this.currentValue;
        }
    }
}

